/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.team.TeamMemberInfoV2;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class MembersGetInfoItemV2 {
    public static final MembersGetInfoItemV2 OTHER = new MembersGetInfoItemV2().withTag(Tag.OTHER);
    private Tag _tag;
    private String idNotFoundValue;
    private TeamMemberInfoV2 memberInfoValue;

    private MembersGetInfoItemV2() {
    }

    private MembersGetInfoItemV2 withTag(Tag _tag) {
        MembersGetInfoItemV2 result = new MembersGetInfoItemV2();
        result._tag = _tag;
        return result;
    }

    private MembersGetInfoItemV2 withTagAndIdNotFound(Tag _tag, String idNotFoundValue) {
        MembersGetInfoItemV2 result = new MembersGetInfoItemV2();
        result._tag = _tag;
        result.idNotFoundValue = idNotFoundValue;
        return result;
    }

    private MembersGetInfoItemV2 withTagAndMemberInfo(Tag _tag, TeamMemberInfoV2 memberInfoValue) {
        MembersGetInfoItemV2 result = new MembersGetInfoItemV2();
        result._tag = _tag;
        result.memberInfoValue = memberInfoValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isIdNotFound() {
        return this._tag == Tag.ID_NOT_FOUND;
    }

    public static MembersGetInfoItemV2 idNotFound(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new MembersGetInfoItemV2().withTagAndIdNotFound(Tag.ID_NOT_FOUND, value);
    }

    public String getIdNotFoundValue() {
        if (this._tag != Tag.ID_NOT_FOUND) {
            throw new IllegalStateException("Invalid tag: required Tag.ID_NOT_FOUND, but was Tag." + this._tag.name());
        }
        return this.idNotFoundValue;
    }

    public boolean isMemberInfo() {
        return this._tag == Tag.MEMBER_INFO;
    }

    public static MembersGetInfoItemV2 memberInfo(TeamMemberInfoV2 value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new MembersGetInfoItemV2().withTagAndMemberInfo(Tag.MEMBER_INFO, value);
    }

    public TeamMemberInfoV2 getMemberInfoValue() {
        if (this._tag != Tag.MEMBER_INFO) {
            throw new IllegalStateException("Invalid tag: required Tag.MEMBER_INFO, but was Tag." + this._tag.name());
        }
        return this.memberInfoValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.idNotFoundValue, this.memberInfoValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof MembersGetInfoItemV2) {
            MembersGetInfoItemV2 other = (MembersGetInfoItemV2)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case ID_NOT_FOUND: {
                    return this.idNotFoundValue == other.idNotFoundValue || this.idNotFoundValue.equals(other.idNotFoundValue);
                }
                case MEMBER_INFO: {
                    return this.memberInfoValue == other.memberInfoValue || this.memberInfoValue.equals(other.memberInfoValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<MembersGetInfoItemV2> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MembersGetInfoItemV2 value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case ID_NOT_FOUND: {
                    g.writeStartObject();
                    this.writeTag("id_not_found", g);
                    g.writeFieldName("id_not_found");
                    StoneSerializers.string().serialize(value.idNotFoundValue, g);
                    g.writeEndObject();
                    break;
                }
                case MEMBER_INFO: {
                    g.writeStartObject();
                    this.writeTag("member_info", g);
                    TeamMemberInfoV2.Serializer.INSTANCE.serialize(value.memberInfoValue, g, true);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public MembersGetInfoItemV2 deserialize(JsonParser p) throws IOException, JsonParseException {
            MembersGetInfoItemV2 value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("id_not_found".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("id_not_found", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MembersGetInfoItemV2.idNotFound(fieldValue);
            } else if ("member_info".equals(tag)) {
                TeamMemberInfoV2 fieldValue = null;
                fieldValue = TeamMemberInfoV2.Serializer.INSTANCE.deserialize(p, true);
                value = MembersGetInfoItemV2.memberInfo(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        ID_NOT_FOUND,
        MEMBER_INFO,
        OTHER;

    }
}

