/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.PathOrLink;
import com.dropbox.core.v2.files.ThumbnailFormat;
import com.dropbox.core.v2.files.ThumbnailMode;
import com.dropbox.core.v2.files.ThumbnailSize;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;

class ThumbnailV2Arg {
    @Nonnull
    protected final PathOrLink resource;
    @Nonnull
    protected final ThumbnailFormat format;
    @Nonnull
    protected final ThumbnailSize size;
    @Nonnull
    protected final ThumbnailMode mode;

    public ThumbnailV2Arg(@Nonnull PathOrLink resource, @Nonnull ThumbnailFormat format, @Nonnull ThumbnailSize size, @Nonnull ThumbnailMode mode) {
        if (resource == null) {
            throw new IllegalArgumentException("Required value for 'resource' is null");
        }
        this.resource = resource;
        if (format == null) {
            throw new IllegalArgumentException("Required value for 'format' is null");
        }
        this.format = format;
        if (size == null) {
            throw new IllegalArgumentException("Required value for 'size' is null");
        }
        this.size = size;
        if (mode == null) {
            throw new IllegalArgumentException("Required value for 'mode' is null");
        }
        this.mode = mode;
    }

    public ThumbnailV2Arg(@Nonnull PathOrLink resource) {
        this(resource, ThumbnailFormat.JPEG, ThumbnailSize.W64H64, ThumbnailMode.STRICT);
    }

    @Nonnull
    public PathOrLink getResource() {
        return this.resource;
    }

    @Nonnull
    public ThumbnailFormat getFormat() {
        return this.format;
    }

    @Nonnull
    public ThumbnailSize getSize() {
        return this.size;
    }

    @Nonnull
    public ThumbnailMode getMode() {
        return this.mode;
    }

    public static Builder newBuilder(PathOrLink resource) {
        return new Builder(resource);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.resource, this.format, this.size, this.mode});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ThumbnailV2Arg other = (ThumbnailV2Arg)obj;
            return !(this.resource != other.resource && !this.resource.equals(other.resource) || this.format != other.format && !this.format.equals((Object)other.format) || this.size != other.size && !this.size.equals((Object)other.size) || this.mode != other.mode && !this.mode.equals((Object)other.mode));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ThumbnailV2Arg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ThumbnailV2Arg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("resource");
            PathOrLink.Serializer.INSTANCE.serialize(value.resource, g);
            g.writeFieldName("format");
            ThumbnailFormat.Serializer.INSTANCE.serialize(value.format, g);
            g.writeFieldName("size");
            ThumbnailSize.Serializer.INSTANCE.serialize(value.size, g);
            g.writeFieldName("mode");
            ThumbnailMode.Serializer.INSTANCE.serialize(value.mode, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public ThumbnailV2Arg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            ThumbnailMode f_mode;
            ThumbnailSize f_size;
            ThumbnailFormat f_format;
            PathOrLink f_resource;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_resource = null;
                f_format = ThumbnailFormat.JPEG;
                f_size = ThumbnailSize.W64H64;
                f_mode = ThumbnailMode.STRICT;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("resource".equals(field)) {
                        f_resource = PathOrLink.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("format".equals(field)) {
                        f_format = ThumbnailFormat.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("size".equals(field)) {
                        f_size = ThumbnailSize.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("mode".equals(field)) {
                        f_mode = ThumbnailMode.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_resource == null) {
                    throw new JsonParseException(p, "Required field \"resource\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ThumbnailV2Arg value = new ThumbnailV2Arg(f_resource, f_format, f_size, f_mode);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final PathOrLink resource;
        protected ThumbnailFormat format;
        protected ThumbnailSize size;
        protected ThumbnailMode mode;

        protected Builder(PathOrLink resource) {
            if (resource == null) {
                throw new IllegalArgumentException("Required value for 'resource' is null");
            }
            this.resource = resource;
            this.format = ThumbnailFormat.JPEG;
            this.size = ThumbnailSize.W64H64;
            this.mode = ThumbnailMode.STRICT;
        }

        public Builder withFormat(ThumbnailFormat format) {
            this.format = format != null ? format : ThumbnailFormat.JPEG;
            return this;
        }

        public Builder withSize(ThumbnailSize size) {
            this.size = size != null ? size : ThumbnailSize.W64H64;
            return this;
        }

        public Builder withMode(ThumbnailMode mode) {
            this.mode = mode != null ? mode : ThumbnailMode.STRICT;
            return this;
        }

        public ThumbnailV2Arg build() {
            return new ThumbnailV2Arg(this.resource, this.format, this.size, this.mode);
        }
    }
}

