/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum PaperCreateError {
    INSUFFICIENT_PERMISSIONS,
    CONTENT_MALFORMED,
    DOC_LENGTH_EXCEEDED,
    IMAGE_SIZE_EXCEEDED,
    OTHER,
    INVALID_PATH,
    EMAIL_UNVERIFIED,
    INVALID_FILE_EXTENSION,
    PAPER_DISABLED;


    static class Serializer
    extends UnionSerializer<PaperCreateError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PaperCreateError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case INSUFFICIENT_PERMISSIONS: {
                    g.writeString("insufficient_permissions");
                    break;
                }
                case CONTENT_MALFORMED: {
                    g.writeString("content_malformed");
                    break;
                }
                case DOC_LENGTH_EXCEEDED: {
                    g.writeString("doc_length_exceeded");
                    break;
                }
                case IMAGE_SIZE_EXCEEDED: {
                    g.writeString("image_size_exceeded");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                    break;
                }
                case INVALID_PATH: {
                    g.writeString("invalid_path");
                    break;
                }
                case EMAIL_UNVERIFIED: {
                    g.writeString("email_unverified");
                    break;
                }
                case INVALID_FILE_EXTENSION: {
                    g.writeString("invalid_file_extension");
                    break;
                }
                case PAPER_DISABLED: {
                    g.writeString("paper_disabled");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value));
                }
            }
        }

        @Override
        public PaperCreateError deserialize(JsonParser p) throws IOException, JsonParseException {
            PaperCreateError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("insufficient_permissions".equals(tag)) {
                value = INSUFFICIENT_PERMISSIONS;
            } else if ("content_malformed".equals(tag)) {
                value = CONTENT_MALFORMED;
            } else if ("doc_length_exceeded".equals(tag)) {
                value = DOC_LENGTH_EXCEEDED;
            } else if ("image_size_exceeded".equals(tag)) {
                value = IMAGE_SIZE_EXCEEDED;
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else if ("invalid_path".equals(tag)) {
                value = INVALID_PATH;
            } else if ("email_unverified".equals(tag)) {
                value = EMAIL_UNVERIFIED;
            } else if ("invalid_file_extension".equals(tag)) {
                value = INVALID_FILE_EXTENSION;
            } else if ("paper_disabled".equals(tag)) {
                value = PAPER_DISABLED;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

