/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxWrappedException;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxAppGetThumbnailV2Builder;
import com.dropbox.core.v2.files.DbxAppListFolderBuilder;
import com.dropbox.core.v2.files.ListFolderArg;
import com.dropbox.core.v2.files.ListFolderContinueArg;
import com.dropbox.core.v2.files.ListFolderContinueError;
import com.dropbox.core.v2.files.ListFolderContinueErrorException;
import com.dropbox.core.v2.files.ListFolderError;
import com.dropbox.core.v2.files.ListFolderErrorException;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.files.PathOrLink;
import com.dropbox.core.v2.files.PreviewResult;
import com.dropbox.core.v2.files.ThumbnailV2Arg;
import com.dropbox.core.v2.files.ThumbnailV2Error;
import com.dropbox.core.v2.files.ThumbnailV2ErrorException;
import java.util.Collections;
import java.util.List;

public class DbxAppFilesRequests {
    private final DbxRawClientV2 client;

    public DbxAppFilesRequests(DbxRawClientV2 client) {
        this.client = client;
    }

    DbxDownloader<PreviewResult> getThumbnailV2(ThumbnailV2Arg arg, List<HttpRequestor.Header> _headers) throws ThumbnailV2ErrorException, DbxException {
        try {
            return this.client.downloadStyle(this.client.getHost().getContent(), "2/files/get_thumbnail_v2", arg, false, _headers, ThumbnailV2Arg.Serializer.INSTANCE, PreviewResult.Serializer.INSTANCE, ThumbnailV2Error.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new ThumbnailV2ErrorException("2/files/get_thumbnail_v2", ex.getRequestId(), ex.getUserMessage(), (ThumbnailV2Error)ex.getErrorValue());
        }
    }

    public DbxDownloader<PreviewResult> getThumbnailV2(PathOrLink resource) throws ThumbnailV2ErrorException, DbxException {
        ThumbnailV2Arg _arg = new ThumbnailV2Arg(resource);
        return this.getThumbnailV2(_arg, Collections.emptyList());
    }

    public DbxAppGetThumbnailV2Builder getThumbnailV2Builder(PathOrLink resource) {
        ThumbnailV2Arg.Builder argBuilder_ = ThumbnailV2Arg.newBuilder(resource);
        return new DbxAppGetThumbnailV2Builder(this, argBuilder_);
    }

    ListFolderResult listFolder(ListFolderArg arg) throws ListFolderErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/list_folder", arg, false, ListFolderArg.Serializer.INSTANCE, ListFolderResult.Serializer.INSTANCE, ListFolderError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new ListFolderErrorException("2/files/list_folder", ex.getRequestId(), ex.getUserMessage(), (ListFolderError)ex.getErrorValue());
        }
    }

    public ListFolderResult listFolder(String path) throws ListFolderErrorException, DbxException {
        ListFolderArg _arg = new ListFolderArg(path);
        return this.listFolder(_arg);
    }

    public DbxAppListFolderBuilder listFolderBuilder(String path) {
        ListFolderArg.Builder argBuilder_ = ListFolderArg.newBuilder(path);
        return new DbxAppListFolderBuilder(this, argBuilder_);
    }

    ListFolderResult listFolderContinue(ListFolderContinueArg arg) throws ListFolderContinueErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(), "2/files/list_folder/continue", arg, false, ListFolderContinueArg.Serializer.INSTANCE, ListFolderResult.Serializer.INSTANCE, ListFolderContinueError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new ListFolderContinueErrorException("2/files/list_folder/continue", ex.getRequestId(), ex.getUserMessage(), (ListFolderContinueError)ex.getErrorValue());
        }
    }

    public ListFolderResult listFolderContinue(String cursor) throws ListFolderContinueErrorException, DbxException {
        ListFolderContinueArg _arg = new ListFolderContinueArg(cursor);
        return this.listFolderContinue(_arg);
    }
}

