/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.numberrange;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.numberrange.NumberRangeMeta;
import org.apache.hop.pipeline.transforms.numberrange.NumberRangeRule;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class NumberRangeDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = NumberRangeMeta.class;
    private final NumberRangeMeta input;
    private CCombo inputFieldControl;
    private Text outputFieldControl;
    private Text fallBackValueControl;
    private TableView rulesControl;

    public NumberRangeDialog(Shell parent, IVariables variables, NumberRangeMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"NumberRangeDialog.Title", (String[])new String[0]));
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)PropsUi.getMargin(), null);
        this.wTransformName = this.createLine(lsMod, BaseMessages.getString(PKG, (String)"NumberRangeDialog.TransformName", (String[])new String[0]), null);
        this.inputFieldControl = this.createLineCombo(lsMod, BaseMessages.getString(PKG, (String)"NumberRangeDialog.InputField", (String[])new String[0]), (Control)this.wTransformName);
        this.outputFieldControl = this.createLine(lsMod, BaseMessages.getString(PKG, (String)"NumberRangeDialog.OutputField", (String[])new String[0]), (Control)this.inputFieldControl);
        this.inputFieldControl.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)NumberRangeDialog.this.shell.getDisplay(), 1);
                NumberRangeDialog.this.shell.setCursor(busy);
                NumberRangeDialog.this.loadComboOptions();
                NumberRangeDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.fallBackValueControl = this.createLine(lsMod, BaseMessages.getString(PKG, (String)"NumberRangeDialog.DefaultValue", (String[])new String[0]), (Control)this.outputFieldControl);
        this.createRulesTable(lsMod);
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void createRulesTable(ModifyListener lsMod) {
        Label rulesLable = new Label((Composite)this.shell, 0);
        rulesLable.setText(BaseMessages.getString(PKG, (String)"NumberRangeDialog.Ranges", (String[])new String[0]));
        PropsUi.setLook((Widget)rulesLable);
        FormData lableFormData = new FormData();
        lableFormData.left = new FormAttachment(0, 0);
        lableFormData.right = new FormAttachment(this.props.getMiddlePct(), -PropsUi.getMargin());
        lableFormData.top = new FormAttachment((Control)this.fallBackValueControl, PropsUi.getMargin());
        rulesLable.setLayoutData((Object)lableFormData);
        int FieldsRows = this.input.getRules().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"NumberRangeDialog.LowerBound", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"NumberRangeDialog.UpperBound", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"NumberRangeDialog.Value", (String[])new String[0]), 1, false)};
        this.rulesControl = new TableView(this.variables, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)rulesLable, PropsUi.getMargin());
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * PropsUi.getMargin());
        this.rulesControl.setLayoutData((Object)fdFields);
    }

    private Text createLine(ModifyListener lsMod, String lableText, Control prevControl) {
        Label lable = new Label((Composite)this.shell, 131072);
        lable.setText(lableText);
        PropsUi.setLook((Widget)lable);
        FormData lableFormData = new FormData();
        lableFormData.left = new FormAttachment(0, 0);
        lableFormData.right = new FormAttachment(this.props.getMiddlePct(), -PropsUi.getMargin());
        lableFormData.top = prevControl != null ? new FormAttachment(prevControl, PropsUi.getMargin()) : new FormAttachment(0, PropsUi.getMargin());
        lable.setLayoutData((Object)lableFormData);
        Text control = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)control);
        control.addModifyListener(lsMod);
        FormData widgetFormData = new FormData();
        widgetFormData.left = new FormAttachment(this.props.getMiddlePct(), 0);
        widgetFormData.top = prevControl != null ? new FormAttachment(prevControl, PropsUi.getMargin()) : new FormAttachment(0, PropsUi.getMargin());
        widgetFormData.right = new FormAttachment(100, 0);
        control.setLayoutData((Object)widgetFormData);
        return control;
    }

    private CCombo createLineCombo(ModifyListener lsMod, String lableText, Control prevControl) {
        Label lable = new Label((Composite)this.shell, 131072);
        lable.setText(lableText);
        PropsUi.setLook((Widget)lable);
        FormData lableFormData = new FormData();
        lableFormData.left = new FormAttachment(0, 0);
        lableFormData.right = new FormAttachment(this.props.getMiddlePct(), -PropsUi.getMargin());
        lableFormData.top = prevControl != null ? new FormAttachment(prevControl, PropsUi.getMargin()) : new FormAttachment(0, PropsUi.getMargin());
        lable.setLayoutData((Object)lableFormData);
        CCombo control = new CCombo((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)control);
        control.addModifyListener(lsMod);
        FormData widgetFormData = new FormData();
        widgetFormData.left = new FormAttachment(this.props.getMiddlePct(), 0);
        widgetFormData.top = prevControl != null ? new FormAttachment(prevControl, PropsUi.getMargin()) : new FormAttachment(0, PropsUi.getMargin());
        widgetFormData.right = new FormAttachment(100, 0);
        control.setLayoutData((Object)widgetFormData);
        return control;
    }

    public void getData() {
        String fallBackValue;
        String outputField;
        this.wTransformName.setText(this.transformName);
        String inputField = this.input.getInputField();
        if (inputField != null) {
            this.inputFieldControl.setText(inputField);
        }
        if ((outputField = this.input.getOutputField()) != null) {
            this.outputFieldControl.setText(outputField);
        }
        if ((fallBackValue = this.input.getFallBackValue()) != null) {
            this.fallBackValueControl.setText(fallBackValue);
        }
        for (int i = 0; i < this.input.getRules().size(); ++i) {
            NumberRangeRule rule = this.input.getRules().get(i);
            TableItem item = this.rulesControl.table.getItem(i);
            item.setText(1, Const.NVL((String)rule.getLowerBound(), (String)""));
            item.setText(2, Const.NVL((String)rule.getUpperBound(), (String)""));
            item.setText(3, Const.NVL((String)rule.getValue(), (String)""));
        }
        this.rulesControl.setRowNums();
        this.rulesControl.optWidth(true);
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setInputField(this.inputFieldControl.getText());
        this.input.setOutputField(this.outputFieldControl.getText());
        this.input.setFallBackValue(this.fallBackValueControl.getText());
        this.input.emptyRules();
        int count = this.rulesControl.nrNonEmpty();
        for (int i = 0; i < count; ++i) {
            TableItem item = this.rulesControl.getNonEmpty(i);
            String lowerBoundStr = item.getText(1);
            String upperBoundStr = item.getText(2);
            String value = item.getText(3);
            this.input.addRule(lowerBoundStr, upperBoundStr, value);
        }
        this.dispose();
    }

    private void loadComboOptions() {
        try {
            IRowMeta r;
            String fieldvalue = null;
            if (this.inputFieldControl.getText() != null) {
                fieldvalue = this.inputFieldControl.getText();
            }
            if ((r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName)) != null) {
                this.inputFieldControl.setItems(r.getFieldNames());
            }
            if (fieldvalue != null) {
                this.inputFieldControl.setText(fieldvalue);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"NumberRangeDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"NumberRangeDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

