/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.groovy.util

import org.junit.Test

class MapsTest {

    @Test
    void inverse() {
        Map<String, Integer> map = Maps.of("a", 1, "b", 2, "c", 3)
        Map<Integer, String> inversedMap = Maps.inverse(map)

        assert map.size() == inversedMap.size()
        for (Map.Entry<Integer, String> entry : inversedMap.entrySet()) {
            assert map.get(entry.getValue()) == entry.getKey()
        }

        try {
            Maps.inverse(Maps.of("a", 1, "b", 2, "c", 2))
        } catch (IllegalArgumentException e) {
            assert e.getMessage().contains("duplicated key found: 2")
        }

        Map<Integer, String> inversedMap2 = Maps.inverse(Maps.of("a", 1, "b", 2, "c", 2), true)
        assert 2 == inversedMap2.size()
        assert "a" == inversedMap2.get(1)
        assert "c" == inversedMap2.get(2)
    }

    @Test
    void of1() {
        assert ['1': 1] == Maps.of('1', 1)
    }

    @Test
    void of2() {
        assert ['1': 1, '2': 2] == Maps.of('1', 1, '2', 2)
    }

    @Test
    void of3() {
        assert ['1': 1, '2': 2, '3': 3] == Maps.of('1', 1, '2', 2, '3', 3)
    }

    @Test
    void of4() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4)
    }

    @Test
    void of5() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5)
    }

    @Test
    void of6() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6)
    }

    @Test
    void of7() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7)
    }

    @Test
    void of8() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8)
    }

    @Test
    void of9() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9)
    }

    @Test
    void of10() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10)
    }

    @Test
    void of11() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11)
    }

    @Test
    void of12() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12)
    }

    @Test
    void of13() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13)
    }

    @Test
    void of14() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14)
    }

    @Test
    void of15() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15)
    }

    @Test
    void of16() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16)
    }

    @Test
    void of17() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17)
    }

    @Test
    void of18() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18)
    }

    @Test
    void of19() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19)
    }

    @Test
    void of20() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20)
    }

    @Test
    void of21() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21)
    }

    @Test
    void of22() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22)
    }

    @Test
    void of23() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23)
    }

    @Test
    void of24() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24)
    }

    @Test
    void of25() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25)
    }

    @Test
    void of26() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26)
    }

    @Test
    void of27() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27)
    }

    @Test
    void of28() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28)
    }

    @Test
    void of29() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29)
    }

    @Test
    void of30() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30)
    }

    @Test
    void of31() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31)
    }

    @Test
    void of32() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32)
    }

    @Test
    void of33() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33)
    }

    @Test
    void of34() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34)
    }

    @Test
    void of35() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35)
    }

    @Test
    void of36() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36)
    }

    @Test
    void of37() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37)
    }

    @Test
    void of38() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38)
    }

    @Test
    void of39() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39)
    }

    @Test
    void of40() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40)
    }

    @Test
    void of41() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41)
    }

    @Test
    void of42() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42)
    }

    @Test
    void of43() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43)
    }

    @Test
    void of44() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44)
    }

    @Test
    void of45() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45)
    }

    @Test
    void of46() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46)
    }

    @Test
    void of47() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47)
    }

    @Test
    void of48() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48)
    }

    @Test
    void of49() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49)
    }

    @Test
    void of50() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50)
    }

    @Test
    void of51() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51)
    }

    @Test
    void of52() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52)
    }

    @Test
    void of53() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53)
    }

    @Test
    void of54() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54)
    }

    @Test
    void of55() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55)
    }

    @Test
    void of56() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56)
    }

    @Test
    void of57() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57)
    }

    @Test
    void of58() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58)
    }

    @Test
    void of59() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59)
    }

    @Test
    void of60() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60)
    }

    @Test
    void of61() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61)
    }

    @Test
    void of62() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62)
    }

    @Test
    void of63() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63)
    }

    @Test
    void of64() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64)
    }

    @Test
    void of65() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65)
    }

    @Test
    void of66() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66)
    }

    @Test
    void of67() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67)
    }

    @Test
    void of68() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68)
    }

    @Test
    void of69() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69)
    }

    @Test
    void of70() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70)
    }

    @Test
    void of71() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71)
    }

    @Test
    void of72() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72)
    }

    @Test
    void of73() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73)
    }

    @Test
    void of74() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74)
    }

    @Test
    void of75() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75)
    }

    @Test
    void of76() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76)
    }

    @Test
    void of77() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77)
    }

    @Test
    void of78() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78)
    }

    @Test
    void of79() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79)
    }

    @Test
    void of80() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80)
    }

    @Test
    void of81() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81)
    }

    @Test
    void of82() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82)
    }

    @Test
    void of83() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83)
    }

    @Test
    void of84() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84)
    }

    @Test
    void of85() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84, '85': 85] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84, '85', 85)
    }

    @Test
    void of86() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84, '85': 85, '86': 86] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84, '85', 85, '86', 86)
    }

    @Test
    void of87() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84, '85': 85, '86': 86, '87': 87] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84, '85', 85, '86', 86, '87', 87)
    }

    @Test
    void of88() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84, '85': 85, '86': 86, '87': 87, '88': 88] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84, '85', 85, '86', 86, '87', 87, '88', 88)
    }

    @Test
    void of89() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84, '85': 85, '86': 86, '87': 87, '88': 88, '89': 89] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84, '85', 85, '86', 86, '87', 87, '88', 88, '89', 89)
    }

    @Test
    void of90() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84, '85': 85, '86': 86, '87': 87, '88': 88, '89': 89, '90': 90] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84, '85', 85, '86', 86, '87', 87, '88', 88, '89', 89, '90', 90)
    }

    @Test
    void of91() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84, '85': 85, '86': 86, '87': 87, '88': 88, '89': 89, '90': 90, '91': 91] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84, '85', 85, '86', 86, '87', 87, '88', 88, '89', 89, '90', 90, '91', 91)
    }

    @Test
    void of92() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84, '85': 85, '86': 86, '87': 87, '88': 88, '89': 89, '90': 90, '91': 91, '92': 92] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84, '85', 85, '86', 86, '87', 87, '88', 88, '89', 89, '90', 90, '91', 91, '92', 92)
    }

    @Test
    void of93() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84, '85': 85, '86': 86, '87': 87, '88': 88, '89': 89, '90': 90, '91': 91, '92': 92, '93': 93] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84, '85', 85, '86', 86, '87', 87, '88', 88, '89', 89, '90', 90, '91', 91, '92', 92, '93', 93)
    }

    @Test
    void of94() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84, '85': 85, '86': 86, '87': 87, '88': 88, '89': 89, '90': 90, '91': 91, '92': 92, '93': 93, '94': 94] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84, '85', 85, '86', 86, '87', 87, '88', 88, '89', 89, '90', 90, '91', 91, '92', 92, '93', 93, '94', 94)
    }

    @Test
    void of95() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84, '85': 85, '86': 86, '87': 87, '88': 88, '89': 89, '90': 90, '91': 91, '92': 92, '93': 93, '94': 94, '95': 95] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84, '85', 85, '86', 86, '87', 87, '88', 88, '89', 89, '90', 90, '91', 91, '92', 92, '93', 93, '94', 94, '95', 95)
    }

    @Test
    void of96() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84, '85': 85, '86': 86, '87': 87, '88': 88, '89': 89, '90': 90, '91': 91, '92': 92, '93': 93, '94': 94, '95': 95, '96': 96] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84, '85', 85, '86', 86, '87', 87, '88', 88, '89', 89, '90', 90, '91', 91, '92', 92, '93', 93, '94', 94, '95', 95, '96', 96)
    }

    @Test
    void of97() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84, '85': 85, '86': 86, '87': 87, '88': 88, '89': 89, '90': 90, '91': 91, '92': 92, '93': 93, '94': 94, '95': 95, '96': 96, '97': 97] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84, '85', 85, '86', 86, '87', 87, '88', 88, '89', 89, '90', 90, '91', 91, '92', 92, '93', 93, '94', 94, '95', 95, '96', 96, '97', 97)
    }

    @Test
    void of98() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84, '85': 85, '86': 86, '87': 87, '88': 88, '89': 89, '90': 90, '91': 91, '92': 92, '93': 93, '94': 94, '95': 95, '96': 96, '97': 97, '98': 98] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84, '85', 85, '86', 86, '87', 87, '88', 88, '89', 89, '90', 90, '91', 91, '92', 92, '93', 93, '94', 94, '95', 95, '96', 96, '97', 97, '98', 98)
    }

    @Test
    void of99() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84, '85': 85, '86': 86, '87': 87, '88': 88, '89': 89, '90': 90, '91': 91, '92': 92, '93': 93, '94': 94, '95': 95, '96': 96, '97': 97, '98': 98, '99': 99] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84, '85', 85, '86', 86, '87', 87, '88', 88, '89', 89, '90', 90, '91', 91, '92', 92, '93', 93, '94', 94, '95', 95, '96', 96, '97', 97, '98', 98, '99', 99)
    }

    @Test
    void of100() {
        assert ['1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, '10': 10, '11': 11, '12': 12, '13': 13, '14': 14, '15': 15, '16': 16, '17': 17, '18': 18, '19': 19, '20': 20, '21': 21, '22': 22, '23': 23, '24': 24, '25': 25, '26': 26, '27': 27, '28': 28, '29': 29, '30': 30, '31': 31, '32': 32, '33': 33, '34': 34, '35': 35, '36': 36, '37': 37, '38': 38, '39': 39, '40': 40, '41': 41, '42': 42, '43': 43, '44': 44, '45': 45, '46': 46, '47': 47, '48': 48, '49': 49, '50': 50, '51': 51, '52': 52, '53': 53, '54': 54, '55': 55, '56': 56, '57': 57, '58': 58, '59': 59, '60': 60, '61': 61, '62': 62, '63': 63, '64': 64, '65': 65, '66': 66, '67': 67, '68': 68, '69': 69, '70': 70, '71': 71, '72': 72, '73': 73, '74': 74, '75': 75, '76': 76, '77': 77, '78': 78, '79': 79, '80': 80, '81': 81, '82': 82, '83': 83, '84': 84, '85': 85, '86': 86, '87': 87, '88': 88, '89': 89, '90': 90, '91': 91, '92': 92, '93': 93, '94': 94, '95': 95, '96': 96, '97': 97, '98': 98, '99': 99, '100': 100] == Maps.of('1', 1, '2', 2, '3', 3, '4', 4, '5', 5, '6', 6, '7', 7, '8', 8, '9', 9, '10', 10, '11', 11, '12', 12, '13', 13, '14', 14, '15', 15, '16', 16, '17', 17, '18', 18, '19', 19, '20', 20, '21', 21, '22', 22, '23', 23, '24', 24, '25', 25, '26', 26, '27', 27, '28', 28, '29', 29, '30', 30, '31', 31, '32', 32, '33', 33, '34', 34, '35', 35, '36', 36, '37', 37, '38', 38, '39', 39, '40', 40, '41', 41, '42', 42, '43', 43, '44', 44, '45', 45, '46', 46, '47', 47, '48', 48, '49', 49, '50', 50, '51', 51, '52', 52, '53', 53, '54', 54, '55', 55, '56', 56, '57', 57, '58', 58, '59', 59, '60', 60, '61', 61, '62', 62, '63', 63, '64', 64, '65', 65, '66', 66, '67', 67, '68', 68, '69', 69, '70', 70, '71', 71, '72', 72, '73', 73, '74', 74, '75', 75, '76', 76, '77', 77, '78', 78, '79', 79, '80', 80, '81', 81, '82', 82, '83', 83, '84', 84, '85', 85, '86', 86, '87', 87, '88', 88, '89', 89, '90', 90, '91', 91, '92', 92, '93', 93, '94', 94, '95', 95, '96', 96, '97', 97, '98', 98, '99', 99, '100', 100)
    }
}
