/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testng.DataProviderHolder;
import org.testng.IDataProviderInterceptor;
import org.testng.IDataProviderListener;
import org.testng.IInstanceInfo;
import org.testng.ITestContext;
import org.testng.ITestNGListener;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IListenersAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.IObject;
import org.testng.internal.IParameterInfo;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.ParameterInfo;
import org.testng.internal.Parameters;
import org.testng.internal.RunInfo;
import org.testng.internal.TestNGMethodFinder;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class FactoryMethod
extends BaseTestMethod {
    private final IFactoryAnnotation factoryAnnotation;
    private final Object m_instance;
    private final ITestContext m_testContext;
    private String m_factoryCreationFailedMessage = null;
    private final DataProviderHolder holder;

    public String getFactoryCreationFailedMessage() {
        return this.m_factoryCreationFailedMessage;
    }

    private void init(Object instance, IAnnotationFinder annotationFinder, ConstructorOrMethod com) {
        Class<? extends ITestNGListener>[] listeners;
        IListenersAnnotation annotation = annotationFinder.findAnnotation(com.getDeclaringClass(), IListenersAnnotation.class);
        if (annotation == null) {
            return;
        }
        for (Class<? extends ITestNGListener> listener : listeners = annotation.getValue()) {
            Object obj = instance;
            if (obj == null) {
                try {
                    obj = this.m_objectFactory.newInstance(listener, new Object[0]);
                }
                catch (TestNGException testNGException) {
                    // empty catch block
                }
            }
            if (obj == null) continue;
            if (IDataProviderListener.class.isAssignableFrom(obj.getClass())) {
                this.holder.addListener((IDataProviderListener)obj);
            }
            if (!IDataProviderInterceptor.class.isAssignableFrom(obj.getClass())) continue;
            this.holder.addInterceptor((IDataProviderInterceptor)obj);
        }
    }

    FactoryMethod(ConstructorOrMethod com, IObject.IdentifiableObject identifiable, IAnnotationFinder annotationFinder, ITestContext testContext, ITestObjectFactory objectFactory, DataProviderHolder holder) {
        super(objectFactory, com.getName(), com, annotationFinder, identifiable);
        this.holder = holder;
        Object instance = IObject.IdentifiableObject.unwrap(identifiable);
        this.init(instance, annotationFinder, com);
        Utils.checkInstanceOrStatic(instance, com.getMethod());
        Utils.checkReturnType(com.getMethod(), Object[].class, IInstanceInfo[].class);
        Class<?> declaringClass = com.getDeclaringClass();
        if (instance != null && !declaringClass.isAssignableFrom(instance.getClass())) {
            if (instance instanceof IParameterInfo) {
                instance = ((IParameterInfo)instance).getInstance();
            }
            Class<?> cls = instance.getClass();
            String msg = "Found a default constructor and also a Factory method when working with " + declaringClass.getName() + ". Root cause: Mismatch between instance/method classes:[" + cls.getName() + "] [" + declaringClass.getName() + "]";
            throw new TestNGException(msg);
        }
        if (instance == null && com.getMethod() != null && !Modifier.isStatic(com.getMethod().getModifiers())) {
            throw new TestNGException("An inner factory method MUST be static. But '" + com.getMethod().getName() + "' from '" + declaringClass.getName() + "' is not.");
        }
        if (com.getMethod() != null && !Modifier.isPublic(com.getMethod().getModifiers())) {
            try {
                com.getMethod().setAccessible(true);
            }
            catch (SecurityException e) {
                throw new TestNGException(com.getMethod().getName() + " must be public", e);
            }
        }
        this.factoryAnnotation = annotationFinder.findAnnotation(com, IFactoryAnnotation.class);
        this.m_instance = this.getInstance();
        this.m_testContext = testContext;
        NoOpTestClass tc = new NoOpTestClass();
        tc.setTestClass(declaringClass);
        this.m_testClass = tc;
        this.m_groups = FactoryMethod.getAllGroups(objectFactory, declaringClass, testContext.getCurrentXmlTest(), annotationFinder);
    }

    private static String[] getAllGroups(ITestObjectFactory objectFactory, Class<?> declaringClass, XmlTest xmlTest, IAnnotationFinder annotationFinder) {
        TestNGMethodFinder testMethodFinder = new TestNGMethodFinder(objectFactory, new RunInfo(() -> xmlTest), annotationFinder);
        ITestNGMethod[] testMethods = testMethodFinder.getTestMethods(declaringClass, xmlTest);
        HashSet<String> groups = new HashSet<String>();
        for (ITestNGMethod method : testMethods) {
            groups.addAll(Arrays.asList(method.getGroups()));
        }
        return groups.toArray(new String[0]);
    }

    public IParameterInfo[] invoke() {
        List result = Lists.newArrayList();
        Map<String, String> allParameterNames = Maps.newHashMap();
        Parameters.MethodParameters methodParameters = new Parameters.MethodParameters(this.m_testContext.getCurrentXmlTest().getAllParameters(), this.findMethodParameters(this.m_testContext.getCurrentXmlTest()), null, null, this.m_testContext, null);
        Iterator<Object[]> parameterIterator = Parameters.handleParameters((ITestObjectFactory)this.m_objectFactory, (ITestNGMethod)this, allParameterNames, (Object)this.m_instance, (Parameters.MethodParameters)methodParameters, (XmlSuite)this.m_testContext.getCurrentXmlTest().getSuite(), (IAnnotationFinder)this.m_annotationFinder, null, (DataProviderHolder)this.holder, (String)"@Factory").parameters;
        try {
            List<Integer> indices = this.factoryAnnotation.getIndices();
            int position = 0;
            while (parameterIterator.hasNext()) {
                Object[] parameters = parameterIterator.next();
                if (parameters == null) continue;
                ConstructorOrMethod com = this.getConstructorOrMethod();
                if (com.getMethod() != null) {
                    Object[] testInstances = (Object[])com.getMethod().invoke(this.m_instance, parameters);
                    if (testInstances == null) {
                        testInstances = new Object[]{};
                    }
                    if (testInstances.length == 0) {
                        this.m_factoryCreationFailedMessage = String.format("The Factory method %s.%s() should have produced at-least one instance.", com.getDeclaringClass().getName(), com.getName());
                    }
                    if (indices == null || indices.isEmpty()) {
                        int instancePosition = position;
                        result.addAll(Arrays.stream(testInstances).map(instance -> new ParameterInfo(instance, instancePosition, parameters)).collect(Collectors.toList()));
                    } else {
                        for (Integer index : indices) {
                            int i = index - position;
                            if (i < 0 || i >= testInstances.length) continue;
                            result.add(new ParameterInfo(testInstances[i], position, parameters));
                        }
                    }
                    position += testInstances.length;
                    continue;
                }
                if (indices == null || indices.isEmpty() || indices.contains(position)) {
                    Object instance2 = this.m_objectFactory.newInstance(com.getConstructor(), parameters);
                    result.add(new ParameterInfo(instance2, position, parameters));
                }
                ++position;
            }
        }
        catch (Throwable t) {
            ConstructorOrMethod com = this.getConstructorOrMethod();
            throw new TestNGException("The factory method " + String.valueOf(com.getDeclaringClass()) + "." + com.getName() + "() threw an exception", t);
        }
        return result.toArray(new IParameterInfo[0]);
    }

    @Override
    public ITestNGMethod clone() {
        throw new IllegalStateException("clone is not supported for FactoryMethod");
    }
}

