/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import org.testng.IClass;
import org.testng.ITest;
import org.testng.ITestClass;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.IObject;
import org.testng.internal.IParameterInfo;
import org.testng.internal.ITestClassConfigInfo;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.TestNGMethod;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.log4testng.Logger;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

class TestClass
extends NoOpTestClass
implements ITestClass,
ITestClassConfigInfo,
IObject {
    private IAnnotationFinder annotationFinder = null;
    private ITestMethodFinder testMethodFinder = null;
    private IClass iClass = null;
    private String testName;
    private XmlTest xmlTest;
    private XmlClass xmlClass;
    private final ITestObjectFactory objectFactory;
    private final String m_errorMsgPrefix;
    private final IdentityHashMap<Object, List<ITestNGMethod>> beforeClassConfig = new IdentityHashMap();
    private final IdentityHashMap<Object, List<ITestNGMethod>> afterClassConfig = new IdentityHashMap();
    private static final Logger LOG = Logger.getLogger(TestClass.class);

    @Override
    public List<ITestNGMethod> getAllBeforeClassMethods() {
        return TestClass.getAllClassLevelConfigs(this.beforeClassConfig);
    }

    @Override
    public List<ITestNGMethod> getAllAfterClassMethods() {
        return TestClass.getAllClassLevelConfigs(this.afterClassConfig);
    }

    private static List<ITestNGMethod> getAllClassLevelConfigs(IdentityHashMap<Object, List<ITestNGMethod>> map) {
        return map.values().parallelStream().reduce((a, b) -> {
            ArrayList methodList = new ArrayList(a);
            methodList.addAll(b);
            return methodList;
        }).orElse(Lists.newArrayList());
    }

    @Override
    public List<ITestNGMethod> getInstanceBeforeClassMethods(Object instance) {
        return this.beforeClassConfig.get(instance);
    }

    @Override
    public List<ITestNGMethod> getInstanceAfterClassMethods(Object instance) {
        return this.afterClassConfig.get(instance);
    }

    protected TestClass(ITestObjectFactory objectFactory, IClass cls, ITestMethodFinder testMethodFinder, IAnnotationFinder annotationFinder, XmlTest xmlTest, XmlClass xmlClass, String errorMsgPrefix) {
        this.objectFactory = objectFactory;
        this.m_errorMsgPrefix = errorMsgPrefix;
        this.init(cls, testMethodFinder, annotationFinder, xmlTest, xmlClass);
    }

    @Override
    public String getTestName() {
        return this.testName;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.xmlTest;
    }

    @Override
    public XmlClass getXmlClass() {
        return this.xmlClass;
    }

    public IAnnotationFinder getAnnotationFinder() {
        return this.annotationFinder;
    }

    private void init(IClass cls, ITestMethodFinder testMethodFinder, IAnnotationFinder annotationFinder, XmlTest xmlTest, XmlClass xmlClass) {
        this.log(3, "Creating TestClass for " + String.valueOf(cls));
        this.iClass = cls;
        this.m_testClass = cls.getRealClass();
        this.xmlTest = xmlTest;
        this.xmlClass = xmlClass;
        this.testMethodFinder = testMethodFinder;
        this.annotationFinder = annotationFinder;
        this.initTestClassesAndInstances();
        this.initMethods();
    }

    private void initTestClassesAndInstances() {
        IObject.IdentifiableObject[] instances = this.getObjects(true, this.m_errorMsgPrefix);
        Arrays.stream(instances).map(IObject.IdentifiableObject::getInstance).map(IParameterInfo::embeddedInstance).filter(it -> it instanceof ITest).findFirst().ifPresent(it -> {
            this.testName = ((ITest)it).getTestName();
        });
        if (this.testName == null) {
            this.testName = this.iClass.getTestName();
        }
    }

    @Override
    public Object[] getInstances(boolean create) {
        return this.iClass.getInstances(create);
    }

    @Override
    public Object[] getInstances(boolean create, String errorMsgPrefix) {
        return this.iClass.getInstances(create, this.m_errorMsgPrefix);
    }

    @Override
    public IObject.IdentifiableObject[] getObjects(boolean create, String errorMsgPrefix) {
        return IObject.objects(this.iClass, create, errorMsgPrefix);
    }

    @Override
    public long[] getInstanceHashCodes() {
        return IObject.instanceHashCodes(this.iClass);
    }

    @Override
    public void addInstance(Object instance) {
        this.iClass.addInstance(instance);
    }

    @Override
    public void addObject(IObject.IdentifiableObject instance) {
        IObject.cast(this.iClass).ifPresent(it -> it.addObject(instance));
    }

    private void initMethods() {
        ITestNGMethod[] methods = this.testMethodFinder.getTestMethods(this.m_testClass, this.xmlTest);
        this.m_testMethods = this.createTestMethods(methods);
        for (IObject.IdentifiableObject eachInstance : IObject.objects(this.iClass, false)) {
            this.m_beforeSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods(this.objectFactory, this.testMethodFinder.getBeforeSuiteMethods(this.m_testClass), this.annotationFinder, true, eachInstance);
            this.m_afterSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods(this.objectFactory, this.testMethodFinder.getAfterSuiteMethods(this.m_testClass), this.annotationFinder, false, eachInstance);
            this.m_beforeTestConfMethods = ConfigurationMethod.createTestConfigurationMethods(this.objectFactory, this.testMethodFinder.getBeforeTestConfigurationMethods(this.m_testClass), this.annotationFinder, true, this.xmlTest, eachInstance);
            this.m_afterTestConfMethods = ConfigurationMethod.createTestConfigurationMethods(this.objectFactory, this.testMethodFinder.getAfterTestConfigurationMethods(this.m_testClass), this.annotationFinder, false, this.xmlTest, eachInstance);
            this.m_beforeClassMethods = ConfigurationMethod.createClassConfigurationMethods(this.objectFactory, this.testMethodFinder.getBeforeClassMethods(this.m_testClass), this.annotationFinder, true, this.xmlTest, eachInstance);
            Object instance = IParameterInfo.embeddedInstance(eachInstance.getInstance());
            this.beforeClassConfig.put(instance, this.m_beforeClassMethods);
            this.m_afterClassMethods = ConfigurationMethod.createClassConfigurationMethods(this.objectFactory, this.testMethodFinder.getAfterClassMethods(this.m_testClass), this.annotationFinder, false, this.xmlTest, eachInstance);
            this.afterClassConfig.put(instance, this.m_afterClassMethods);
            this.m_beforeGroupsMethods = ConfigurationMethod.createBeforeConfigurationMethods(this.objectFactory, this.testMethodFinder.getBeforeGroupsConfigurationMethods(this.m_testClass), this.annotationFinder, true, eachInstance);
            this.m_afterGroupsMethods = ConfigurationMethod.createAfterConfigurationMethods(this.objectFactory, this.testMethodFinder.getAfterGroupsConfigurationMethods(this.m_testClass), this.annotationFinder, false, eachInstance);
            this.m_beforeTestMethods.addAll(ConfigurationMethod.createTestMethodConfigurationMethods(this.objectFactory, this.testMethodFinder.getBeforeTestMethods(this.m_testClass), this.annotationFinder, true, this.xmlTest, eachInstance));
            this.m_afterTestMethods.addAll(ConfigurationMethod.createTestMethodConfigurationMethods(this.objectFactory, this.testMethodFinder.getAfterTestMethods(this.m_testClass), this.annotationFinder, false, this.xmlTest, eachInstance));
        }
    }

    private ITestNGMethod[] createTestMethods(ITestNGMethod[] methods) {
        List vResult = Lists.newArrayList();
        for (ITestNGMethod tm : methods) {
            ConstructorOrMethod m = tm.getConstructorOrMethod();
            if (m.getDeclaringClass().isAssignableFrom(this.m_testClass)) {
                for (IObject.IdentifiableObject o : IObject.objects(this.iClass, false)) {
                    this.log(4, "Adding method " + String.valueOf(tm) + " on TestClass " + String.valueOf(this.m_testClass));
                    vResult.add(new TestNGMethod(this.objectFactory, m.getMethod(), this.annotationFinder, this.xmlTest, o));
                }
                continue;
            }
            this.log(4, "Rejecting method " + String.valueOf(tm) + " for TestClass " + String.valueOf(this.m_testClass));
        }
        return vResult.toArray(new ITestNGMethod[0]);
    }

    public ITestMethodFinder getTestMethodFinder() {
        return this.testMethodFinder;
    }

    private void log(int level, String s) {
        Utils.log("TestClass", level, s);
    }

    protected void dump() {
        LOG.info("===== Test class\n" + this.m_testClass.getName());
        for (ITestNGMethod m : this.m_beforeClassMethods) {
            LOG.info("  @BeforeClass " + String.valueOf(m));
        }
        for (ITestNGMethod m : this.m_beforeTestMethods) {
            LOG.info("  @BeforeMethod " + String.valueOf(m));
        }
        for (ITestNGMethod m : this.m_testMethods) {
            LOG.info("    @Test " + String.valueOf(m));
        }
        for (ITestNGMethod m : this.m_afterTestMethods) {
            LOG.info("  @AfterMethod " + String.valueOf(m));
        }
        for (ITestNGMethod m : this.m_afterClassMethods) {
            LOG.info("  @AfterClass " + String.valueOf(m));
        }
        LOG.info("======");
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("name", this.m_testClass).toString();
    }

    public IClass getIClass() {
        return this.iClass;
    }
}

