/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovy.lang.Closure;
import groovyx.gpars.dataflow.SelectResult;
import groovyx.gpars.dataflow.operator.DataflowProcessorActor;
import groovyx.gpars.dataflow.operator.DataflowSelector;
import groovyx.gpars.dataflow.operator.PoisonPill;
import groovyx.gpars.dataflow.operator.StopGently;
import groovyx.gpars.group.PGroup;
import java.util.Arrays;
import java.util.List;

class DataflowSelectorActor
extends DataflowProcessorActor {
    protected final boolean passIndex;

    DataflowSelectorActor(DataflowSelector owningOperator, PGroup group, List outputs, List inputs, Closure code) {
        super(owningOperator, group, outputs, inputs, code);
        this.passIndex = code.getMaximumNumberOfParameters() == 2;
    }

    @Override
    final void afterStart() {
        super.afterStart();
        ((DataflowSelector)this.owningProcessor).doSelect();
    }

    @Override
    public final void onMessage(Object message) {
        if (message instanceof StopGently) {
            this.stoppingGently = true;
            return;
        }
        SelectResult msg = (SelectResult)message;
        int index = msg.getIndex();
        Object value = msg.getValue();
        if (DataflowSelectorActor.isControlMessage(value)) {
            if ((value = this.fireMessageArrived(value, index, true)) instanceof PoisonPill) {
                this.handlePoisonPillInSelector(index, value);
            }
            if (DataflowSelectorActor.isControlMessage(value)) {
                return;
            }
        }
        Object verifiedValue = this.fireMessageArrived(value, index, false);
        List<Object> verifiedValues = this.owningProcessor.fireBeforeRun(Arrays.asList(verifiedValue));
        this.startTask(index, verifiedValues.get(0));
        if (this.stoppingGently) {
            this.stop();
        }
        if (!this.hasBeenStopped()) {
            ((DataflowSelector)this.owningProcessor).doSelect();
        }
    }

    private void handlePoisonPillInSelector(int index, Object value) {
        if (((PoisonPill)value).isImmediate()) {
            this.checkPoison(value);
        } else {
            DataflowSelector selector = (DataflowSelector)this.owningProcessor;
            selector.setGuard(index, false);
            if (selector.allGuardsClosed()) {
                this.checkPoison(value);
            } else if (!this.hasBeenStopped()) {
                ((DataflowSelector)this.owningProcessor).doSelect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTask(int index, Object result) {
        block5: {
            try {
                if (this.passIndex) {
                    this.code.call(new Object[]{result, index});
                    break block5;
                }
                this.code.call(result);
            }
            catch (Throwable e) {
                try {
                    this.reportException(e);
                }
                catch (Throwable throwable) {
                    this.owningProcessor.fireAfterRun(Arrays.asList(result));
                    throw throwable;
                }
                this.owningProcessor.fireAfterRun(Arrays.asList(result));
            }
        }
        this.owningProcessor.fireAfterRun(Arrays.asList(result));
    }
}

