/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.stmt;

import java.util.Objects;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.LoopingStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class ForStatement
extends Statement
implements LoopingStatement {
    public static final Parameter FOR_LOOP_DUMMY = new Parameter(ClassHelper.OBJECT_TYPE, "forLoopDummyParameter");
    private final Parameter indexVariable;
    private final Parameter valueVariable;
    private Expression collectionExpression;
    private Statement loopBlock;
    private VariableScope scope;

    public ForStatement(Parameter indexVariable, Parameter valueVariable, Expression collectionExpression, Statement loopBlock) {
        this.indexVariable = indexVariable;
        this.valueVariable = Objects.requireNonNull(valueVariable);
        this.setCollectionExpression(collectionExpression);
        this.setLoopBlock(loopBlock);
    }

    public ForStatement(Parameter variable, Expression collectionExpression, Statement loopBlock) {
        this(null, variable, collectionExpression, loopBlock);
    }

    public void setCollectionExpression(Expression collectionExpression) {
        this.collectionExpression = Objects.requireNonNull(collectionExpression);
    }

    @Override
    public void setLoopBlock(Statement loopBlock) {
        this.loopBlock = Objects.requireNonNull(loopBlock);
    }

    public Parameter getIndexVariable() {
        return this.indexVariable;
    }

    public Parameter getValueVariable() {
        return this.valueVariable != FOR_LOOP_DUMMY ? this.valueVariable : null;
    }

    @Deprecated(since="5.0.0")
    public Parameter getVariable() {
        return this.valueVariable;
    }

    @Deprecated(since="5.0.0")
    public ClassNode getVariableType() {
        return this.valueVariable.getType();
    }

    public Expression getCollectionExpression() {
        return this.collectionExpression;
    }

    @Override
    public Statement getLoopBlock() {
        return this.loopBlock;
    }

    public VariableScope getVariableScope() {
        return this.scope;
    }

    public void setVariableScope(VariableScope scope) {
        this.scope = scope;
    }

    @Override
    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitForLoop(this);
    }
}

