/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.writer.impl;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaConstructor;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaInitializer;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaModule;
import com.thoughtworks.qdox.model.JavaModuleDescriptor;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import com.thoughtworks.qdox.model.expression.Expression;
import com.thoughtworks.qdox.writer.ModelWriter;
import com.thoughtworks.qdox.writer.impl.IndentBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class DefaultModelWriter
implements ModelWriter {
    private IndentBuffer buffer = new IndentBuffer();

    protected final IndentBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public ModelWriter writeSource(JavaSource source) {
        this.writePackage(source.getPackage());
        for (String imprt : source.getImports()) {
            this.buffer.write("import ");
            this.buffer.write(imprt);
            this.buffer.write(';');
            this.buffer.newline();
        }
        if (source.getImports().size() > 0) {
            this.buffer.newline();
        }
        ListIterator<JavaClass> iter = source.getClasses().listIterator();
        while (iter.hasNext()) {
            JavaClass cls = iter.next();
            this.writeClass(cls);
            if (!iter.hasNext()) continue;
            this.buffer.newline();
        }
        return this;
    }

    @Override
    public ModelWriter writePackage(JavaPackage pckg) {
        if (pckg != null) {
            this.commentHeader(pckg);
            this.buffer.write("package ");
            this.buffer.write(pckg.getName());
            this.buffer.write(';');
            this.buffer.newline();
            this.buffer.newline();
        }
        return this;
    }

    @Override
    public ModelWriter writeClass(JavaClass cls) {
        String className;
        this.commentHeader(cls);
        this.writeAccessibilityModifier(cls.getModifiers());
        this.writeNonAccessibilityModifiers(cls.getModifiers());
        this.buffer.write(cls.isEnum() ? "enum " : (cls.isInterface() ? "interface " : (cls.isAnnotation() ? "@interface " : "class ")));
        this.buffer.write(cls.getName());
        if (cls.getSuperClass() != null && !"java.lang.Object".equals(className = cls.getSuperClass().getFullyQualifiedName()) && !"java.lang.Enum".equals(className)) {
            this.buffer.write(" extends ");
            this.buffer.write(cls.getSuperClass().getGenericCanonicalName());
        }
        if (cls.getImplements().size() > 0) {
            this.buffer.write(cls.isInterface() ? " extends " : " implements ");
            ListIterator<JavaType> iter = cls.getImplements().listIterator();
            while (iter.hasNext()) {
                this.buffer.write(iter.next().getGenericCanonicalName());
                if (!iter.hasNext()) continue;
                this.buffer.write(", ");
            }
        }
        return this.writeClassBody(cls);
    }

    private ModelWriter writeClassBody(JavaClass cls) {
        this.buffer.write(" {");
        this.buffer.newline();
        this.buffer.indent();
        for (JavaField javaField : cls.getFields()) {
            this.buffer.newline();
            this.writeField(javaField);
        }
        for (JavaConstructor javaConstructor : cls.getConstructors()) {
            this.buffer.newline();
            this.writeConstructor(javaConstructor);
        }
        for (JavaMethod javaMethod : cls.getMethods()) {
            this.buffer.newline();
            this.writeMethod(javaMethod);
        }
        for (JavaClass innerCls : cls.getNestedClasses()) {
            this.buffer.newline();
            this.writeClass(innerCls);
        }
        this.buffer.deindent();
        this.buffer.newline();
        this.buffer.write('}');
        this.buffer.newline();
        return this;
    }

    @Override
    public ModelWriter writeInitializer(JavaInitializer init) {
        if (init.isStatic()) {
            this.buffer.write("static ");
        }
        this.buffer.write('{');
        this.buffer.newline();
        this.buffer.indent();
        this.buffer.write(init.getBlockContent());
        this.buffer.deindent();
        this.buffer.newline();
        this.buffer.write('}');
        this.buffer.newline();
        return this;
    }

    @Override
    public ModelWriter writeField(JavaField field) {
        this.commentHeader(field);
        this.writeAllModifiers(field.getModifiers());
        if (!field.isEnumConstant()) {
            this.buffer.write(field.getType().getGenericCanonicalName());
            this.buffer.write(' ');
        }
        this.buffer.write(field.getName());
        if (field.isEnumConstant()) {
            if (field.getEnumConstantArguments() != null && !field.getEnumConstantArguments().isEmpty()) {
                this.buffer.write("( ");
                ListIterator<Expression> iter = field.getEnumConstantArguments().listIterator();
                while (iter.hasNext()) {
                    this.buffer.write(((Expression)iter.next()).getParameterValue().toString());
                    if (!iter.hasNext()) continue;
                    this.buffer.write(", ");
                }
                this.buffer.write(" )");
            }
            if (field.getEnumConstantClass() != null) {
                this.writeClassBody(field.getEnumConstantClass());
            }
        } else if (field.getInitializationExpression() != null && field.getInitializationExpression().length() > 0) {
            this.buffer.write(" = ");
            this.buffer.write(field.getInitializationExpression());
        }
        this.buffer.write(';');
        this.buffer.newline();
        return this;
    }

    @Override
    public ModelWriter writeConstructor(JavaConstructor constructor) {
        this.commentHeader(constructor);
        this.writeAllModifiers(constructor.getModifiers());
        this.buffer.write(constructor.getName());
        this.buffer.write('(');
        ListIterator<JavaParameter> iter = constructor.getParameters().listIterator();
        while (iter.hasNext()) {
            this.writeParameter(iter.next());
            if (!iter.hasNext()) continue;
            this.buffer.write(", ");
        }
        this.buffer.write(')');
        if (constructor.getExceptions().size() > 0) {
            this.buffer.write(" throws ");
            Iterator<JavaClass> excIter = constructor.getExceptions().iterator();
            while (excIter.hasNext()) {
                this.buffer.write(excIter.next().getGenericCanonicalName());
                if (!excIter.hasNext()) continue;
                this.buffer.write(", ");
            }
        }
        this.buffer.write(" {");
        this.buffer.newline();
        if (constructor.getSourceCode() != null) {
            this.buffer.write(constructor.getSourceCode());
        }
        this.buffer.write('}');
        this.buffer.newline();
        return this;
    }

    @Override
    public ModelWriter writeMethod(JavaMethod method) {
        this.commentHeader(method);
        this.writeAccessibilityModifier(method.getModifiers());
        this.writeNonAccessibilityModifiers(method.getModifiers());
        this.buffer.write(method.getReturnType().getGenericCanonicalName());
        this.buffer.write(' ');
        this.buffer.write(method.getName());
        this.buffer.write('(');
        ListIterator<JavaParameter> iter = method.getParameters().listIterator();
        while (iter.hasNext()) {
            this.writeParameter(iter.next());
            if (!iter.hasNext()) continue;
            this.buffer.write(", ");
        }
        this.buffer.write(')');
        if (method.getExceptions().size() > 0) {
            this.buffer.write(" throws ");
            Iterator<JavaClass> excIter = method.getExceptions().iterator();
            while (excIter.hasNext()) {
                this.buffer.write(excIter.next().getGenericCanonicalName());
                if (!excIter.hasNext()) continue;
                this.buffer.write(", ");
            }
        }
        if (method.getSourceCode() != null && method.getSourceCode().length() > 0) {
            this.buffer.write(" {");
            this.buffer.newline();
            this.buffer.write(method.getSourceCode());
            this.buffer.write('}');
            this.buffer.newline();
        } else {
            this.buffer.write(';');
            this.buffer.newline();
        }
        return this;
    }

    private void writeNonAccessibilityModifiers(Collection<String> modifiers) {
        for (String modifier : modifiers) {
            if (modifier.startsWith("p") || "interface".equals(modifier)) continue;
            this.buffer.write(modifier);
            this.buffer.write(' ');
        }
    }

    private void writeAccessibilityModifier(Collection<String> modifiers) {
        for (String modifier : modifiers) {
            if (!modifier.startsWith("p")) continue;
            this.buffer.write(modifier);
            this.buffer.write(' ');
        }
    }

    private void writeAllModifiers(List<String> modifiers) {
        for (String modifier : modifiers) {
            this.buffer.write(modifier);
            this.buffer.write(' ');
        }
    }

    @Override
    public ModelWriter writeAnnotation(JavaAnnotation annotation) {
        this.buffer.write('@');
        this.buffer.write(annotation.getType().getGenericCanonicalName());
        if (!annotation.getPropertyMap().isEmpty()) {
            this.buffer.indent();
            this.buffer.write('(');
            Iterator<Map.Entry<String, AnnotationValue>> iterator = annotation.getPropertyMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, AnnotationValue> entry = iterator.next();
                this.buffer.write(entry.getKey());
                this.buffer.write('=');
                this.buffer.write(entry.getValue().toString());
                if (!iterator.hasNext()) continue;
                this.buffer.write(',');
                this.buffer.newline();
            }
            this.buffer.write(')');
            this.buffer.deindent();
        }
        this.buffer.newline();
        return this;
    }

    @Override
    public ModelWriter writeParameter(JavaParameter parameter) {
        this.commentHeader(parameter);
        this.buffer.write(parameter.getGenericCanonicalName());
        if (parameter.isVarArgs()) {
            this.buffer.write("...");
        }
        this.buffer.write(' ');
        this.buffer.write(parameter.getName());
        return this;
    }

    protected void commentHeader(JavaAnnotatedElement entity) {
        if (entity.getComment() != null || entity.getTags().size() > 0) {
            this.buffer.write("/**");
            this.buffer.newline();
            if (entity.getComment() != null && entity.getComment().length() > 0) {
                this.buffer.write(" * ");
                this.buffer.write(entity.getComment().replaceAll("\n", "\n * "));
                this.buffer.newline();
            }
            if (entity.getTags().size() > 0) {
                if (entity.getComment() != null && entity.getComment().length() > 0) {
                    this.buffer.write(" *");
                    this.buffer.newline();
                }
                for (DocletTag docletTag : entity.getTags()) {
                    this.buffer.write(" * @");
                    this.buffer.write(docletTag.getName());
                    if (docletTag.getValue().length() > 0) {
                        this.buffer.write(' ');
                        this.buffer.write(docletTag.getValue());
                    }
                    this.buffer.newline();
                }
            }
            this.buffer.write(" */");
            this.buffer.newline();
        }
        if (entity.getAnnotations() != null) {
            for (JavaAnnotation annotation : entity.getAnnotations()) {
                this.writeAnnotation(annotation);
            }
        }
    }

    @Override
    public ModelWriter writeModuleDescriptor(JavaModuleDescriptor descriptor) {
        if (descriptor.isOpen()) {
            this.buffer.write("open ");
        }
        this.buffer.write("module " + descriptor.getName() + " {");
        this.buffer.newline();
        this.buffer.indent();
        for (JavaModuleDescriptor.JavaRequires requires : descriptor.getRequires()) {
            this.buffer.newline();
            this.writeModuleRequires(requires);
        }
        for (JavaModuleDescriptor.JavaExports exports : descriptor.getExports()) {
            this.buffer.newline();
            this.writeModuleExports(exports);
        }
        for (JavaModuleDescriptor.JavaOpens opens : descriptor.getOpens()) {
            this.buffer.newline();
            this.writeModuleOpens(opens);
        }
        for (JavaModuleDescriptor.JavaProvides provides : descriptor.getProvides()) {
            this.buffer.newline();
            this.writeModuleProvides(provides);
        }
        for (JavaModuleDescriptor.JavaUses uses : descriptor.getUses()) {
            this.buffer.newline();
            this.writeModuleUses(uses);
        }
        this.buffer.newline();
        this.buffer.deindent();
        this.buffer.write('}');
        this.buffer.newline();
        return this;
    }

    @Override
    public ModelWriter writeModuleExports(JavaModuleDescriptor.JavaExports exports) {
        this.buffer.write("exports ");
        this.buffer.write(exports.getSource().getName());
        if (!exports.getTargets().isEmpty()) {
            this.buffer.write(" to ");
            Iterator<JavaModule> targets = exports.getTargets().iterator();
            while (targets.hasNext()) {
                JavaModule target = targets.next();
                this.buffer.write(target.getName());
                if (!targets.hasNext()) continue;
                this.buffer.write(", ");
            }
        }
        this.buffer.write(';');
        this.buffer.newline();
        return this;
    }

    @Override
    public ModelWriter writeModuleOpens(JavaModuleDescriptor.JavaOpens opens) {
        this.buffer.write("opens ");
        this.buffer.write(opens.getSource().getName());
        if (!opens.getTargets().isEmpty()) {
            this.buffer.write(" to ");
            Iterator<JavaModule> targets = opens.getTargets().iterator();
            while (targets.hasNext()) {
                JavaModule target = targets.next();
                this.buffer.write(target.getName());
                if (!targets.hasNext()) continue;
                this.buffer.write(", ");
            }
        }
        this.buffer.write(';');
        this.buffer.newline();
        return this;
    }

    @Override
    public ModelWriter writeModuleProvides(JavaModuleDescriptor.JavaProvides provides) {
        this.buffer.write("provides ");
        this.buffer.write(provides.getService().getName());
        this.buffer.write(" with ");
        Iterator<JavaClass> providers = provides.getProviders().iterator();
        while (providers.hasNext()) {
            JavaClass provider = providers.next();
            this.buffer.write(provider.getName());
            if (!providers.hasNext()) continue;
            this.buffer.write(", ");
        }
        this.buffer.write(';');
        this.buffer.newline();
        return null;
    }

    @Override
    public ModelWriter writeModuleRequires(JavaModuleDescriptor.JavaRequires requires) {
        this.buffer.write("requires ");
        this.writeAccessibilityModifier(requires.getModifiers());
        this.writeNonAccessibilityModifiers(requires.getModifiers());
        this.buffer.write(requires.getModule().getName());
        this.buffer.write(';');
        this.buffer.newline();
        return this;
    }

    @Override
    public ModelWriter writeModuleUses(JavaModuleDescriptor.JavaUses uses) {
        this.buffer.write("uses ");
        this.buffer.write(uses.getService().getName());
        this.buffer.write(';');
        this.buffer.newline();
        return this;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

