/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma.transactions;

public final class SpeculativeGammaConfiguration {
    public final boolean listenersDetected;
    public final boolean commuteDetected;
    public final boolean orelseDetected;
    public final boolean nonRefTypeDetected;
    public final boolean fat;
    public final boolean locksDetected;
    public final boolean constructedObjectsDetected;
    public final boolean richMansConflictScanRequired;
    public final boolean abortOnlyDetected;
    public final boolean ensureDetected;
    public final int minimalLength;

    public SpeculativeGammaConfiguration() {
        this(false, false, false, false, false, false, false, false, false, false, 1);
    }

    public SpeculativeGammaConfiguration(boolean isFat, boolean listenersDetected, boolean isCommuteDetected, boolean isNonRefTypeDetected, boolean isOrelseDetected, boolean locksDetected, boolean constructedObjectsDetected, boolean isRichMansConflictScanRequired, boolean isAbortOnlyDetected, boolean ensureDetected, int minimalLength) {
        if (minimalLength < 0) {
            throw new IllegalArgumentException();
        }
        this.fat = isFat;
        this.constructedObjectsDetected = constructedObjectsDetected;
        this.listenersDetected = listenersDetected;
        this.locksDetected = locksDetected;
        this.commuteDetected = isCommuteDetected;
        this.richMansConflictScanRequired = isRichMansConflictScanRequired;
        this.nonRefTypeDetected = isNonRefTypeDetected;
        this.orelseDetected = isOrelseDetected;
        this.minimalLength = minimalLength;
        this.abortOnlyDetected = isAbortOnlyDetected;
        this.ensureDetected = ensureDetected;
    }

    public SpeculativeGammaConfiguration newWithMinimalLength(int newMinimalLength) {
        if (newMinimalLength < 0) {
            throw new IllegalArgumentException();
        }
        if (this.minimalLength >= newMinimalLength) {
            return this;
        }
        return new SpeculativeGammaConfiguration(this.fat, this.listenersDetected, this.commuteDetected, this.nonRefTypeDetected, this.orelseDetected, this.locksDetected, this.constructedObjectsDetected, this.richMansConflictScanRequired, this.abortOnlyDetected, this.ensureDetected, newMinimalLength);
    }

    public SpeculativeGammaConfiguration newWithLocks() {
        if (this.locksDetected) {
            return this;
        }
        return new SpeculativeGammaConfiguration(true, this.listenersDetected, this.commuteDetected, this.nonRefTypeDetected, this.orelseDetected, true, this.constructedObjectsDetected, this.richMansConflictScanRequired, this.abortOnlyDetected, this.ensureDetected, this.minimalLength);
    }

    public SpeculativeGammaConfiguration newWithAbortOnly() {
        if (this.abortOnlyDetected) {
            return this;
        }
        return new SpeculativeGammaConfiguration(true, this.listenersDetected, this.commuteDetected, this.nonRefTypeDetected, this.orelseDetected, this.locksDetected, this.constructedObjectsDetected, this.richMansConflictScanRequired, true, this.ensureDetected, this.minimalLength);
    }

    public SpeculativeGammaConfiguration newWithConstructedObjects() {
        if (this.constructedObjectsDetected) {
            return this;
        }
        return new SpeculativeGammaConfiguration(true, this.listenersDetected, this.commuteDetected, this.nonRefTypeDetected, this.orelseDetected, this.locksDetected, true, this.richMansConflictScanRequired, this.abortOnlyDetected, this.ensureDetected, this.minimalLength);
    }

    public SpeculativeGammaConfiguration newWithListeners() {
        if (this.listenersDetected) {
            return this;
        }
        return new SpeculativeGammaConfiguration(true, true, this.commuteDetected, this.nonRefTypeDetected, this.orelseDetected, this.locksDetected, this.constructedObjectsDetected, this.richMansConflictScanRequired, this.abortOnlyDetected, this.ensureDetected, this.minimalLength);
    }

    public SpeculativeGammaConfiguration newWithOrElse() {
        if (this.orelseDetected) {
            return this;
        }
        return new SpeculativeGammaConfiguration(true, this.listenersDetected, this.commuteDetected, this.nonRefTypeDetected, true, this.locksDetected, this.constructedObjectsDetected, this.richMansConflictScanRequired, this.abortOnlyDetected, this.ensureDetected, this.minimalLength);
    }

    public SpeculativeGammaConfiguration newWithNonRefType() {
        if (this.nonRefTypeDetected) {
            return this;
        }
        return new SpeculativeGammaConfiguration(true, this.listenersDetected, this.commuteDetected, true, this.orelseDetected, this.locksDetected, this.constructedObjectsDetected, this.richMansConflictScanRequired, this.abortOnlyDetected, this.ensureDetected, this.minimalLength);
    }

    public SpeculativeGammaConfiguration newWithCommute() {
        if (this.commuteDetected) {
            return this;
        }
        return new SpeculativeGammaConfiguration(true, this.listenersDetected, true, this.nonRefTypeDetected, this.orelseDetected, this.locksDetected, this.constructedObjectsDetected, this.richMansConflictScanRequired, this.abortOnlyDetected, this.ensureDetected, this.minimalLength);
    }

    public SpeculativeGammaConfiguration newWithRichMansConflictScan() {
        if (this.richMansConflictScanRequired) {
            return this;
        }
        return new SpeculativeGammaConfiguration(true, this.listenersDetected, this.commuteDetected, this.nonRefTypeDetected, this.orelseDetected, this.locksDetected, this.constructedObjectsDetected, true, this.abortOnlyDetected, this.ensureDetected, this.minimalLength);
    }

    public SpeculativeGammaConfiguration newWithEnsure() {
        if (this.ensureDetected) {
            return this;
        }
        return new SpeculativeGammaConfiguration(true, this.listenersDetected, this.commuteDetected, this.nonRefTypeDetected, this.orelseDetected, this.locksDetected, this.constructedObjectsDetected, true, this.abortOnlyDetected, true, this.minimalLength);
    }

    public String toString() {
        return "SpeculativeGammaConfiguration{ isFat=" + this.fat + ", listenersDetected=" + this.listenersDetected + ", commuteDetected=" + this.commuteDetected + ", nonRefTypeDetected=" + this.nonRefTypeDetected + ", locksDetected=" + this.locksDetected + ", orelseDetected=" + this.orelseDetected + ", minimalLength=" + this.minimalLength + ", richMansConflictScanDetected=" + this.richMansConflictScanRequired + ", constructedObjectsDetected=" + this.constructedObjectsDetected + ", abortOnlyDetected=" + this.abortOnlyDetected + ", ensureDetected=" + this.ensureDetected + '}';
    }
}

