/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.database;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.config.ApplicationConfiguration;
import org.grails.forge.feature.database.DatabaseDriverConfigurationFeature;
import org.grails.forge.feature.database.DatabaseDriverFeature;
import org.grails.forge.feature.database.MongoFeature;
import org.grails.forge.feature.database.MongoGorm;
import org.grails.forge.feature.database.MySQL;
import org.grails.forge.feature.database.PostgreSQL;
import org.grails.forge.feature.database.SQLServer;
import org.grails.forge.options.TestFramework;
import org.grails.forge.template.StringTemplate;

@Singleton
public class TestContainers
implements Feature {
    private static final String TESTCONTAINERS_GROUP_ID = "org.testcontainers";

    @Override
    @NonNull
    public String getName() {
        return "testcontainers";
    }

    @Override
    public String getTitle() {
        return "Testcontainers";
    }

    @Override
    public String getCategory() {
        return "Testing";
    }

    @Override
    public String getDescription() {
        return "Leverage Testcontainers to run databases and other services in Docker containers during testing.";
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        generatorContext.addDependency(TestContainers.testContainerTestDependency("testcontainers"));
        generatorContext.getFeature(DatabaseDriverFeature.class).ifPresent(driverFeature -> generatorContext.getFeature(DatabaseDriverConfigurationFeature.class).ifPresent(driverConfiguration -> {
            String driver = "org.testcontainers.jdbc.ContainerDatabaseDriver";
            if (driverFeature instanceof SQLServer) {
                generatorContext.addTemplate("sqlserverEula", new StringTemplate("src/test/resources/container-license-acceptance.txt", "mcr.microsoft.com/mssql/server:2019-CU4-ubuntu-16.04"));
            }
            TestContainers.urlForDatabaseDriverFeature(driverFeature).ifPresent(url -> {
                ApplicationConfiguration testConfig = generatorContext.getConfiguration("test", ApplicationConfiguration.testConfig());
                testConfig.put(driverConfiguration.getUrlKey(), url);
                testConfig.put(driverConfiguration.getDriverKey(), driver);
            });
            TestContainers.artifactIdForDriverFeature(driverFeature).ifPresent(dependencyArtifactId -> generatorContext.addDependency(TestContainers.testContainerTestDependency(dependencyArtifactId)));
        }));
        TestContainers.testContainerArtifactIdByTestFramework(generatorContext.getTestFramework()).ifPresent(testArtifactId -> generatorContext.addDependency(TestContainers.testContainerTestDependency(testArtifactId)));
        if (generatorContext.isFeaturePresent(MongoFeature.class) || generatorContext.isFeaturePresent(MongoGorm.class)) {
            generatorContext.addDependency(TestContainers.testContainerTestDependency("mongodb"));
        }
    }

    @NonNull
    private static Dependency.Builder testContainerTestDependency(@NonNull String artifactId) {
        return Dependency.builder().groupId(TESTCONTAINERS_GROUP_ID).artifactId(artifactId).testImplementation();
    }

    @NonNull
    private static Optional<String> testContainerArtifactIdByTestFramework(TestFramework testFramework) {
        if (testFramework == TestFramework.SPOCK) {
            return Optional.of("spock");
        }
        if (testFramework == TestFramework.JUNIT) {
            return Optional.of("junit-jupiter");
        }
        return Optional.empty();
    }

    @NonNull
    private static Optional<String> artifactIdForDriverFeature(@NonNull DatabaseDriverFeature driverFeature) {
        if (driverFeature instanceof MySQL) {
            return Optional.of("mysql");
        }
        if (driverFeature instanceof PostgreSQL) {
            return Optional.of("postgresql");
        }
        if (driverFeature instanceof SQLServer) {
            return Optional.of("mssqlserver");
        }
        return Optional.empty();
    }

    @NonNull
    private static Optional<String> urlForDatabaseDriverFeature(@NonNull DatabaseDriverFeature driverFeature) {
        if (driverFeature instanceof MySQL) {
            return Optional.of("jdbc:tc:mysql:8:///db");
        }
        if (driverFeature instanceof PostgreSQL) {
            return Optional.of("jdbc:tc:postgresql:12:///postgres");
        }
        if (driverFeature instanceof SQLServer) {
            return Optional.of("jdbc:tc:sqlserver:2019-CU4-ubuntu-16.04://databaseName=tempdb");
        }
        return Optional.empty();
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return true;
    }

    @Override
    @Nullable
    public String getThirdPartyDocumentation() {
        return "https://java.testcontainers.org/";
    }
}

