/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.engine.event;

import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEvent;
import org.grails.datastore.mapping.engine.event.PersistenceEventListener;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractPersistenceEventListener
implements PersistenceEventListener {
    protected Datastore datastore;

    protected AbstractPersistenceEventListener(Datastore datastore) {
        this.datastore = datastore;
    }

    @Override
    public final void onApplicationEvent(ApplicationEvent e) {
        if (e instanceof AbstractPersistenceEvent) {
            AbstractPersistenceEvent event = (AbstractPersistenceEvent)e;
            if (!this.isValidSource(event)) {
                return;
            }
            if (event.isCancelled()) {
                return;
            }
            if (event.isListenerExcluded(this.getClass().getName())) {
                return;
            }
            this.onPersistenceEvent(event);
        }
    }

    protected boolean isValidSource(AbstractPersistenceEvent event) {
        Object source = event.getSource();
        return source instanceof Datastore && source.equals(this.datastore);
    }

    protected abstract void onPersistenceEvent(AbstractPersistenceEvent var1);

    @Override
    public int getOrder() {
        return 0x3FFFFFFF;
    }

    @Override
    public boolean supportsSourceType(Class<?> sourceType) {
        return this.datastore.getClass().isAssignableFrom(sourceType);
    }
}

