/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan.resourceprovider;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.flink.agents.api.resource.Resource;
import org.apache.flink.agents.api.resource.ResourceType;
import org.apache.flink.agents.api.resource.SerializableResource;
import org.apache.flink.agents.plan.resourceprovider.SerializableResourceProvider;

public class PythonSerializableResourceProvider
extends SerializableResourceProvider {
    private final Map<String, Object> serialized;
    private SerializableResource resource;

    public PythonSerializableResourceProvider(String name, ResourceType type, String module, String clazz, Map<String, Object> serialized) {
        super(name, type, module, clazz);
        this.serialized = serialized;
    }

    public PythonSerializableResourceProvider(String name, ResourceType type, String module, String clazz, Map<String, Object> serialized, SerializableResource resource) {
        this(name, type, module, clazz, serialized);
        this.resource = resource;
    }

    public Map<String, Object> getSerialized() {
        return this.serialized;
    }

    public SerializableResource getResource() {
        return this.resource;
    }

    @Override
    public Resource provide(BiFunction<String, ResourceType, Resource> getResource) throws Exception {
        throw new UnsupportedOperationException("Python resource deserialization not yet implemented in Java runtime");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PythonSerializableResourceProvider that = (PythonSerializableResourceProvider)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals((Object)this.getType(), (Object)that.getType()) && Objects.equals(this.getModule(), that.getModule()) && Objects.equals(this.getClazz(), that.getClazz()) && Objects.equals(this.serialized, that.serialized);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getType(), this.getModule(), this.getClazz(), this.serialized});
    }
}

