/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.view.dialogs.Messages;
import org.apache.directory.studio.schemaeditor.view.dialogs.ObjectClassSelectionDialogContentProvider;
import org.apache.directory.studio.schemaeditor.view.dialogs.ObjectClassSelectionDialogLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ObjectClassSelectionDialog
extends Dialog {
    private ObjectClass selectedObjectClass;
    private List<ObjectClass> hiddenObjectClasses = new ArrayList<ObjectClass>();
    private Text searchText;
    private Table objectClassesTable;
    private TableViewer objectClassesTableViewer;
    private Label schemaIconLabel;
    private Label schemaNameLabel;
    private Button chooseButton;

    public ObjectClassSelectionDialog() {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("ObjectClassSelectionDialog.ClassSelection"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        Label chooseLabel = new Label(composite, 0);
        chooseLabel.setText(Messages.getString("ObjectClassSelectionDialog.ChooseClass"));
        chooseLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.searchText = new Text(composite, 2176);
        this.searchText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ObjectClassSelectionDialog.this.setSearchInput(ObjectClassSelectionDialog.this.searchText.getText());
            }
        });
        this.searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    ObjectClassSelectionDialog.this.objectClassesTable.setFocus();
                }
            }
        });
        Label matchingLabel = new Label(composite, 0);
        matchingLabel.setText(Messages.getString("ObjectClassSelectionDialog.MatchingClasses"));
        matchingLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.objectClassesTable = new Table(composite, 101124);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 148;
        gridData.minimumHeight = 148;
        gridData.widthHint = 350;
        gridData.minimumWidth = 350;
        this.objectClassesTable.setLayoutData((Object)gridData);
        this.objectClassesTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (ObjectClassSelectionDialog.this.objectClassesTable.getSelectionIndex() != -1) {
                    ObjectClassSelectionDialog.this.okPressed();
                }
            }
        });
        this.objectClassesTableViewer = new TableViewer(this.objectClassesTable);
        this.objectClassesTableViewer.setContentProvider((IContentProvider)new ObjectClassSelectionDialogContentProvider(this.hiddenObjectClasses));
        this.objectClassesTableViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new ObjectClassSelectionDialogLabelProvider(), Activator.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.objectClassesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)ObjectClassSelectionDialog.this.objectClassesTableViewer.getSelection();
                if (selection.isEmpty()) {
                    if (ObjectClassSelectionDialog.this.chooseButton != null && !ObjectClassSelectionDialog.this.chooseButton.isDisposed()) {
                        ObjectClassSelectionDialog.this.chooseButton.setEnabled(false);
                    }
                    ObjectClassSelectionDialog.this.schemaIconLabel.setImage(Activator.getDefault().getImage("resources/icons/transparent_16x16.gif"));
                    ObjectClassSelectionDialog.this.schemaNameLabel.setText("");
                } else {
                    if (ObjectClassSelectionDialog.this.chooseButton != null && !ObjectClassSelectionDialog.this.chooseButton.isDisposed()) {
                        ObjectClassSelectionDialog.this.chooseButton.setEnabled(true);
                    }
                    ObjectClassSelectionDialog.this.schemaIconLabel.setImage(Activator.getDefault().getImage("resources/icons/schema.gif"));
                    ObjectClassSelectionDialog.this.schemaNameLabel.setText(((ObjectClass)selection.getFirstElement()).getSchemaName());
                }
            }
        });
        Composite schemaComposite = new Composite(composite, 2048);
        schemaComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        GridLayout schemaCompositeGridLayout = new GridLayout(2, false);
        schemaCompositeGridLayout.horizontalSpacing = 0;
        schemaCompositeGridLayout.verticalSpacing = 0;
        schemaCompositeGridLayout.marginWidth = 2;
        schemaCompositeGridLayout.marginHeight = 2;
        schemaComposite.setLayout((Layout)schemaCompositeGridLayout);
        this.schemaIconLabel = new Label(schemaComposite, 0);
        GridData schemaIconLabelGridData = new GridData(0, 1024, false, false);
        schemaIconLabelGridData.widthHint = 18;
        schemaIconLabelGridData.heightHint = 16;
        this.schemaIconLabel.setLayoutData((Object)schemaIconLabelGridData);
        this.schemaIconLabel.setImage(Activator.getDefault().getImage("resources/icons/transparent_16x16.gif"));
        this.schemaNameLabel = new Label(schemaComposite, 0);
        this.schemaNameLabel.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.schemaNameLabel.setText("");
        this.setSearchInput("");
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.chooseButton = this.createButton(parent, 0, Messages.getString("ObjectClassSelectionDialog.Choose"), true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        StructuredSelection selection = (StructuredSelection)this.objectClassesTableViewer.getSelection();
        if (selection.isEmpty()) {
            if (this.chooseButton != null && !this.chooseButton.isDisposed()) {
                this.chooseButton.setEnabled(false);
            }
        } else if (this.chooseButton != null && !this.chooseButton.isDisposed()) {
            this.chooseButton.setEnabled(true);
        }
    }

    protected void okPressed() {
        StructuredSelection selection = (StructuredSelection)this.objectClassesTableViewer.getSelection();
        if (selection.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("ObjectClassSelectionDialog.InvalidSelection"), (String)Messages.getString("ObjectClassSelectionDialog.MustChooseClass"));
            return;
        }
        this.selectedObjectClass = (ObjectClass)selection.getFirstElement();
        super.okPressed();
    }

    public ObjectClass getSelectedObjectClass() {
        return this.selectedObjectClass;
    }

    public void setHiddenObjectClasses(List<ObjectClass> list) {
        this.hiddenObjectClasses = list;
    }

    public void setHiddenObjectClasses(ObjectClass[] objectClasses) {
        ObjectClass[] objectClassArray = objectClasses;
        int n = objectClasses.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectClass objectClass = objectClassArray[n2];
            this.hiddenObjectClasses.add(objectClass);
            ++n2;
        }
    }

    private void setSearchInput(String searchString) {
        this.objectClassesTableViewer.setInput((Object)searchString);
        Object firstElement = this.objectClassesTableViewer.getElementAt(0);
        if (firstElement != null) {
            this.objectClassesTableViewer.setSelection((ISelection)new StructuredSelection(firstElement), true);
        }
    }

    public boolean close() {
        this.hiddenObjectClasses.clear();
        this.hiddenObjectClasses = null;
        this.objectClassesTableViewer = null;
        this.objectClassesTable.dispose();
        this.objectClassesTable = null;
        this.searchText.dispose();
        this.searchText = null;
        this.schemaIconLabel.dispose();
        this.schemaIconLabel = null;
        this.schemaNameLabel.dispose();
        this.schemaNameLabel = null;
        return super.close();
    }
}

