/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.apacheds;

import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.ldapservers.apacheds.ApacheDS200LdapServerAdapter;
import org.apache.directory.studio.ldapservers.apacheds.Messages;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.model.LdapServerStatus;
import org.eclipse.osgi.util.NLS;

public class RepairRunnable
implements StudioRunnableWithProgress {
    private LdapServer server;

    public RepairRunnable(LdapServer server) {
        this.server = server;
    }

    public String getErrorMessage() {
        return NLS.bind((String)Messages.getString("RepairRunnable.UnableToRepair"), (Object[])new String[]{this.server.getName()});
    }

    public Object[] getLockedObjects() {
        return new Object[]{this.server};
    }

    public String getName() {
        return NLS.bind((String)Messages.getString("RepairRunnable.Repair"), (Object[])new String[]{this.server.getName()});
    }

    public void run(StudioProgressMonitor monitor) {
        this.server.setStatus(LdapServerStatus.REPAIRING);
        try {
            ApacheDS200LdapServerAdapter adapter = new ApacheDS200LdapServerAdapter();
            adapter.repair(this.server, monitor);
        }
        catch (Exception e) {
            this.server.setStatus(LdapServerStatus.STOPPED);
            monitor.reportError(e);
        }
    }
}

