/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.entry;

import org.apache.directory.studio.connection.ui.actions.CollapseAllAction;
import org.apache.directory.studio.connection.ui.actions.ExpandAllAction;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.DeleteAllValuesAction;
import org.apache.directory.studio.ldapbrowser.common.actions.FetchOperationalAttributesAction;
import org.apache.directory.studio.ldapbrowser.common.actions.NewAttributeAction;
import org.apache.directory.studio.ldapbrowser.common.actions.RefreshAction;
import org.apache.directory.studio.ldapbrowser.common.actions.proxy.EntryEditorActionProxy;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EditAttributeDescriptionAction;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetActionGroup;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetConfiguration;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.OpenDefaultEditorAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyAttributeDescriptionAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyDnAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopySearchFilterAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyUrlAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyValueAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.EntryEditorPropertiesAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.LocateDnInDitAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.NewBatchOperationAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.NewSearchAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.OpenSchemaBrowserAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.EntryEditor;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.EntryEditorShowInMenuManager;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.OpenEntryEditorAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.OpenEntryEditorPreferencePageAction;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.ToggleAutosaveAction;
import org.apache.directory.studio.utils.ActionUtils;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.actions.ActionFactory;

public class EntryEditorActionGroup
extends EntryEditorWidgetActionGroup {
    private ToggleAutosaveAction toggleAutosaveAction;
    private EntryEditorActionProxy openEntryValueEditorActionProxy;
    private OpenEntryEditorPreferencePageAction openEntryEditorPreferencePage;
    private CollapseAllAction collapseAllAction;
    private ExpandAllAction expandAllAction;
    private EntryEditorShowInMenuManager showInMenuManager;
    private static final String editAttributeDescriptionAction = "editAttributeDescriptionAction";
    private static final String refreshAttributesAction = "refreshAttributesAction";
    private static final String newAttributeAction = "newAttributeAction";
    private static final String newSearchAction = "newSearchDialogAction";
    private static final String newBatchOperationAction = "newBatchOperationAction";
    private static final String copyDnAction = "copyDnAction";
    private static final String copyUrlAction = "copyUrlAction";
    private static final String copyAttriuteDescriptionAction = "copyAttriuteDescriptionAction";
    private static final String copyDisplayValueAction = "copyDisplayValueAction";
    private static final String copyValueUtf8Action = "copyValueUtf8Action";
    private static final String copyValueBase64Action = "copyValueBase64Action";
    private static final String copyValueHexAction = "copyValueHexAction";
    private static final String copyValueAsLdifAction = "copyValueAsLdifAction";
    private static final String copySearchFilterAction = "copySearchFilterAction";
    private static final String copyNotSearchFilterAction = "copyNotSearchFilterAction";
    private static final String copyAndSearchFilterAction = "copyAndSearchFilterAction";
    private static final String copyOrSearchFilterAction = "copyOrSearchFilterAction";
    private static final String deleteAllValuesAction = "deleteAllValuesAction";
    private static final String locateDnInDitAction = "locateDnInDitAction";
    private static final String showOcdAction = "showOcdAction";
    private static final String showAtdAction = "showAtdAction";
    private static final String showEqualityMrdAction = "showEqualityMrdAction";
    private static final String showSubstringMrdAction = "showSubstringMrdAction";
    private static final String showOrderingMrdAction = "showOrderingMrdAction";
    private static final String showLsdAction = "showLsdAction";
    private static final String fetchOperationalAttributesAction = "fetchOperationalAttributesAction";

    public EntryEditorActionGroup(EntryEditor entryEditor) {
        super(entryEditor.getMainWidget(), (EntryEditorWidgetConfiguration)entryEditor.getConfiguration());
        TreeViewer viewer = entryEditor.getMainWidget().getViewer();
        ValueEditorManager valueEditorManager = entryEditor.getConfiguration().getValueEditorManager(viewer);
        this.openDefaultValueEditorActionProxy.dispose();
        this.openDefaultValueEditorActionProxy = new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new OpenDefaultEditorAction(viewer, this.openBestValueEditorActionProxy));
        this.openEntryValueEditorActionProxy = new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new OpenEntryEditorAction(viewer, valueEditorManager, (IValueEditor)valueEditorManager.getEntryValueEditor(), this));
        this.toggleAutosaveAction = new ToggleAutosaveAction(entryEditor);
        this.openEntryEditorPreferencePage = new OpenEntryEditorPreferencePageAction();
        this.collapseAllAction = new CollapseAllAction(viewer);
        this.expandAllAction = new ExpandAllAction(viewer);
        this.showInMenuManager = new EntryEditorShowInMenuManager(entryEditor);
        this.entryEditorActionMap.put(editAttributeDescriptionAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new EditAttributeDescriptionAction((Viewer)viewer)));
        this.entryEditorActionMap.put(refreshAttributesAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new RefreshAction()));
        this.entryEditorActionMap.put(newAttributeAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new NewAttributeAction()));
        this.entryEditorActionMap.put(newSearchAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new NewSearchAction()));
        this.entryEditorActionMap.put(newBatchOperationAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new NewBatchOperationAction()));
        this.entryEditorActionMap.put(locateDnInDitAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new LocateDnInDitAction()));
        this.entryEditorActionMap.put(showOcdAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new OpenSchemaBrowserAction(10)));
        this.entryEditorActionMap.put(showAtdAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new OpenSchemaBrowserAction(20)));
        this.entryEditorActionMap.put(showEqualityMrdAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new OpenSchemaBrowserAction(30)));
        this.entryEditorActionMap.put(showSubstringMrdAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new OpenSchemaBrowserAction(31)));
        this.entryEditorActionMap.put(showOrderingMrdAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new OpenSchemaBrowserAction(32)));
        this.entryEditorActionMap.put(showLsdAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new OpenSchemaBrowserAction(40)));
        this.entryEditorActionMap.put(copyDnAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new CopyDnAction()));
        this.entryEditorActionMap.put(copyUrlAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new CopyUrlAction()));
        this.entryEditorActionMap.put(copyAttriuteDescriptionAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new CopyAttributeDescriptionAction()));
        this.entryEditorActionMap.put(copyDisplayValueAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new CopyValueAction(CopyValueAction.Mode.DISPLAY, valueEditorManager)));
        this.entryEditorActionMap.put(copyValueUtf8Action, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new CopyValueAction(CopyValueAction.Mode.UTF8, valueEditorManager)));
        this.entryEditorActionMap.put(copyValueBase64Action, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new CopyValueAction(CopyValueAction.Mode.BASE64, valueEditorManager)));
        this.entryEditorActionMap.put(copyValueHexAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new CopyValueAction(CopyValueAction.Mode.HEX, valueEditorManager)));
        this.entryEditorActionMap.put(copyValueAsLdifAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new CopyValueAction(CopyValueAction.Mode.LDIF, valueEditorManager)));
        this.entryEditorActionMap.put(copySearchFilterAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new CopySearchFilterAction(0)));
        this.entryEditorActionMap.put(copyNotSearchFilterAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new CopySearchFilterAction(1)));
        this.entryEditorActionMap.put(copyAndSearchFilterAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new CopySearchFilterAction(2)));
        this.entryEditorActionMap.put(copyOrSearchFilterAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new CopySearchFilterAction(3)));
        this.entryEditorActionMap.put(deleteAllValuesAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new DeleteAllValuesAction()));
        this.entryEditorActionMap.put(fetchOperationalAttributesAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new FetchOperationalAttributesAction()));
        this.entryEditorActionMap.put("propertyDialogAction", new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new EntryEditorPropertiesAction(entryEditor)));
    }

    public void dispose() {
        if (this.toggleAutosaveAction != null) {
            this.deactivateGlobalActionHandlers();
            this.openEntryValueEditorActionProxy.dispose();
            this.openEntryValueEditorActionProxy = null;
            this.openEntryEditorPreferencePage = null;
            this.toggleAutosaveAction = null;
            this.expandAllAction.dispose();
            this.expandAllAction = null;
            this.collapseAllAction.dispose();
            this.collapseAllAction = null;
        }
        super.dispose();
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.entryEditorActionMap.get("newValueAction"));
        toolBarManager.add((IAction)this.entryEditorActionMap.get(newAttributeAction));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.entryEditorActionMap.get("deleteAction"));
        toolBarManager.add((IAction)this.entryEditorActionMap.get(deleteAllValuesAction));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.entryEditorActionMap.get(refreshAttributesAction));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.expandAllAction);
        toolBarManager.add((IAction)this.collapseAllAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.showQuickFilterAction);
        toolBarManager.update(true);
    }

    public void fillMenu(IMenuManager menuManager) {
        menuManager.add((IAction)this.openSortDialogAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.showDecoratedValuesAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.toggleAutosaveAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.openEntryEditorPreferencePage);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EntryEditorActionGroup.this.showDecoratedValuesAction.setChecked(!BrowserCommonActivator.getDefault().getPreferenceStore().getBoolean("showRawValues"));
                EntryEditorActionGroup.this.toggleAutosaveAction.updateSetChecked();
            }
        });
        menuManager.update(true);
    }

    protected void contextMenuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)this.entryEditorActionMap.get(newAttributeAction));
        menuManager.add((IAction)this.entryEditorActionMap.get("newValueAction"));
        menuManager.add((IAction)this.entryEditorActionMap.get(newSearchAction));
        menuManager.add((IAction)this.entryEditorActionMap.get(newBatchOperationAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.entryEditorActionMap.get(locateDnInDitAction));
        MenuManager schemaMenuManager = new MenuManager(Messages.getString("EntryEditorActionGroup.OpenSchemaBrowser"));
        schemaMenuManager.add((IAction)this.entryEditorActionMap.get(showOcdAction));
        schemaMenuManager.add((IAction)this.entryEditorActionMap.get(showAtdAction));
        schemaMenuManager.add((IAction)this.entryEditorActionMap.get(showEqualityMrdAction));
        schemaMenuManager.add((IAction)this.entryEditorActionMap.get(showSubstringMrdAction));
        schemaMenuManager.add((IAction)this.entryEditorActionMap.get(showOrderingMrdAction));
        schemaMenuManager.add((IAction)this.entryEditorActionMap.get(showLsdAction));
        menuManager.add((IContributionItem)schemaMenuManager);
        this.showInMenuManager.createMenuManager(menuManager);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.entryEditorActionMap.get("copyAction"));
        menuManager.add((IAction)this.entryEditorActionMap.get("pasteAction"));
        menuManager.add((IAction)this.entryEditorActionMap.get("deleteAction"));
        menuManager.add((IAction)this.entryEditorActionMap.get("selectAllAction"));
        MenuManager advancedMenuManager = new MenuManager(Messages.getString("EntryEditorActionGroup.Advanced"));
        advancedMenuManager.add((IAction)this.entryEditorActionMap.get(copyDnAction));
        advancedMenuManager.add((IAction)this.entryEditorActionMap.get(copyUrlAction));
        advancedMenuManager.add((IContributionItem)new Separator());
        advancedMenuManager.add((IAction)this.entryEditorActionMap.get(copyAttriuteDescriptionAction));
        advancedMenuManager.add((IContributionItem)new Separator());
        advancedMenuManager.add((IAction)this.entryEditorActionMap.get(copyDisplayValueAction));
        advancedMenuManager.add((IAction)this.entryEditorActionMap.get(copyValueUtf8Action));
        advancedMenuManager.add((IAction)this.entryEditorActionMap.get(copyValueBase64Action));
        advancedMenuManager.add((IAction)this.entryEditorActionMap.get(copyValueHexAction));
        advancedMenuManager.add((IContributionItem)new Separator());
        advancedMenuManager.add((IAction)this.entryEditorActionMap.get(copyValueAsLdifAction));
        advancedMenuManager.add((IContributionItem)new Separator());
        advancedMenuManager.add((IAction)this.entryEditorActionMap.get(copySearchFilterAction));
        advancedMenuManager.add((IAction)this.entryEditorActionMap.get(copyNotSearchFilterAction));
        advancedMenuManager.add((IAction)this.entryEditorActionMap.get(copyAndSearchFilterAction));
        advancedMenuManager.add((IAction)this.entryEditorActionMap.get(copyOrSearchFilterAction));
        advancedMenuManager.add((IContributionItem)new Separator());
        advancedMenuManager.add((IAction)this.entryEditorActionMap.get(deleteAllValuesAction));
        menuManager.add((IContributionItem)advancedMenuManager);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.entryEditorActionMap.get(editAttributeDescriptionAction));
        super.addEditMenu(menuManager);
        menuManager.add((IAction)this.openEntryValueEditorActionProxy);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.entryEditorActionMap.get(refreshAttributesAction));
        if (((EntryEditorActionProxy)this.entryEditorActionMap.get(fetchOperationalAttributesAction)).isEnabled()) {
            menuManager.add((IAction)this.entryEditorActionMap.get(fetchOperationalAttributesAction));
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IAction)this.entryEditorActionMap.get("propertyDialogAction"));
    }

    public void activateGlobalActionHandlers() {
        if (this.actionBars != null) {
            this.actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.entryEditorActionMap.get(refreshAttributesAction));
        }
        super.activateGlobalActionHandlers();
        IAction naa = (IAction)this.entryEditorActionMap.get(newAttributeAction);
        ActionUtils.activateActionHandler((IAction)naa);
        IAction lid = (IAction)this.entryEditorActionMap.get(locateDnInDitAction);
        ActionUtils.activateActionHandler((IAction)lid);
        IAction eada = (IAction)this.entryEditorActionMap.get(editAttributeDescriptionAction);
        ActionUtils.activateActionHandler((IAction)eada);
        ActionUtils.activateActionHandler((IAction)this.openEntryValueEditorActionProxy);
    }

    public void deactivateGlobalActionHandlers() {
        if (this.actionBars != null) {
            this.actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), null);
        }
        super.deactivateGlobalActionHandlers();
        IAction naa = (IAction)this.entryEditorActionMap.get(newAttributeAction);
        ActionUtils.deactivateActionHandler((IAction)naa);
        IAction lid = (IAction)this.entryEditorActionMap.get(locateDnInDitAction);
        ActionUtils.deactivateActionHandler((IAction)lid);
        IAction eada = (IAction)this.entryEditorActionMap.get(editAttributeDescriptionAction);
        ActionUtils.deactivateActionHandler((IAction)eada);
        ActionUtils.deactivateActionHandler((IAction)this.openEntryValueEditorActionProxy);
    }
}

