/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors;

import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.AbstractDialogValueEditor;
import org.apache.directory.studio.valueeditors.Messages;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractDialogBinaryValueEditor
extends AbstractDialogValueEditor {
    protected AbstractDialogBinaryValueEditor() {
    }

    @Override
    public String getDisplayValue(IValue value) {
        if (this.showRawValues()) {
            return AbstractDialogBinaryValueEditor.getPrintableString(value);
        }
        Object rawValue = this.getRawValue(value);
        if (rawValue == null) {
            return ">>> Error, the configured value editor can not handle this value! <<<";
        }
        if (rawValue instanceof byte[]) {
            byte[] data = (byte[])rawValue;
            return NLS.bind((String)Messages.getString("AbstractDialogBinaryValueEditor.BinaryDateNBytes"), (Object)data.length);
        }
        return Messages.getString("AbstractDialogBinaryValueEditor.InvalidData");
    }

    public static String getPrintableString(IValue value) {
        if (value == null) {
            return ">>> Error, the configured value editor can not handle this value! <<<";
        }
        if (value.isBinary()) {
            byte[] data = value.getBinaryValue();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (data != null && i < data.length && i < 512) {
                if (data[i] > 32 && data[i] < 127) {
                    sb.append((char)data[i]);
                } else {
                    sb.append('.');
                }
                ++i;
            }
            return sb.toString();
        }
        if (value.isString()) {
            return value.getStringValue();
        }
        return ">>> Error, the configured value editor can not handle this value! <<<";
    }

    @Override
    protected Object getEmptyRawValue(IAttribute attribute) {
        if (attribute.isBinary()) {
            return IValue.EMPTY_BINARY_VALUE;
        }
        return null;
    }

    @Override
    public Object getRawValue(IValue value) {
        if (value == null) {
            return null;
        }
        if (value.isString()) {
            return value.getBinaryValue();
        }
        if (value.isBinary()) {
            return value.getBinaryValue();
        }
        return null;
    }

    @Override
    public Object getStringOrBinaryValue(Object rawValue) {
        if (rawValue instanceof byte[]) {
            return rawValue;
        }
        return null;
    }
}

