/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.modify;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreModifyRequestAttributeValue
extends GrammarAction<LdapMessageContainer<ModifyRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreModifyRequestAttributeValue.class);

    public StoreModifyRequestAttributeValue() {
        super("Stores AttributeValue");
    }

    @Override
    public void action(LdapMessageContainer<ModifyRequest> container) {
        TLV tlv = container.getCurrentTLV();
        byte[] value = Strings.EMPTY_BYTES;
        Attribute currentAttribute = container.getCurrentAttribute();
        try {
            if (tlv.getLength() == 0) {
                currentAttribute.add("");
            } else {
                value = tlv.getValue().getData();
                if (container.isBinary(currentAttribute.getId())) {
                    container.getCurrentAttribute().add(new byte[][]{value});
                } else {
                    currentAttribute.add(Strings.utf8ToString(value));
                }
            }
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05131_VALUE_MODIFIED, new Object[]{value}));
        }
    }
}

