/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.sort;

import java.util.Iterator;
import java.util.List;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.AbstractControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.controls.sort.SortRequestContainer;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.controls.SortKey;
import org.apache.directory.api.ldap.model.message.controls.SortRequest;
import org.apache.directory.api.ldap.model.message.controls.SortRequestImpl;
import org.apache.directory.api.util.Strings;

public class SortRequestFactory
extends AbstractControlFactory<SortRequest> {
    public static final int ORDERING_RULE_TAG = 128;
    public static final int REVERSE_ORDER_TAG = 129;

    public SortRequestFactory(LdapApiService codec) {
        super(codec, "1.2.840.113556.1.4.473");
    }

    public SortRequest newControl() {
        return new SortRequestImpl();
    }

    private void encodeSortKeys(Asn1Buffer buffer, Iterator<SortKey> sortKeys) {
        if (sortKeys.hasNext()) {
            SortKey sortKey = sortKeys.next();
            this.encodeSortKeys(buffer, sortKeys);
            int start = buffer.getPos();
            if (sortKey.isReverseOrder()) {
                BerValue.encodeBoolean((Asn1Buffer)buffer, (byte)-127, (boolean)true);
            }
            if (sortKey.getMatchingRuleId() != null) {
                BerValue.encodeOctetString((Asn1Buffer)buffer, (byte)-128, (byte[])Strings.getBytesUtf8Ascii((String)sortKey.getMatchingRuleId()));
            }
            BerValue.encodeOctetString((Asn1Buffer)buffer, (String)sortKey.getAttributeTypeDesc());
            BerValue.encodeSequence((Asn1Buffer)buffer, (int)start);
        }
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, Control control) {
        SortRequest sortRequest = (SortRequest)control;
        int start = buffer.getPos();
        List sortKeys = sortRequest.getSortKeys();
        this.encodeSortKeys(buffer, sortKeys.iterator());
        BerValue.encodeSequence((Asn1Buffer)buffer, (int)start);
    }

    @Override
    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
        this.decodeValue(new SortRequestContainer(control), control, controlBytes);
    }
}

