/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.File;
import junit.framework.Test;
import org.apache.derby.impl.io.vfmem.PathUtil;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class PathUtilTest
extends BaseTestCase {
    private static final String SEP = File.separator;

    public PathUtilTest(String string) {
        super(string);
    }

    public void testGetParent() {
        PathUtilTest.assertNull((Object)PathUtil.getParent((String)""));
        PathUtilTest.assertNull((Object)PathUtil.getParent((String)File.separator));
        PathUtilTest.assertEquals((String)"seg0", (String)PathUtil.getParent((String)PathUtilTest.join("seg0", "c1.dat")));
        PathUtilTest.assertEquals((String)PathUtilTest.abs("seg0"), (String)PathUtil.getParent((String)PathUtilTest.joinAbs("seg0", "c1.dat")));
        PathUtilTest.assertNull((Object)PathUtil.getParent((String)("seg0" + SEP)));
        PathUtilTest.assertEquals((String)SEP, (String)PathUtil.getParent((String)PathUtilTest.abs("seg0" + SEP)));
        PathUtilTest.assertEquals((String)PathUtilTest.joinAbs("dir1", "dir2"), (String)PathUtil.getParent((String)PathUtilTest.joinAbs("dir1", "dir2", "myFile.txt")));
    }

    public void testGetBase() {
        PathUtilTest.assertEquals((String)"seg0", (String)PathUtil.getBaseName((String)"seg0"));
        PathUtilTest.assertEquals((String)"c1.dat", (String)PathUtil.getBaseName((String)PathUtilTest.join("seg0", "c1.dat")));
        PathUtilTest.assertEquals((String)"c1.dat", (String)PathUtil.getBaseName((String)PathUtilTest.joinAbs("seg0", "c1.dat")));
        PathUtilTest.assertEquals((String)"c1.dat", (String)PathUtil.getBaseName((String)PathUtilTest.join("aDir", "seg0", "c1.dat")));
        PathUtilTest.assertEquals((String)"c1.dat", (String)PathUtil.getBaseName((String)PathUtilTest.joinAbs("aDir", "seg0", "c1.dat")));
    }

    public static Test suite() {
        return new BaseTestSuite(PathUtilTest.class, "PathUtilTest suite");
    }

    public static String abs(String string) {
        return SEP + string;
    }

    public static String join(String string, String string2) {
        return string + SEP + string2;
    }

    public static String joinAbs(String string, String string2) {
        return SEP + PathUtilTest.join(string, string2);
    }

    public static String join(String string, String string2, String string3) {
        return string + SEP + string2 + SEP + string3;
    }

    public static String joinAbs(String string, String string2, String string3) {
        return SEP + PathUtilTest.join(string, string2, string3);
    }

    public static String join(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(SEP);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public static String joinAbs(String[] stringArray) {
        return SEP + PathUtilTest.join(stringArray);
    }
}

