/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.handler;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.cxf.fediz.core.spi.WAuthCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthentcationTypeCallbackHandler
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AuthentcationTypeCallbackHandler.class);

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof WAuthCallback) {
                WAuthCallback callback = (WAuthCallback)callbacks[i];
                String authenticationType = (String)callback.getRequest().getAttribute("wauth");
                if (authenticationType == null || authenticationType.length() == 0) {
                    LOG.debug("No authentication type found in request");
                    continue;
                }
                LOG.info("Authentication type '" + authenticationType + "' found in request");
                callback.setWauth(authenticationType);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }
}

