/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import com.google.common.net.MediaType;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.net.MediaTypeSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpServletSupport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServletSupport.class);

    private HttpServletSupport() {
    }

    public static void addNoCacheHeaders(@Nonnull HttpServletResponse response) {
        response.setHeader("Cache-control", "no-cache, no-store");
        response.setHeader("Pragma", "no-cache");
    }

    public static void setUTF8Encoding(@Nonnull HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
    }

    public static void setContentType(@Nonnull HttpServletResponse response, @Nullable String contentType) {
        response.setHeader("Content-Type", contentType);
    }

    public static String getRequestPathWithoutContext(@Nonnull HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (request.getPathInfo() == null) {
            return servletPath;
        }
        return servletPath + request.getPathInfo();
    }

    public static URI getFullRequestURI(@Nonnull HttpServletRequest request) {
        StringBuffer requestUrl = request.getRequestURL();
        String encodedQuery = StringSupport.trimOrNull(request.getQueryString());
        if (encodedQuery != null) {
            requestUrl.append("?").append(encodedQuery);
        }
        return URI.create(requestUrl.toString());
    }

    public static boolean validateContentType(@Nonnull HttpServletRequest request, @Nonnull @NonnullElements Set<MediaType> validTypes, boolean noContentTypeIsValid, boolean isOneOfStrategy) {
        return MediaTypeSupport.validateContentType(request.getContentType(), validTypes, noContentTypeIsValid, isOneOfStrategy);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public static List<Locale.LanguageRange> getLanguageRange(@Nonnull HttpServletRequest request) {
        String languages = StringSupport.trimOrNull(request.getHeader("Accept-Language"));
        if (languages != null) {
            try {
                return List.copyOf(Locale.LanguageRange.parse(languages));
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Could not parse provided languages '{}'", (Object)languages, (Object)e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Nullable
    public static String getRemoteAddr(@Nonnull ServletRequest request) {
        String addr = request.getRemoteAddr();
        if (addr != null && addr.startsWith("[") && addr.endsWith("]")) {
            return addr.substring(1, addr.length() - 1);
        }
        return addr;
    }
}

