/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.remoting.impl.TransportConfigurationUtil;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public class TransportConfiguration
implements Serializable {
    private static final long serialVersionUID = -3994528421527392679L;
    public static final String NAME_PARAM = "name";
    public static final String EXTRA_PROPERTY_PREFIX = "$.EP.";
    private String name;
    private String factoryClassName = "null";
    private Map<String, Object> params;
    private Map<String, Object> extraProps;
    private static final byte TYPE_BOOLEAN = 0;
    private static final byte TYPE_INT = 1;
    private static final byte TYPE_LONG = 2;
    private static final byte TYPE_STRING = 3;

    public JsonObject toJson() {
        return JsonLoader.createObjectBuilder().add(NAME_PARAM, this.name).add("factoryClassName", this.factoryClassName).add("params", (JsonValue)JsonUtil.toJsonObject(this.params)).add("extraProps", (JsonValue)JsonUtil.toJsonObject(this.extraProps)).build();
    }

    public static String[] splitHosts(String commaSeparatedHosts) {
        if (commaSeparatedHosts == null) {
            return new String[0];
        }
        String[] hosts = commaSeparatedHosts.split(",");
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = hosts[i].trim();
        }
        return hosts;
    }

    public TransportConfiguration() {
        this.params = new HashMap<String, Object>();
        this.extraProps = new HashMap<String, Object>();
    }

    public TransportConfiguration(String className, Map<String, Object> params, String name) {
        this(className, params, name, new HashMap<String, Object>());
    }

    public TransportConfiguration(String className, Map<String, Object> params, String name, Map<String, Object> extraProps) {
        this.factoryClassName = className;
        this.params = params == null || params.isEmpty() ? TransportConfigurationUtil.getDefaults(className) : params;
        this.name = name;
        this.extraProps = extraProps;
    }

    public TransportConfiguration newTransportConfig(String newName) {
        return new TransportConfiguration(this.factoryClassName, this.params, newName);
    }

    public TransportConfiguration(String className, Map<String, Object> params) {
        this(className, params, UUIDGenerator.getInstance().generateStringUUID());
    }

    public TransportConfiguration(String className) {
        this(className, new HashMap<String, Object>(), UUIDGenerator.getInstance().generateStringUUID());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, Object> getExtraParams() {
        return this.extraProps;
    }

    public Map<String, Object> getCombinedParams() {
        HashMap<String, Object> combined = new HashMap<String, Object>();
        if (this.params != null) {
            combined.putAll(this.params);
        }
        if (this.extraProps != null) {
            combined.putAll(this.extraProps);
        }
        return combined;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.factoryClassName, this.params);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TransportConfiguration)) {
            return false;
        }
        TransportConfiguration other = (TransportConfiguration)obj;
        return this.isSameParams(other) && Objects.equals(this.name, other.name) && (this.extraProps == other.extraProps || this.extraProps == null && other.extraProps.isEmpty() || other.extraProps == null && this.extraProps.isEmpty() || this.extraProps != null && other.extraProps != null && this.extraProps.equals(other.extraProps));
    }

    public boolean isSameParams(TransportConfiguration that) {
        if (!this.factoryClassName.equals(that.factoryClassName)) {
            return false;
        }
        return Objects.equals(this.params, that.params);
    }

    public boolean isEquivalent(TransportConfiguration otherConfig) {
        if (this.getFactoryClassName().equals(otherConfig.getFactoryClassName())) {
            return true;
        }
        if (this.getFactoryClassName().contains("Netty") && otherConfig.getFactoryClassName().contains("Netty")) {
            return true;
        }
        return this.getFactoryClassName().contains("InVM") && otherConfig.getFactoryClassName().contains("InVM");
    }

    public String toString() {
        StringBuilder str = new StringBuilder(TransportConfiguration.class.getSimpleName());
        str.append("(name=" + this.name + ", ");
        str.append("factory=" + (this.factoryClassName == null ? "null" : TransportConfiguration.replaceWildcardChars(this.factoryClassName)));
        str.append(")");
        str.append(TransportConfiguration.toStringParameters(this.params, this.extraProps));
        return str.toString();
    }

    public static String toStringParameters(Map<String, Object> params, Map<String, Object> extraProps) {
        StringBuilder str = new StringBuilder();
        if (params != null) {
            String val;
            String key;
            if (!params.isEmpty()) {
                str.append("?");
            }
            boolean first = true;
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (!first) {
                    str.append("&");
                }
                val = (key = entry.getKey()).toLowerCase().contains("password") ? "****" : (entry.getValue() == null ? "null" : entry.getValue().toString());
                str.append(TransportConfiguration.replaceWildcardChars(key)).append('=').append(TransportConfiguration.replaceWildcardChars(val));
                first = false;
            }
            if (extraProps != null) {
                for (Map.Entry<String, Object> entry : extraProps.entrySet()) {
                    if (!first) {
                        str.append("&");
                    }
                    key = entry.getKey();
                    val = entry.getValue() == null ? "null" : entry.getValue().toString();
                    str.append(TransportConfiguration.replaceWildcardChars(key)).append('=').append(TransportConfiguration.replaceWildcardChars(val));
                    first = false;
                }
            }
        }
        return str.toString();
    }

    private void encodeMap(ActiveMQBuffer buffer, Map<String, Object> map, String prefix) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            buffer.writeString((String)(prefix != null ? prefix + entry.getKey() : entry.getKey()));
            Object val = entry.getValue();
            if (val instanceof Boolean) {
                Boolean booleanValue = (Boolean)val;
                buffer.writeByte((byte)0);
                buffer.writeBoolean(booleanValue.booleanValue());
                continue;
            }
            if (val instanceof Integer) {
                Integer integer = (Integer)val;
                buffer.writeByte((byte)1);
                buffer.writeInt(integer.intValue());
                continue;
            }
            if (val instanceof Long) {
                Long longValue = (Long)val;
                buffer.writeByte((byte)2);
                buffer.writeLong(longValue.longValue());
                continue;
            }
            if (val instanceof String) {
                String string = (String)val;
                buffer.writeByte((byte)3);
                buffer.writeString(string);
                continue;
            }
            throw ActiveMQClientMessageBundle.BUNDLE.invalidEncodeType(val);
        }
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeString(this.name);
        buffer.writeString(this.factoryClassName);
        buffer.writeInt((this.params == null ? 0 : this.params.size()) + (this.extraProps == null ? 0 : this.extraProps.size()));
        if (this.params != null) {
            this.encodeMap(buffer, this.params, null);
        }
        if (this.extraProps != null) {
            this.encodeMap(buffer, this.extraProps, EXTRA_PROPERTY_PREFIX);
        }
    }

    public void decode(ActiveMQBuffer buffer) {
        this.name = buffer.readString();
        this.factoryClassName = buffer.readString();
        int num = buffer.readInt();
        if (this.params == null) {
            if (num > 0) {
                this.params = new HashMap<String, Object>();
            }
        } else {
            this.params.clear();
        }
        for (int i = 0; i < num; ++i) {
            String key = buffer.readString();
            byte type = buffer.readByte();
            Object val = switch (type) {
                case 0 -> buffer.readBoolean();
                case 1 -> buffer.readInt();
                case 2 -> buffer.readLong();
                case 3 -> buffer.readString();
                default -> throw ActiveMQClientMessageBundle.BUNDLE.invalidType(type);
            };
            if (key.startsWith(EXTRA_PROPERTY_PREFIX)) {
                if (this.extraProps == null) {
                    this.extraProps = new HashMap<String, Object>();
                }
                this.extraProps.put(key.substring(EXTRA_PROPERTY_PREFIX.length()), val);
                continue;
            }
            this.params.put(key, val);
        }
    }

    private static String replaceWildcardChars(String str) {
        return str.replace('.', '-');
    }

    public void setFactoryClassName(String factoryClassName) {
        this.factoryClassName = factoryClassName;
    }
}

