/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.NameBean;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.SAXException;

class MultipleConfigFilesTest {
    private static final String FORM_KEY = "nameForm";
    private static final String ACTION = "required";
    private ValidatorResources resources;

    MultipleConfigFilesTest() {
    }

    @BeforeEach
    protected void setUp() throws IOException, SAXException {
        InputStream[] streams = new InputStream[]{this.getClass().getResourceAsStream("MultipleConfigFilesTest-1-config.xml"), this.getClass().getResourceAsStream("MultipleConfigFilesTest-2-config.xml")};
        this.resources = new ValidatorResources(streams);
        for (InputStream stream : streams) {
            stream.close();
        }
    }

    @Test
    void testBothBlank() throws ValidatorException {
        NameBean name = new NameBean();
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult);
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION));
        Assertions.assertFalse((boolean)firstNameResult.isValid(ACTION));
        Assertions.assertNotNull((Object)lastNameResult);
        Assertions.assertTrue((boolean)lastNameResult.containsAction(ACTION));
        Assertions.assertFalse((boolean)lastNameResult.isValid(ACTION));
        Assertions.assertFalse((boolean)lastNameResult.containsAction("int"));
    }

    @Test
    void testMergedConfig() {
        Form form1 = this.resources.getForm("", "", "", "testForm1");
        Assertions.assertNotNull((Object)form1, (String)"Form 'testForm1' not found");
        Form form2 = this.resources.getForm("", "", "", "testForm2");
        Assertions.assertNotNull((Object)form2, (String)"Form 'testForm2' not found");
        Field field1 = form1.getField("testProperty1");
        Assertions.assertEquals((Object)"testConstValue1", (Object)field1.getVarValue("var11"), (String)"testProperty1 - const 1");
        Assertions.assertEquals((Object)"testConstValue2", (Object)field1.getVarValue("var12"), (String)"testProperty1 - const 2");
        Field field2 = form2.getField("testProperty2");
        Assertions.assertEquals((Object)"testConstValue1", (Object)field2.getVarValue("var21"), (String)"testProperty2 - const 1");
        Assertions.assertEquals((Object)"testConstValue2", (Object)field2.getVarValue("var22"), (String)"testProperty2 - const 2");
        Form form1Fr = this.resources.getForm("fr", "", "", "testForm1_fr");
        Assertions.assertNotNull((Object)form1Fr, (String)"Form 'testForm1_fr' not found");
        Form form2Fr = this.resources.getForm("fr", "", "", "testForm2_fr");
        Assertions.assertNotNull((Object)form2Fr, (String)"Form 'testForm2_fr' not found");
        Field field1Fr = form1Fr.getField("testProperty1_fr");
        Assertions.assertEquals((Object)"testConstValue1_fr", (Object)field1Fr.getVarValue("var11_fr"), (String)"testProperty1_fr - const 1");
        Assertions.assertEquals((Object)"testConstValue2_fr", (Object)field1Fr.getVarValue("var12_fr"), (String)"testProperty1_fr - const 2");
        Field field2Fr = form2Fr.getField("testProperty2_fr");
        Assertions.assertEquals((Object)"testConstValue1_fr", (Object)field2Fr.getVarValue("var21_fr"), (String)"testProperty2_fr - const 1");
        Assertions.assertEquals((Object)"testConstValue2_fr", (Object)field2Fr.getVarValue("var22_fr"), (String)"testProperty2_fr - const 2");
    }

    @Test
    void testRequiredFirstNameBlankLastNameShort() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("");
        name.setLastName("Test");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult);
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION));
        Assertions.assertFalse((boolean)firstNameResult.isValid(ACTION));
        Assertions.assertNotNull((Object)lastNameResult);
        Assertions.assertTrue((boolean)lastNameResult.containsAction("int"));
        Assertions.assertFalse((boolean)lastNameResult.isValid("int"));
    }

    @Test
    void testRequiredLastNameLong() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("Joe");
        name.setLastName("12345678");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult);
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION));
        Assertions.assertTrue((boolean)firstNameResult.isValid(ACTION));
        Assertions.assertNotNull((Object)lastNameResult);
        Assertions.assertTrue((boolean)lastNameResult.containsAction("int"));
        Assertions.assertTrue((boolean)lastNameResult.isValid("int"));
    }

    @Test
    void testRequiredLastNameShort() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("Test");
        name.setLastName("Test");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult);
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION));
        Assertions.assertTrue((boolean)firstNameResult.isValid(ACTION));
        Assertions.assertNotNull((Object)lastNameResult);
        Assertions.assertTrue((boolean)lastNameResult.containsAction("int"));
        Assertions.assertFalse((boolean)lastNameResult.isValid("int"));
    }
}

