/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model;

import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.xml.DocumentContainer;
import org.junit.jupiter.api.Test;

public class ExternalXMLNamespaceTest
extends AbstractJXPathTest {
    protected JXPathContext context;

    protected JXPathContext createContext(String model) {
        JXPathContext context = JXPathContext.newContext((Object)this.createDocumentContainer(model));
        context.registerNamespace("A", "foo");
        context.registerNamespace("B", "bar");
        return context;
    }

    protected DocumentContainer createDocumentContainer(String model) {
        DocumentContainer result = new DocumentContainer(AbstractJXPathTest.class.getResource("ExternalNS.xml"), model);
        result.setNamespaceAware(false);
        return result;
    }

    protected void doTest(String xpath, String model, String expected) {
        this.assertXPathValue(this.createContext(model), xpath, expected);
    }

    protected void doTestAttribute(String model) {
        this.doTest("/ElementA/@A:myAttr", model, "Mytype");
    }

    protected void doTestCreateAndSetAttribute(String model) {
        this.assertXPathCreatePathAndSetValue(this.createContext(model), "/ElementA/@A:newAttr", "newValue", "/ElementA[1]/@A:newAttr");
    }

    protected void doTestElement(String model) {
        this.doTest("/ElementA/B:ElementB", model, "MY VALUE");
    }

    @Test
    public void testAttributeDOM() {
        this.doTestAttribute("DOM");
    }

    @Test
    public void testCreateAndSetAttributeDOM() {
        this.doTestCreateAndSetAttribute("DOM");
    }

    @Test
    public void testElementDOM() {
        this.doTestElement("DOM");
    }
}

