/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.test.xml;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.apache.commons.jelly.Jelly;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class TestCData
extends TestCase {
    public TestCData(String arg) {
        super(arg);
    }

    public void testCData() throws Exception {
        Jelly jelly = new Jelly();
        jelly.setScript("file:src/test/org/apache/commons/jelly/test/xml/testCData.jelly");
        Script script = jelly.compileScript();
        JellyContext context = new JellyContext();
        script.run(context, XMLOutput.createDummyXMLOutput());
        String output = (String)context.getVariable("foo");
        TestCData.assertTrue((String)"'foo' is not null", (output != null ? 1 : 0) != 0);
        String golden = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        golden = golden + "<!DOCTYPE foo [\n";
        golden = golden + "  <!ELEMENT foo (#PCDATA)>\n";
        golden = golden + "]><foo></foo>";
        TestCData.assertEquals((String)"output should contain the CDATA section", (String)golden, (String)output);
    }

    public void testDom4JCData() throws SAXException {
        StringWriter writer = new StringWriter();
        OutputFormat format = new OutputFormat();
        XMLWriter xmlWriter = new XMLWriter((Writer)writer, format);
        xmlWriter.setEscapeText(false);
        XMLOutput output = new XMLOutput((ContentHandler)xmlWriter, (LexicalHandler)xmlWriter);
        String decl = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        String golden = "<!DOCTYPE foo [\n";
        golden = golden + "  <!ELEMENT foo (#PCDATA)>\n";
        golden = golden + "]><foo></foo>";
        output.startDocument();
        output.write(golden);
        output.endDocument();
        System.err.println("output was: '" + writer.toString() + "'");
        System.err.println("golden is : '" + golden + "'");
        TestCData.assertEquals((String)"output should contain the CDATA section", (String)(decl + golden), (String)writer.toString());
    }
}

