/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.configuration.tree.ViewNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestViewNode {
    ViewNode viewNode;
    ConfigurationNode node;
    ConfigurationNode child;
    ConfigurationNode attr;

    @Before
    public void setUp() throws Exception {
        this.node = new DefaultConfigurationNode();
        this.child = new DefaultConfigurationNode("child");
        this.attr = new DefaultConfigurationNode("attr");
        this.node.addChild(this.child);
        this.node.addAttribute(this.attr);
        this.viewNode = new ViewNode();
    }

    @Test
    public void testAddChild() {
        this.viewNode.addChild(this.child);
        Assert.assertEquals((String)"Parent was changed", (Object)this.node, (Object)this.child.getParentNode());
        Assert.assertEquals((String)"Child was not added", (long)1L, (long)this.viewNode.getChildrenCount());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNullChild() {
        this.viewNode.addChild(null);
    }

    @Test
    public void testAddAttribute() {
        this.viewNode.addAttribute(this.attr);
        Assert.assertEquals((String)"Parent was changed", (Object)this.node, (Object)this.attr.getParentNode());
        Assert.assertEquals((String)"Attribute was not added", (long)1L, (long)this.viewNode.getAttributeCount());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNullAttribute() {
        this.viewNode.addAttribute(null);
    }

    @Test
    public void testAppendChildren() {
        this.viewNode.addChild((ConfigurationNode)new DefaultConfigurationNode("testNode"));
        this.viewNode.appendChildren(this.node);
        Assert.assertEquals((String)"Wrong number of children", (long)2L, (long)this.viewNode.getChildrenCount());
        Assert.assertEquals((String)"Cannot find child", (Object)this.child, (Object)this.viewNode.getChild(1));
        Assert.assertEquals((String)"Parent was changed", (Object)this.node, (Object)this.viewNode.getChild(1).getParentNode());
    }

    @Test
    public void testAppendNullChildren() {
        this.viewNode.appendChildren(null);
        Assert.assertEquals((String)"Wrong number of children", (long)0L, (long)this.viewNode.getChildrenCount());
    }

    @Test
    public void testAppendAttributes() {
        this.viewNode.appendAttributes(this.node);
        Assert.assertEquals((String)"Wrong number of attributes", (long)1L, (long)this.viewNode.getAttributeCount());
        Assert.assertEquals((String)"Cannot find attribute", (Object)this.attr, (Object)this.viewNode.getAttribute(0));
        Assert.assertEquals((String)"Parent was changed", (Object)this.node, (Object)this.viewNode.getAttribute(0).getParentNode());
    }

    @Test
    public void testAppendNullAttributes() {
        this.viewNode.appendAttributes(null);
        Assert.assertEquals((String)"Wrong number of attributes", (long)0L, (long)this.viewNode.getAttributeCount());
    }
}

