/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.lang.ref.WeakReference;
import org.apache.commons.beanutils2.ConvertUtils;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.ClassReloader;
import org.apache.commons.beanutils2.converters.FloatConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MemoryTest {
    private void forceGarbageCollection(WeakReference<?> target) {
        int bytes = 2;
        while (target.get() != null) {
            System.gc();
            try {
                byte[] b = new byte[bytes];
                bytes *= 2;
            }
            catch (OutOfMemoryError e) {
                // empty catch block
                break;
            }
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComponentRegistersCustomConverter() throws Exception {
        ClassLoader origContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Assertions.assertEquals((Object)origContextClassLoader, (Object)ConvertUtils.class.getClassLoader());
            ClassReloader componentLoader = new ClassReloader(origContextClassLoader);
            Thread.currentThread().setContextClassLoader(componentLoader);
            Class<?> newFloatConverterClass = componentLoader.reload(FloatConverter.class);
            Object newFloatConverter = newFloatConverterClass.newInstance();
            Assertions.assertSame((Object)newFloatConverter.getClass().getClassLoader(), (Object)componentLoader);
            Assertions.assertInstanceOf(Converter.class, newFloatConverter, (String)"Converter loader via child does not implement parent type");
            ConvertUtils.register((Converter)((Converter)newFloatConverter), Float.TYPE);
            Converter componentConverter = ConvertUtils.lookup(Float.TYPE);
            Assertions.assertSame((Object)componentConverter.getClass().getClassLoader(), (Object)componentLoader);
            newFloatConverter = null;
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            Converter sharedConverter = ConvertUtils.lookup(Float.TYPE);
            Assertions.assertFalse((sharedConverter.getClass().getClassLoader() == componentLoader ? 1 : 0) != 0);
            Thread.currentThread().setContextClassLoader(componentLoader);
            Converter componentConverter2 = ConvertUtils.lookup(Float.TYPE);
            Assertions.assertSame((Object)componentConverter2.getClass().getClassLoader(), (Object)componentLoader);
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            WeakReference<ClassReloader> weakRefToComponent = new WeakReference<ClassReloader>(componentLoader);
            componentLoader = null;
            this.forceGarbageCollection(weakRefToComponent);
            Assertions.assertNull(weakRefToComponent.get(), (String)"Component classloader did not release properly; memory leak present");
        }
        finally {
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            ConvertUtils.deregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComponentRegistersStandardConverter() throws Exception {
        ClassLoader origContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Assertions.assertEquals((Object)origContextClassLoader, (Object)ConvertUtils.class.getClassLoader());
            ClassLoader componentLoader1 = new ClassLoader(){};
            ClassLoader componentLoader2 = new ClassLoader(){};
            Converter origFloatConverter = ConvertUtils.lookup(Float.TYPE);
            FloatConverter floatConverter1 = new FloatConverter();
            Thread.currentThread().setContextClassLoader(componentLoader1);
            Assertions.assertFalse((ConvertUtils.lookup(Float.TYPE) == origFloatConverter ? 1 : 0) != 0);
            ConvertUtils.register((Converter)floatConverter1, Float.TYPE);
            Assertions.assertSame((Object)ConvertUtils.lookup(Float.TYPE), (Object)floatConverter1);
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            Assertions.assertSame((Object)ConvertUtils.lookup(Float.TYPE), (Object)origFloatConverter);
            Thread.currentThread().setContextClassLoader(componentLoader2);
            Assertions.assertFalse((ConvertUtils.lookup(Float.TYPE) == origFloatConverter ? 1 : 0) != 0);
            Assertions.assertFalse((ConvertUtils.lookup(Float.TYPE) == floatConverter1 ? 1 : 0) != 0);
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            WeakReference<1> weakRefToComponent1 = new WeakReference<1>(componentLoader1);
            componentLoader1 = null;
            this.forceGarbageCollection(weakRefToComponent1);
            Assertions.assertNull(weakRefToComponent1.get(), (String)"Component classloader did not release properly; memory leak present");
        }
        finally {
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            ConvertUtils.deregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWeakReference() throws Exception {
        ClassLoader origContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassReloader componentLoader = new ClassReloader(origContextClassLoader);
            Thread.currentThread().setContextClassLoader(componentLoader);
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            WeakReference<ClassReloader> ref = new WeakReference<ClassReloader>(componentLoader);
            componentLoader = null;
            this.forceGarbageCollection(ref);
            Assertions.assertNull(ref.get());
        }
        finally {
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
            ConvertUtils.deregister();
        }
    }
}

