/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph.extension;

import java.util.HashMap;
import java.util.Map;
import javax.swing.undo.UndoableEdit;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.graph.GraphBuilder;
import org.apache.cayenne.modeler.graph.GraphMap;
import org.apache.cayenne.modeler.graph.GraphRegistry;
import org.apache.cayenne.modeler.graph.GraphType;
import org.apache.cayenne.modeler.graph.extension.EntityHandler;
import org.apache.cayenne.util.Util;
import org.jgraph.graph.DefaultGraphCell;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class GraphHandler
extends NamespaceAwareNestedTagHandler {
    static final String GRAPH_TAG = "graph";
    static final String ENTITY_TAG = "entity";
    Map<String, Map<String, ?>> propertiesMap;
    GraphType graphType;
    double scale;

    public GraphHandler(NamespaceAwareNestedTagHandler parent, Application application) {
        super(parent);
        this.loaderContext.addDataChannelListener(dataChannelDescriptor -> {
            GraphRegistry registry = application.getMetaData().get(dataChannelDescriptor, GraphRegistry.class);
            if (registry == null) {
                registry = new GraphRegistry();
                application.getMetaData().add(dataChannelDescriptor, registry);
            }
            GraphMap map = registry.getGraphMap(dataChannelDescriptor);
            GraphBuilder builder = map.createGraphBuilder(this.graphType, false);
            builder.getGraph().setScale(this.scale);
            HashMap propertiesMap = new HashMap();
            for (Map.Entry<String, Map<String, ?>> entry : this.propertiesMap.entrySet()) {
                DefaultGraphCell cell = builder.getEntityCell(entry.getKey());
                propertiesMap.put(cell, entry.getValue());
            }
            builder.getGraph().getGraphLayoutCache().getModel().removeUndoableEditListener(builder);
            builder.getGraph().getGraphLayoutCache().edit(propertiesMap, null, null, new UndoableEdit[0]);
            builder.getGraph().getGraphLayoutCache().getModel().addUndoableEditListener(builder);
        });
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "graph": {
                String type = attributes.getValue("type");
                if (Util.isEmptyString(type)) {
                    throw new SAXException("Graph type not specified");
                }
                this.graphType = GraphType.valueOf(type);
                this.scale = Double.valueOf(attributes.getValue("scale"));
                this.propertiesMap = new HashMap();
                return true;
            }
        }
        return false;
    }

    @Override
    protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String qName, Attributes attributes) {
        switch (localName) {
            case "entity": {
                return new EntityHandler(this);
            }
        }
        return super.createChildTagHandler(namespaceURI, localName, qName, attributes);
    }
}

