/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.firebird;

import org.apache.cayenne.access.translator.ejbql.EJBQLConditionTranslator;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.parser.EJBQLTrimSpecification;

public class FirebirdEJBQLConditionTranslator
extends EJBQLConditionTranslator {
    public FirebirdEJBQLConditionTranslator(EJBQLTranslationContext context) {
        super(context);
    }

    @Override
    public boolean visitTrim(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex < 0) {
            if (!(expression.getChild(0) instanceof EJBQLTrimSpecification)) {
                this.context.append(" {fn TRIM(");
            }
        } else if (finishedChildIndex + 1 == expression.getChildrenCount()) {
            this.context.append(")}");
        }
        return true;
    }

    @Override
    public boolean visitTrimLeading(EJBQLExpression expression) {
        this.context.append(" {fn TRIM(LEADING FROM ");
        return false;
    }

    @Override
    public boolean visitTrimTrailing(EJBQLExpression expression) {
        this.context.append(" {fn TRIM(TRAILING FROM ");
        return false;
    }

    @Override
    public boolean visitTrimBoth(EJBQLExpression expression) {
        this.context.append(" {fn TRIM(");
        return false;
    }

    @Override
    public boolean visitLower(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex < 0) {
            this.context.append(" {fn LOWER(");
            return true;
        }
        return super.visitLower(expression, finishedChildIndex);
    }

    @Override
    public boolean visitLocate(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex < 0) {
            this.context.append(" {fn POSITION(");
            return true;
        }
        return super.visitLocate(expression, finishedChildIndex);
    }

    @Override
    public boolean visitSubstring(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex < 0) {
            this.context.append(" SUBSTRING(");
        } else if (finishedChildIndex + 1 == expression.getChildrenCount()) {
            this.context.append(" AS INTEGER))");
        } else if (finishedChildIndex == 0) {
            this.context.append(" FROM CAST(");
        } else if (finishedChildIndex == 1) {
            this.context.append(" AS INTEGER) FOR CAST(");
        }
        return true;
    }
}

