/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ExtendedType;

public class LongType
implements ExtendedType<Long> {
    @Override
    public String getClassName() {
        return Long.class.getName();
    }

    @Override
    public Long materializeObject(ResultSet rs, int index, int type) throws Exception {
        long value = rs.getLong(index);
        return rs.wasNull() ? null : Long.valueOf(value);
    }

    @Override
    public Long materializeObject(CallableStatement rs, int index, int type) throws Exception {
        long value = rs.getLong(index);
        return rs.wasNull() ? null : Long.valueOf(value);
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Long value, int pos, int type, int scale) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else {
            statement.setLong(pos, value);
        }
    }

    @Override
    public String toString(Long value) {
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }
}

