/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.dbsync;

import java.sql.SQLException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.dbsync.SchemaUpdateStrategy;

public abstract class BaseSchemaUpdateStrategy
implements SchemaUpdateStrategy {
    protected volatile boolean run;
    protected final ThreadLocal<Boolean> threadRunInProgress = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSchema(DataNode dataNode) throws SQLException {
        Boolean inProgress = this.threadRunInProgress.get();
        if (!(this.run || inProgress != null && inProgress.booleanValue())) {
            BaseSchemaUpdateStrategy baseSchemaUpdateStrategy = this;
            synchronized (baseSchemaUpdateStrategy) {
                if (!this.run) {
                    try {
                        this.threadRunInProgress.set(true);
                        this.processSchemaUpdate(dataNode);
                        this.run = true;
                    }
                    finally {
                        this.threadRunInProgress.set(false);
                    }
                }
            }
        }
    }

    protected abstract void processSchemaUpdate(DataNode var1) throws SQLException;
}

