/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.camel.kafkaconnector.cassandra.source;


import org.apache.camel.kafkaconnector.common.SourceConnectorPropertyFactory;

final class CamelCassandraPropertyFactory extends SourceConnectorPropertyFactory<CamelCassandraPropertyFactory> {

    private CamelCassandraPropertyFactory() {

    }

    public CamelCassandraPropertyFactory withQuery(String query) {
        return setProperty("camel.kamelet.cassandra-source.query", query);
    }

    public CamelCassandraPropertyFactory withHosts(String hosts) {
        return setProperty("camel.kamelet.cassandra-source.connectionHost", hosts);
    }

    public CamelCassandraPropertyFactory withPort(int port) {
        return withPort(Integer.toString(port));
    }

    public CamelCassandraPropertyFactory withPort(String port) {
        return setProperty("camel.kamelet.cassandra-source.connectionPort", port);
    }

    public CamelCassandraPropertyFactory withKeySpace(String value) {
        return setProperty("camel.kamelet.cassandra-source.keyspace", value);
    }

    public CamelCassandraPropertyFactory withResultSetConversionStrategy(String value) {
        return setProperty("camel.endpoint.cql.resultSetConversionStrategy", value);
    }

    public static CamelCassandraPropertyFactory basic() {
        return new CamelCassandraPropertyFactory()
                .withName("CamelCassandraSourceConnector")
                .withTasksMax(1)
                .withConnectorClass("org.apache.camel.kafkaconnector.cassandrasource.CamelCassandrasourceSourceConnector")
                .withKeyConverterClass("org.apache.kafka.connect.storage.StringConverter")
                .withValueConverterClass("org.apache.kafka.connect.storage.StringConverter")
                .setProperty("camel.kamelet.cassandra-source.consistencyLevel", "ONE")
                .setProperty("camel.component.kamelet.location", "kamelets");
    }
}
