/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Generated by camel build tools - do NOT edit this file!
 */
package org.apache.camel.xml.out;

import java.io.IOException;
import java.io.Writer;
import java.util.Base64;
import java.util.List;
import javax.annotation.processing.Generated;

import java.lang.*;
import org.apache.camel.*;
import org.apache.camel.model.*;
import org.apache.camel.model.app.*;
import org.apache.camel.model.cloud.*;
import org.apache.camel.model.config.*;
import org.apache.camel.model.dataformat.*;
import org.apache.camel.model.errorhandler.*;
import org.apache.camel.model.language.*;
import org.apache.camel.model.loadbalancer.*;
import org.apache.camel.model.rest.*;
import org.apache.camel.model.tokenizer.*;
import org.apache.camel.model.transformer.*;
import org.apache.camel.model.validator.*;

@Generated("org.apache.camel.maven.packaging.XmlModelWriterGeneratorMojo")
public class ModelWriter extends BaseWriter {

    public ModelWriter(Writer writer, String namespace) throws IOException {
        super(writer, namespace);
    }

    public ModelWriter(Writer writer) throws IOException {
        super(writer, null);
    }

    public void writeAggregateDefinition(AggregateDefinition def) throws IOException {
        doWriteAggregateDefinition("aggregate", def);
    }
    public void writeBeanDefinition(BeanDefinition def) throws IOException {
        doWriteBeanDefinition("bean", def);
    }
    public void writeBeanFactoryDefinition(BeanFactoryDefinition def) throws IOException {
        doWriteBeanFactoryDefinition("beanFactory", def);
    }
    public void writeCatchDefinition(CatchDefinition def) throws IOException {
        doWriteCatchDefinition("doCatch", def);
    }
    public void writeChoiceDefinition(ChoiceDefinition def) throws IOException {
        doWriteChoiceDefinition("choice", def);
    }
    public void writeCircuitBreakerDefinition(CircuitBreakerDefinition def) throws IOException {
        doWriteCircuitBreakerDefinition("circuitBreaker", def);
    }
    public void writeClaimCheckDefinition(ClaimCheckDefinition def) throws IOException {
        doWriteClaimCheckDefinition("claimCheck", def);
    }
    public void writeContextScanDefinition(ContextScanDefinition def) throws IOException {
        doWriteContextScanDefinition("contextScan", def);
    }
    public void writeConvertBodyDefinition(ConvertBodyDefinition def) throws IOException {
        doWriteConvertBodyDefinition("convertBodyTo", def);
    }
    public void writeConvertHeaderDefinition(ConvertHeaderDefinition def) throws IOException {
        doWriteConvertHeaderDefinition("convertHeaderTo", def);
    }
    public void writeConvertVariableDefinition(ConvertVariableDefinition def) throws IOException {
        doWriteConvertVariableDefinition("convertVariableTo", def);
    }
    public void writeDelayDefinition(DelayDefinition def) throws IOException {
        doWriteDelayDefinition("delay", def);
    }
    public void writeDynamicRouterDefinition(DynamicRouterDefinition def) throws IOException {
        doWriteDynamicRouterDefinition("dynamicRouter", def);
    }
    public void writeEnrichDefinition(EnrichDefinition def) throws IOException {
        doWriteEnrichDefinition("enrich", def);
    }
    public void writeErrorHandlerDefinition(ErrorHandlerDefinition def) throws IOException {
        doWriteErrorHandlerDefinition("errorHandler", def);
    }
    public void writeExpressionSubElementDefinition(ExpressionSubElementDefinition def) throws IOException {
        doWriteExpressionSubElementDefinition("expression", def);
    }
    public void writeFaultToleranceConfigurationDefinition(FaultToleranceConfigurationDefinition def) throws IOException {
        doWriteFaultToleranceConfigurationDefinition("faultToleranceConfiguration", def);
    }
    public void writeFilterDefinition(FilterDefinition def) throws IOException {
        doWriteFilterDefinition("filter", def);
    }
    public void writeFinallyDefinition(FinallyDefinition def) throws IOException {
        doWriteFinallyDefinition("doFinally", def);
    }
    public void writeFromDefinition(FromDefinition def) throws IOException {
        doWriteFromDefinition("from", def);
    }
    public void writeGlobalOptionDefinition(GlobalOptionDefinition def) throws IOException {
        doWriteGlobalOptionDefinition("globalOption", def);
    }
    public void writeGlobalOptionsDefinition(GlobalOptionsDefinition def) throws IOException {
        doWriteGlobalOptionsDefinition("globalOptions", def);
    }
    public void writeIdempotentConsumerDefinition(IdempotentConsumerDefinition def) throws IOException {
        doWriteIdempotentConsumerDefinition("idempotentConsumer", def);
    }
    public void writeInputTypeDefinition(InputTypeDefinition def) throws IOException {
        doWriteInputTypeDefinition("inputType", def);
    }
    public void writeInterceptDefinition(InterceptDefinition def) throws IOException {
        doWriteInterceptDefinition("intercept", def);
    }
    public void writeInterceptFromDefinition(InterceptFromDefinition def) throws IOException {
        doWriteInterceptFromDefinition("interceptFrom", def);
    }
    public void writeInterceptSendToEndpointDefinition(InterceptSendToEndpointDefinition def) throws IOException {
        doWriteInterceptSendToEndpointDefinition("interceptSendToEndpoint", def);
    }
    public void writeKameletDefinition(KameletDefinition def) throws IOException {
        doWriteKameletDefinition("kamelet", def);
    }
    public void writeLoadBalanceDefinition(LoadBalanceDefinition def) throws IOException {
        doWriteLoadBalanceDefinition("loadBalance", def);
    }
    public void writeLogDefinition(LogDefinition def) throws IOException {
        doWriteLogDefinition("log", def);
    }
    public void writeLoopDefinition(LoopDefinition def) throws IOException {
        doWriteLoopDefinition("loop", def);
    }
    public void writeMarshalDefinition(MarshalDefinition def) throws IOException {
        doWriteMarshalDefinition("marshal", def);
    }
    public void writeMulticastDefinition(MulticastDefinition def) throws IOException {
        doWriteMulticastDefinition("multicast", def);
    }
    public void writeOnCompletionDefinition(OnCompletionDefinition def) throws IOException {
        doWriteOnCompletionDefinition("onCompletion", def);
    }
    public void writeOnExceptionDefinition(OnExceptionDefinition def) throws IOException {
        doWriteOnExceptionDefinition("onException", def);
    }
    public void writeOnFallbackDefinition(OnFallbackDefinition def) throws IOException {
        doWriteOnFallbackDefinition("onFallback", def);
    }
    public void writeOnWhenDefinition(OnWhenDefinition def) throws IOException {
        doWriteOnWhenDefinition("onWhen", def);
    }
    public void writeOptimisticLockRetryPolicyDefinition(OptimisticLockRetryPolicyDefinition def) throws IOException {
        doWriteOptimisticLockRetryPolicyDefinition("optimisticLockRetryPolicy", def);
    }
    public void writeOtherwiseDefinition(OtherwiseDefinition def) throws IOException {
        doWriteOtherwiseDefinition("otherwise", def);
    }
    public void writeOutputTypeDefinition(OutputTypeDefinition def) throws IOException {
        doWriteOutputTypeDefinition("outputType", def);
    }
    public void writePackageScanDefinition(PackageScanDefinition def) throws IOException {
        doWritePackageScanDefinition("packageScan", def);
    }
    public void writePausableDefinition(PausableDefinition def) throws IOException {
        doWritePausableDefinition("pausable", def);
    }
    public void writePipelineDefinition(PipelineDefinition def) throws IOException {
        doWritePipelineDefinition("pipeline", def);
    }
    public void writePolicyDefinition(PolicyDefinition def) throws IOException {
        doWritePolicyDefinition("policy", def);
    }
    public void writePollDefinition(PollDefinition def) throws IOException {
        doWritePollDefinition("poll", def);
    }
    public void writePollEnrichDefinition(PollEnrichDefinition def) throws IOException {
        doWritePollEnrichDefinition("pollEnrich", def);
    }
    public void writeProcessDefinition(ProcessDefinition def) throws IOException {
        doWriteProcessDefinition("process", def);
    }
    public void writePropertyDefinition(PropertyDefinition def) throws IOException {
        doWritePropertyDefinition("property", def);
    }
    public void writePropertyExpressionDefinition(PropertyExpressionDefinition def) throws IOException {
        doWritePropertyExpressionDefinition("propertyExpression", def);
    }
    public void writeRecipientListDefinition(RecipientListDefinition def) throws IOException {
        doWriteRecipientListDefinition("recipientList", def);
    }
    public void writeRedeliveryPolicyDefinition(RedeliveryPolicyDefinition def) throws IOException {
        doWriteRedeliveryPolicyDefinition("redeliveryPolicy", def);
    }
    public void writeRemoveHeaderDefinition(RemoveHeaderDefinition def) throws IOException {
        doWriteRemoveHeaderDefinition("removeHeader", def);
    }
    public void writeRemoveHeadersDefinition(RemoveHeadersDefinition def) throws IOException {
        doWriteRemoveHeadersDefinition("removeHeaders", def);
    }
    public void writeRemovePropertiesDefinition(RemovePropertiesDefinition def) throws IOException {
        doWriteRemovePropertiesDefinition("removeProperties", def);
    }
    public void writeRemovePropertyDefinition(RemovePropertyDefinition def) throws IOException {
        doWriteRemovePropertyDefinition("removeProperty", def);
    }
    public void writeRemoveVariableDefinition(RemoveVariableDefinition def) throws IOException {
        doWriteRemoveVariableDefinition("removeVariable", def);
    }
    public void writeResequenceDefinition(ResequenceDefinition def) throws IOException {
        doWriteResequenceDefinition("resequence", def);
    }
    public void writeResilience4jConfigurationDefinition(Resilience4jConfigurationDefinition def) throws IOException {
        doWriteResilience4jConfigurationDefinition("resilience4jConfiguration", def);
    }
    public void writeRestContextRefDefinition(RestContextRefDefinition def) throws IOException {
        doWriteRestContextRefDefinition("restContextRef", def);
    }
    public void writeResumableDefinition(ResumableDefinition def) throws IOException {
        doWriteResumableDefinition("resumable", def);
    }
    public void writeRollbackDefinition(RollbackDefinition def) throws IOException {
        doWriteRollbackDefinition("rollback", def);
    }
    public void writeRouteBuilderDefinition(RouteBuilderDefinition def) throws IOException {
        doWriteRouteBuilderDefinition("routeBuilder", def);
    }
    public void writeRouteConfigurationContextRefDefinition(RouteConfigurationContextRefDefinition def) throws IOException {
        doWriteRouteConfigurationContextRefDefinition("routeConfigurationContextRef", def);
    }
    public void writeRouteConfigurationDefinition(RouteConfigurationDefinition def) throws IOException {
        doWriteRouteConfigurationDefinition("routeConfiguration", def);
    }
    public void writeRouteConfigurationsDefinition(RouteConfigurationsDefinition def) throws IOException {
        doWriteRouteConfigurationsDefinition("routeConfigurations", def);
    }
    public void writeRouteContextRefDefinition(RouteContextRefDefinition def) throws IOException {
        doWriteRouteContextRefDefinition("routeContextRef", def);
    }
    public void writeRouteDefinition(RouteDefinition def) throws IOException {
        doWriteRouteDefinition("route", def);
    }
    public void writeRouteTemplateContextRefDefinition(RouteTemplateContextRefDefinition def) throws IOException {
        doWriteRouteTemplateContextRefDefinition("routeTemplateContextRef", def);
    }
    public void writeRouteTemplateDefinition(RouteTemplateDefinition def) throws IOException {
        doWriteRouteTemplateDefinition("routeTemplate", def);
    }
    public void writeRouteTemplateParameterDefinition(RouteTemplateParameterDefinition def) throws IOException {
        doWriteRouteTemplateParameterDefinition("templateParameter", def);
    }
    public void writeRouteTemplatesDefinition(RouteTemplatesDefinition def) throws IOException {
        doWriteRouteTemplatesDefinition("routeTemplates", def);
    }
    public void writeRoutesDefinition(RoutesDefinition def) throws IOException {
        doWriteRoutesDefinition("routes", def);
    }
    public void writeRoutingSlipDefinition(RoutingSlipDefinition def) throws IOException {
        doWriteRoutingSlipDefinition("routingSlip", def);
    }
    public void writeSagaDefinition(SagaDefinition def) throws IOException {
        doWriteSagaDefinition("saga", def);
    }
    public void writeSamplingDefinition(SamplingDefinition def) throws IOException {
        doWriteSamplingDefinition("sample", def);
    }
    public void writeScriptDefinition(ScriptDefinition def) throws IOException {
        doWriteScriptDefinition("script", def);
    }
    public void writeSetBodyDefinition(SetBodyDefinition def) throws IOException {
        doWriteSetBodyDefinition("setBody", def);
    }
    public void writeSetExchangePatternDefinition(SetExchangePatternDefinition def) throws IOException {
        doWriteSetExchangePatternDefinition("setExchangePattern", def);
    }
    public void writeSetHeaderDefinition(SetHeaderDefinition def) throws IOException {
        doWriteSetHeaderDefinition("setHeader", def);
    }
    public void writeSetHeadersDefinition(SetHeadersDefinition def) throws IOException {
        doWriteSetHeadersDefinition("setHeaders", def);
    }
    public void writeSetPropertyDefinition(SetPropertyDefinition def) throws IOException {
        doWriteSetPropertyDefinition("setProperty", def);
    }
    public void writeSetVariableDefinition(SetVariableDefinition def) throws IOException {
        doWriteSetVariableDefinition("setVariable", def);
    }
    public void writeSetVariablesDefinition(SetVariablesDefinition def) throws IOException {
        doWriteSetVariablesDefinition("setVariables", def);
    }
    public void writeSortDefinition(SortDefinition def) throws IOException {
        doWriteSortDefinition("sort", def);
    }
    public void writeSplitDefinition(SplitDefinition def) throws IOException {
        doWriteSplitDefinition("split", def);
    }
    public void writeStepDefinition(StepDefinition def) throws IOException {
        doWriteStepDefinition("step", def);
    }
    public void writeStopDefinition(StopDefinition def) throws IOException {
        doWriteStopDefinition("stop", def);
    }
    public void writeTemplatedRouteDefinition(TemplatedRouteDefinition def) throws IOException {
        doWriteTemplatedRouteDefinition("templatedRoute", def);
    }
    public void writeTemplatedRouteParameterDefinition(TemplatedRouteParameterDefinition def) throws IOException {
        doWriteTemplatedRouteParameterDefinition("templatedRouteParameter", def);
    }
    public void writeTemplatedRoutesDefinition(TemplatedRoutesDefinition def) throws IOException {
        doWriteTemplatedRoutesDefinition("templatedRoutes", def);
    }
    public void writeThreadPoolProfileDefinition(ThreadPoolProfileDefinition def) throws IOException {
        doWriteThreadPoolProfileDefinition("threadPoolProfile", def);
    }
    public void writeThreadsDefinition(ThreadsDefinition def) throws IOException {
        doWriteThreadsDefinition("threads", def);
    }
    public void writeThrottleDefinition(ThrottleDefinition def) throws IOException {
        doWriteThrottleDefinition("throttle", def);
    }
    public void writeThrowExceptionDefinition(ThrowExceptionDefinition def) throws IOException {
        doWriteThrowExceptionDefinition("throwException", def);
    }
    public void writeToDefinition(ToDefinition def) throws IOException {
        doWriteToDefinition("to", def);
    }
    public void writeToDynamicDefinition(ToDynamicDefinition def) throws IOException {
        doWriteToDynamicDefinition("toD", def);
    }
    public void writeTokenizerDefinition(TokenizerDefinition def) throws IOException {
        doWriteTokenizerDefinition("tokenizer", def);
    }
    public void writeTransactedDefinition(TransactedDefinition def) throws IOException {
        doWriteTransactedDefinition("transacted", def);
    }
    public void writeTransformDefinition(TransformDefinition def) throws IOException {
        doWriteTransformDefinition("transform", def);
    }
    public void writeTryDefinition(TryDefinition def) throws IOException {
        doWriteTryDefinition("doTry", def);
    }
    public void writeUnmarshalDefinition(UnmarshalDefinition def) throws IOException {
        doWriteUnmarshalDefinition("unmarshal", def);
    }
    public void writeValidateDefinition(ValidateDefinition def) throws IOException {
        doWriteValidateDefinition("validate", def);
    }
    public void writeValueDefinition(ValueDefinition def) throws IOException {
        doWriteValueDefinition("value", def);
    }
    public void writeWhenDefinition(WhenDefinition def) throws IOException {
        doWriteWhenDefinition("when", def);
    }
    public void writeWireTapDefinition(WireTapDefinition def) throws IOException {
        doWriteWireTapDefinition("wireTap", def);
    }
    public void writeApplicationDefinition(ApplicationDefinition def) throws IOException {
        doWriteApplicationDefinition("camel", def);
    }
    public void writeBeansDefinition(BeansDefinition def) throws IOException {
        doWriteBeansDefinition("beans", def);
    }
    public void writeBlacklistServiceCallServiceFilterConfiguration(BlacklistServiceCallServiceFilterConfiguration def) throws IOException {
        doWriteBlacklistServiceCallServiceFilterConfiguration("blacklistServiceFilter", def);
    }
    public void writeCachingServiceCallServiceDiscoveryConfiguration(CachingServiceCallServiceDiscoveryConfiguration def) throws IOException {
        doWriteCachingServiceCallServiceDiscoveryConfiguration("cachingServiceDiscovery", def);
    }
    public void writeCombinedServiceCallServiceDiscoveryConfiguration(CombinedServiceCallServiceDiscoveryConfiguration def) throws IOException {
        doWriteCombinedServiceCallServiceDiscoveryConfiguration("combinedServiceDiscovery", def);
    }
    public void writeCombinedServiceCallServiceFilterConfiguration(CombinedServiceCallServiceFilterConfiguration def) throws IOException {
        doWriteCombinedServiceCallServiceFilterConfiguration("combinedServiceFilter", def);
    }
    public void writeConsulServiceCallServiceDiscoveryConfiguration(ConsulServiceCallServiceDiscoveryConfiguration def) throws IOException {
        doWriteConsulServiceCallServiceDiscoveryConfiguration("consulServiceDiscovery", def);
    }
    public void writeCustomServiceCallServiceFilterConfiguration(CustomServiceCallServiceFilterConfiguration def) throws IOException {
        doWriteCustomServiceCallServiceFilterConfiguration("customServiceFilter", def);
    }
    public void writeDefaultServiceCallServiceLoadBalancerConfiguration(DefaultServiceCallServiceLoadBalancerConfiguration def) throws IOException {
        doWriteDefaultServiceCallServiceLoadBalancerConfiguration("defaultLoadBalancer", def);
    }
    public void writeDnsServiceCallServiceDiscoveryConfiguration(DnsServiceCallServiceDiscoveryConfiguration def) throws IOException {
        doWriteDnsServiceCallServiceDiscoveryConfiguration("dnsServiceDiscovery", def);
    }
    public void writeHealthyServiceCallServiceFilterConfiguration(HealthyServiceCallServiceFilterConfiguration def) throws IOException {
        doWriteHealthyServiceCallServiceFilterConfiguration("healthyServiceFilter", def);
    }
    public void writeKubernetesServiceCallServiceDiscoveryConfiguration(KubernetesServiceCallServiceDiscoveryConfiguration def) throws IOException {
        doWriteKubernetesServiceCallServiceDiscoveryConfiguration("kubernetesServiceDiscovery", def);
    }
    public void writePassThroughServiceCallServiceFilterConfiguration(PassThroughServiceCallServiceFilterConfiguration def) throws IOException {
        doWritePassThroughServiceCallServiceFilterConfiguration("passThroughServiceFilter", def);
    }
    public void writeServiceCallConfigurationDefinition(ServiceCallConfigurationDefinition def) throws IOException {
        doWriteServiceCallConfigurationDefinition("serviceCallConfiguration", def);
    }
    public void writeServiceCallDefinition(ServiceCallDefinition def) throws IOException {
        doWriteServiceCallDefinition("serviceCall", def);
    }
    public void writeServiceCallExpressionConfiguration(ServiceCallExpressionConfiguration def) throws IOException {
        doWriteServiceCallExpressionConfiguration("serviceExpression", def);
    }
    public void writeServiceCallServiceChooserConfiguration(ServiceCallServiceChooserConfiguration def) throws IOException {
        doWriteServiceCallServiceChooserConfiguration("serviceChooserConfiguration", def);
    }
    public void writeServiceCallServiceDiscoveryConfiguration(ServiceCallServiceDiscoveryConfiguration def) throws IOException {
        doWriteServiceCallServiceDiscoveryConfiguration("serviceDiscoveryConfiguration", def);
    }
    public void writeServiceCallServiceFilterConfiguration(ServiceCallServiceFilterConfiguration def) throws IOException {
        doWriteServiceCallServiceFilterConfiguration("serviceFilterConfiguration", def);
    }
    public void writeServiceCallServiceLoadBalancerConfiguration(ServiceCallServiceLoadBalancerConfiguration def) throws IOException {
        doWriteServiceCallServiceLoadBalancerConfiguration("loadBalancerConfiguration", def);
    }
    public void writeStaticServiceCallServiceDiscoveryConfiguration(StaticServiceCallServiceDiscoveryConfiguration def) throws IOException {
        doWriteStaticServiceCallServiceDiscoveryConfiguration("staticServiceDiscovery", def);
    }
    public void writeZooKeeperServiceCallServiceDiscoveryConfiguration(ZooKeeperServiceCallServiceDiscoveryConfiguration def) throws IOException {
        doWriteZooKeeperServiceCallServiceDiscoveryConfiguration("zookeeperServiceDiscovery", def);
    }
    public void writeBatchResequencerConfig(BatchResequencerConfig def) throws IOException {
        doWriteBatchResequencerConfig("batchConfig", def);
    }
    public void writeStreamResequencerConfig(StreamResequencerConfig def) throws IOException {
        doWriteStreamResequencerConfig("streamConfig", def);
    }
    public void writeASN1DataFormat(ASN1DataFormat def) throws IOException {
        doWriteASN1DataFormat("asn1", def);
    }
    public void writeAvroDataFormat(AvroDataFormat def) throws IOException {
        doWriteAvroDataFormat("avro", def);
    }
    public void writeBarcodeDataFormat(BarcodeDataFormat def) throws IOException {
        doWriteBarcodeDataFormat("barcode", def);
    }
    public void writeBase64DataFormat(Base64DataFormat def) throws IOException {
        doWriteBase64DataFormat("base64", def);
    }
    public void writeBeanioDataFormat(BeanioDataFormat def) throws IOException {
        doWriteBeanioDataFormat("beanio", def);
    }
    public void writeBindyDataFormat(BindyDataFormat def) throws IOException {
        doWriteBindyDataFormat("bindy", def);
    }
    public void writeCBORDataFormat(CBORDataFormat def) throws IOException {
        doWriteCBORDataFormat("cbor", def);
    }
    public void writeCryptoDataFormat(CryptoDataFormat def) throws IOException {
        doWriteCryptoDataFormat("crypto", def);
    }
    public void writeCsvDataFormat(CsvDataFormat def) throws IOException {
        doWriteCsvDataFormat("csv", def);
    }
    public void writeCustomDataFormat(CustomDataFormat def) throws IOException {
        doWriteCustomDataFormat("custom", def);
    }
    public void writeDataFormatsDefinition(DataFormatsDefinition def) throws IOException {
        doWriteDataFormatsDefinition("dataFormats", def);
    }
    public void writeDfdlDataFormat(DfdlDataFormat def) throws IOException {
        doWriteDfdlDataFormat("dfdl", def);
    }
    public void writeFhirJsonDataFormat(FhirJsonDataFormat def) throws IOException {
        doWriteFhirJsonDataFormat("fhirJson", def);
    }
    public void writeFhirXmlDataFormat(FhirXmlDataFormat def) throws IOException {
        doWriteFhirXmlDataFormat("fhirXml", def);
    }
    public void writeFlatpackDataFormat(FlatpackDataFormat def) throws IOException {
        doWriteFlatpackDataFormat("flatpack", def);
    }
    public void writeForyDataFormat(ForyDataFormat def) throws IOException {
        doWriteForyDataFormat("fory", def);
    }
    public void writeGrokDataFormat(GrokDataFormat def) throws IOException {
        doWriteGrokDataFormat("grok", def);
    }
    public void writeGzipDeflaterDataFormat(GzipDeflaterDataFormat def) throws IOException {
        doWriteGzipDeflaterDataFormat("gzipDeflater", def);
    }
    public void writeHL7DataFormat(HL7DataFormat def) throws IOException {
        doWriteHL7DataFormat("hl7", def);
    }
    public void writeIcalDataFormat(IcalDataFormat def) throws IOException {
        doWriteIcalDataFormat("ical", def);
    }
    public void writeIso8583DataFormat(Iso8583DataFormat def) throws IOException {
        doWriteIso8583DataFormat("iso8583", def);
    }
    public void writeJacksonXMLDataFormat(JacksonXMLDataFormat def) throws IOException {
        doWriteJacksonXMLDataFormat("jacksonXml", def);
    }
    public void writeJaxbDataFormat(JaxbDataFormat def) throws IOException {
        doWriteJaxbDataFormat("jaxb", def);
    }
    public void writeJsonApiDataFormat(JsonApiDataFormat def) throws IOException {
        doWriteJsonApiDataFormat("jsonApi", def);
    }
    public void writeJsonDataFormat(JsonDataFormat def) throws IOException {
        doWriteJsonDataFormat("json", def);
    }
    public void writeLZFDataFormat(LZFDataFormat def) throws IOException {
        doWriteLZFDataFormat("lzf", def);
    }
    public void writeMimeMultipartDataFormat(MimeMultipartDataFormat def) throws IOException {
        doWriteMimeMultipartDataFormat("mimeMultipart", def);
    }
    public void writePGPDataFormat(PGPDataFormat def) throws IOException {
        doWritePGPDataFormat("pgp", def);
    }
    public void writeParquetAvroDataFormat(ParquetAvroDataFormat def) throws IOException {
        doWriteParquetAvroDataFormat("parquetAvro", def);
    }
    public void writeProtobufDataFormat(ProtobufDataFormat def) throws IOException {
        doWriteProtobufDataFormat("protobuf", def);
    }
    public void writeRssDataFormat(RssDataFormat def) throws IOException {
        doWriteRssDataFormat("rss", def);
    }
    public void writeSmooksDataFormat(SmooksDataFormat def) throws IOException {
        doWriteSmooksDataFormat("smooks", def);
    }
    public void writeSoapDataFormat(SoapDataFormat def) throws IOException {
        doWriteSoapDataFormat("soap", def);
    }
    public void writeSwiftMtDataFormat(SwiftMtDataFormat def) throws IOException {
        doWriteSwiftMtDataFormat("swiftMt", def);
    }
    public void writeSwiftMxDataFormat(SwiftMxDataFormat def) throws IOException {
        doWriteSwiftMxDataFormat("swiftMx", def);
    }
    public void writeSyslogDataFormat(SyslogDataFormat def) throws IOException {
        doWriteSyslogDataFormat("syslog", def);
    }
    public void writeTarFileDataFormat(TarFileDataFormat def) throws IOException {
        doWriteTarFileDataFormat("tarFile", def);
    }
    public void writeThriftDataFormat(ThriftDataFormat def) throws IOException {
        doWriteThriftDataFormat("thrift", def);
    }
    public void writeTidyMarkupDataFormat(TidyMarkupDataFormat def) throws IOException {
        doWriteTidyMarkupDataFormat("tidyMarkup", def);
    }
    public void writeUniVocityCsvDataFormat(UniVocityCsvDataFormat def) throws IOException {
        doWriteUniVocityCsvDataFormat("univocityCsv", def);
    }
    public void writeUniVocityFixedDataFormat(UniVocityFixedDataFormat def) throws IOException {
        doWriteUniVocityFixedDataFormat("univocityFixed", def);
    }
    public void writeUniVocityHeader(UniVocityHeader def) throws IOException {
        doWriteUniVocityHeader("univocityHeader", def);
    }
    public void writeUniVocityTsvDataFormat(UniVocityTsvDataFormat def) throws IOException {
        doWriteUniVocityTsvDataFormat("univocityTsv", def);
    }
    public void writeXMLSecurityDataFormat(XMLSecurityDataFormat def) throws IOException {
        doWriteXMLSecurityDataFormat("xmlSecurity", def);
    }
    public void writeYAMLDataFormat(YAMLDataFormat def) throws IOException {
        doWriteYAMLDataFormat("yaml", def);
    }
    public void writeYAMLTypeFilterDefinition(YAMLTypeFilterDefinition def) throws IOException {
        doWriteYAMLTypeFilterDefinition("typeFilter", def);
    }
    public void writeZipDeflaterDataFormat(ZipDeflaterDataFormat def) throws IOException {
        doWriteZipDeflaterDataFormat("zipDeflater", def);
    }
    public void writeZipFileDataFormat(ZipFileDataFormat def) throws IOException {
        doWriteZipFileDataFormat("zipFile", def);
    }
    public void writeDeadLetterChannelDefinition(DeadLetterChannelDefinition def) throws IOException {
        doWriteDeadLetterChannelDefinition("deadLetterChannel", def);
    }
    public void writeDefaultErrorHandlerDefinition(DefaultErrorHandlerDefinition def) throws IOException {
        doWriteDefaultErrorHandlerDefinition("defaultErrorHandler", def);
    }
    public void writeJtaTransactionErrorHandlerDefinition(JtaTransactionErrorHandlerDefinition def) throws IOException {
        doWriteJtaTransactionErrorHandlerDefinition("jtaTransactionErrorHandler", def);
    }
    public void writeNoErrorHandlerDefinition(NoErrorHandlerDefinition def) throws IOException {
        doWriteNoErrorHandlerDefinition("noErrorHandler", def);
    }
    public void writeRefErrorHandlerDefinition(RefErrorHandlerDefinition def) throws IOException {
        doWriteRefErrorHandlerDefinition("refErrorHandler", def);
    }
    public void writeSpringTransactionErrorHandlerDefinition(SpringTransactionErrorHandlerDefinition def) throws IOException {
        doWriteSpringTransactionErrorHandlerDefinition("springTransactionErrorHandler", def);
    }
    public void writeCSimpleExpression(CSimpleExpression def) throws IOException {
        doWriteCSimpleExpression("csimple", def);
    }
    public void writeConstantExpression(ConstantExpression def) throws IOException {
        doWriteConstantExpression("constant", def);
    }
    public void writeDatasonnetExpression(DatasonnetExpression def) throws IOException {
        doWriteDatasonnetExpression("datasonnet", def);
    }
    public void writeExchangePropertyExpression(ExchangePropertyExpression def) throws IOException {
        doWriteExchangePropertyExpression("exchangeProperty", def);
    }
    public void writeExpressionDefinition(ExpressionDefinition def) throws IOException {
        doWriteExpressionDefinition("##default", def);
    }
    public void writeGroovyExpression(GroovyExpression def) throws IOException {
        doWriteGroovyExpression("groovy", def);
    }
    public void writeHeaderExpression(HeaderExpression def) throws IOException {
        doWriteHeaderExpression("header", def);
    }
    public void writeHl7TerserExpression(Hl7TerserExpression def) throws IOException {
        doWriteHl7TerserExpression("hl7terser", def);
    }
    public void writeJavaExpression(JavaExpression def) throws IOException {
        doWriteJavaExpression("java", def);
    }
    public void writeJavaScriptExpression(JavaScriptExpression def) throws IOException {
        doWriteJavaScriptExpression("js", def);
    }
    public void writeJoorExpression(JoorExpression def) throws IOException {
        doWriteJoorExpression("joor", def);
    }
    public void writeJqExpression(JqExpression def) throws IOException {
        doWriteJqExpression("jq", def);
    }
    public void writeJsonPathExpression(JsonPathExpression def) throws IOException {
        doWriteJsonPathExpression("jsonpath", def);
    }
    public void writeLanguageExpression(LanguageExpression def) throws IOException {
        doWriteLanguageExpression("language", def);
    }
    public void writeMethodCallExpression(MethodCallExpression def) throws IOException {
        doWriteMethodCallExpression("method", def);
    }
    public void writeMvelExpression(MvelExpression def) throws IOException {
        doWriteMvelExpression("mvel", def);
    }
    public void writeOgnlExpression(OgnlExpression def) throws IOException {
        doWriteOgnlExpression("ognl", def);
    }
    public void writePythonExpression(PythonExpression def) throws IOException {
        doWritePythonExpression("python", def);
    }
    public void writeRefExpression(RefExpression def) throws IOException {
        doWriteRefExpression("ref", def);
    }
    public void writeSimpleExpression(SimpleExpression def) throws IOException {
        doWriteSimpleExpression("simple", def);
    }
    public void writeSpELExpression(SpELExpression def) throws IOException {
        doWriteSpELExpression("spel", def);
    }
    public void writeTokenizerExpression(TokenizerExpression def) throws IOException {
        doWriteTokenizerExpression("tokenize", def);
    }
    public void writeVariableExpression(VariableExpression def) throws IOException {
        doWriteVariableExpression("variable", def);
    }
    public void writeWasmExpression(WasmExpression def) throws IOException {
        doWriteWasmExpression("wasm", def);
    }
    public void writeXMLTokenizerExpression(XMLTokenizerExpression def) throws IOException {
        doWriteXMLTokenizerExpression("xtokenize", def);
    }
    public void writeXPathExpression(XPathExpression def) throws IOException {
        doWriteXPathExpression("xpath", def);
    }
    public void writeXQueryExpression(XQueryExpression def) throws IOException {
        doWriteXQueryExpression("xquery", def);
    }
    public void writeCustomLoadBalancerDefinition(CustomLoadBalancerDefinition def) throws IOException {
        doWriteCustomLoadBalancerDefinition("customLoadBalancer", def);
    }
    public void writeFailoverLoadBalancerDefinition(FailoverLoadBalancerDefinition def) throws IOException {
        doWriteFailoverLoadBalancerDefinition("failoverLoadBalancer", def);
    }
    public void writeRandomLoadBalancerDefinition(RandomLoadBalancerDefinition def) throws IOException {
        doWriteRandomLoadBalancerDefinition("randomLoadBalancer", def);
    }
    public void writeRoundRobinLoadBalancerDefinition(RoundRobinLoadBalancerDefinition def) throws IOException {
        doWriteRoundRobinLoadBalancerDefinition("roundRobinLoadBalancer", def);
    }
    public void writeStickyLoadBalancerDefinition(StickyLoadBalancerDefinition def) throws IOException {
        doWriteStickyLoadBalancerDefinition("stickyLoadBalancer", def);
    }
    public void writeTopicLoadBalancerDefinition(TopicLoadBalancerDefinition def) throws IOException {
        doWriteTopicLoadBalancerDefinition("topicLoadBalancer", def);
    }
    public void writeWeightedLoadBalancerDefinition(WeightedLoadBalancerDefinition def) throws IOException {
        doWriteWeightedLoadBalancerDefinition("weightedLoadBalancer", def);
    }
    public void writeApiKeyDefinition(ApiKeyDefinition def) throws IOException {
        doWriteApiKeyDefinition("apiKey", def);
    }
    public void writeBasicAuthDefinition(BasicAuthDefinition def) throws IOException {
        doWriteBasicAuthDefinition("basicAuth", def);
    }
    public void writeBearerTokenDefinition(BearerTokenDefinition def) throws IOException {
        doWriteBearerTokenDefinition("bearerToken", def);
    }
    public void writeDeleteDefinition(DeleteDefinition def) throws IOException {
        doWriteDeleteDefinition("delete", def);
    }
    public void writeGetDefinition(GetDefinition def) throws IOException {
        doWriteGetDefinition("get", def);
    }
    public void writeHeadDefinition(HeadDefinition def) throws IOException {
        doWriteHeadDefinition("head", def);
    }
    public void writeMutualTLSDefinition(MutualTLSDefinition def) throws IOException {
        doWriteMutualTLSDefinition("mutualTLS", def);
    }
    public void writeOAuth2Definition(OAuth2Definition def) throws IOException {
        doWriteOAuth2Definition("oauth2", def);
    }
    public void writeOpenApiDefinition(OpenApiDefinition def) throws IOException {
        doWriteOpenApiDefinition("openApi", def);
    }
    public void writeOpenIdConnectDefinition(OpenIdConnectDefinition def) throws IOException {
        doWriteOpenIdConnectDefinition("openIdConnect", def);
    }
    public void writeParamDefinition(ParamDefinition def) throws IOException {
        doWriteParamDefinition("param", def);
    }
    public void writePatchDefinition(PatchDefinition def) throws IOException {
        doWritePatchDefinition("patch", def);
    }
    public void writePostDefinition(PostDefinition def) throws IOException {
        doWritePostDefinition("post", def);
    }
    public void writePutDefinition(PutDefinition def) throws IOException {
        doWritePutDefinition("put", def);
    }
    public void writeResponseHeaderDefinition(ResponseHeaderDefinition def) throws IOException {
        doWriteResponseHeaderDefinition("responseHeader", def);
    }
    public void writeResponseMessageDefinition(ResponseMessageDefinition def) throws IOException {
        doWriteResponseMessageDefinition("responseMessage", def);
    }
    public void writeRestBindingDefinition(RestBindingDefinition def) throws IOException {
        doWriteRestBindingDefinition("restBinding", def);
    }
    public void writeRestConfigurationDefinition(RestConfigurationDefinition def) throws IOException {
        doWriteRestConfigurationDefinition("restConfiguration", def);
    }
    public void writeRestDefinition(RestDefinition def) throws IOException {
        doWriteRestDefinition("rest", def);
    }
    public void writeRestPropertyDefinition(RestPropertyDefinition def) throws IOException {
        doWriteRestPropertyDefinition("restProperty", def);
    }
    public void writeRestSecuritiesDefinition(RestSecuritiesDefinition def) throws IOException {
        doWriteRestSecuritiesDefinition("securityDefinitions", def);
    }
    public void writeRestsDefinition(RestsDefinition def) throws IOException {
        doWriteRestsDefinition("rests", def);
    }
    public void writeSecurityDefinition(SecurityDefinition def) throws IOException {
        doWriteSecurityDefinition("security", def);
    }
    public void writeLangChain4jCharacterTokenizerDefinition(LangChain4jCharacterTokenizerDefinition def) throws IOException {
        doWriteLangChain4jCharacterTokenizerDefinition("langChain4jCharacterTokenizer", def);
    }
    public void writeLangChain4jLineTokenizerDefinition(LangChain4jLineTokenizerDefinition def) throws IOException {
        doWriteLangChain4jLineTokenizerDefinition("langChain4jLineTokenizer", def);
    }
    public void writeLangChain4jParagraphTokenizerDefinition(LangChain4jParagraphTokenizerDefinition def) throws IOException {
        doWriteLangChain4jParagraphTokenizerDefinition("langChain4jParagraphTokenizer", def);
    }
    public void writeLangChain4jSentenceTokenizerDefinition(LangChain4jSentenceTokenizerDefinition def) throws IOException {
        doWriteLangChain4jSentenceTokenizerDefinition("langChain4jSentenceTokenizer", def);
    }
    public void writeLangChain4jWordTokenizerDefinition(LangChain4jWordTokenizerDefinition def) throws IOException {
        doWriteLangChain4jWordTokenizerDefinition("langChain4jWordTokenizer", def);
    }
    public void writeCustomTransformerDefinition(CustomTransformerDefinition def) throws IOException {
        doWriteCustomTransformerDefinition("customTransformer", def);
    }
    public void writeDataFormatTransformerDefinition(DataFormatTransformerDefinition def) throws IOException {
        doWriteDataFormatTransformerDefinition("dataFormatTransformer", def);
    }
    public void writeEndpointTransformerDefinition(EndpointTransformerDefinition def) throws IOException {
        doWriteEndpointTransformerDefinition("endpointTransformer", def);
    }
    public void writeLoadTransformerDefinition(LoadTransformerDefinition def) throws IOException {
        doWriteLoadTransformerDefinition("loadTransformer", def);
    }
    public void writeTransformersDefinition(TransformersDefinition def) throws IOException {
        doWriteTransformersDefinition("transformers", def);
    }
    public void writeCustomValidatorDefinition(CustomValidatorDefinition def) throws IOException {
        doWriteCustomValidatorDefinition("customValidator", def);
    }
    public void writeEndpointValidatorDefinition(EndpointValidatorDefinition def) throws IOException {
        doWriteEndpointValidatorDefinition("endpointValidator", def);
    }
    public void writePredicateValidatorDefinition(PredicateValidatorDefinition def) throws IOException {
        doWritePredicateValidatorDefinition("predicateValidator", def);
    }
    public void writeValidatorsDefinition(ValidatorsDefinition def) throws IOException {
        doWriteValidatorsDefinition("validators", def);
    }

    public void writeOptionalIdentifiedDefinitionRef(OptionalIdentifiedDefinition def) throws IOException {
        doWriteOptionalIdentifiedDefinitionRef(null, def);
    }

    protected void doWriteAggregateDefinition(String name, AggregateDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("aggregationStrategy", def.getAggregationStrategy(), null);
        doWriteAttribute("aggregationRepository", def.getAggregationRepository(), null);
        doWriteAttribute("executorService", def.getExecutorService(), null);
        doWriteAttribute("closeCorrelationKeyOnCompletion", def.getCloseCorrelationKeyOnCompletion(), null);
        doWriteAttribute("discardOnAggregationFailure", def.getDiscardOnAggregationFailure(), null);
        doWriteAttribute("eagerCheckCompletion", def.getEagerCheckCompletion(), null);
        doWriteAttribute("timeoutCheckerExecutorService", def.getTimeoutCheckerExecutorService(), null);
        doWriteAttribute("completionOnNewCorrelationGroup", def.getCompletionOnNewCorrelationGroup(), null);
        doWriteAttribute("completionInterval", def.getCompletionInterval(), null);
        doWriteAttribute("parallelProcessing", def.getParallelProcessing(), null);
        doWriteAttribute("forceCompletionOnStop", def.getForceCompletionOnStop(), null);
        doWriteAttribute("aggregationStrategyMethodAllowNull", def.getAggregationStrategyMethodAllowNull(), null);
        doWriteAttribute("completionFromBatchConsumer", def.getCompletionFromBatchConsumer(), null);
        doWriteAttribute("completeAllOnStop", def.getCompleteAllOnStop(), null);
        doWriteAttribute("completionSize", def.getCompletionSize(), null);
        doWriteAttribute("aggregationStrategyMethodName", def.getAggregationStrategyMethodName(), null);
        doWriteAttribute("aggregateController", def.getAggregateController(), null);
        doWriteAttribute("completionTimeout", def.getCompletionTimeout(), null);
        doWriteAttribute("ignoreInvalidCorrelationKeys", def.getIgnoreInvalidCorrelationKeys(), null);
        doWriteAttribute("discardOnCompletionTimeout", def.getDiscardOnCompletionTimeout(), null);
        doWriteAttribute("completionTimeoutCheckerInterval", def.getCompletionTimeoutCheckerInterval(), "1000");
        doWriteAttribute("optimisticLocking", def.getOptimisticLocking(), null);
        doWriteElement("optimisticLockRetryPolicy", def.getOptimisticLockRetryPolicyDefinition(), this::doWriteOptimisticLockRetryPolicyDefinition);
        doWriteElement("correlationExpression", def.getCorrelationExpression(), this::doWriteExpressionSubElementDefinition);
        doWriteElement("completionPredicate", def.getCompletionPredicate(), this::doWriteExpressionSubElementDefinition);
        doWriteElement("completionSizeExpression", def.getCompletionSizeExpression(), this::doWriteExpressionSubElementDefinition);
        doWriteElement("completionTimeoutExpression", def.getCompletionTimeoutExpression(), this::doWriteExpressionSubElementDefinition);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteBasicExpressionNodeElements(BasicExpressionNode<?> def) throws IOException {
        doWriteElement(null, def.getExpression(), this::doWriteExpressionDefinitionRef);
    }
    protected void doWriteBasicExpressionNode(String name, BasicExpressionNode<?> def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteBasicExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteBasicOutputExpressionNodeElements(BasicOutputExpressionNode def) throws IOException {
        doWriteBasicExpressionNodeElements(def);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
    }
    protected void doWriteBasicOutputExpressionNode(String name, BasicOutputExpressionNode def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteBasicOutputExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteBeanDefinition(String name, BeanDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("ref", def.getRef(), null);
        doWriteAttribute("method", def.getMethod(), null);
        doWriteAttribute("scope", def.getScope(), "Singleton");
        doWriteAttribute("beanType", def.getBeanType(), null);
        endElement(name);
    }
    protected void doWriteBeanFactoryDefinition(String name, BeanFactoryDefinition<?> def) throws IOException {
        startElement(name);
        doWriteAttribute("factoryMethod", def.getFactoryMethod(), null);
        doWriteAttribute("scriptLanguage", def.getScriptLanguage(), null);
        doWriteAttribute("builderClass", def.getBuilderClass(), null);
        doWriteAttribute("type", def.getType(), null);
        doWriteAttribute("factoryBean", def.getFactoryBean(), null);
        doWriteAttribute("scriptPropertyPlaceholders", def.getScriptPropertyPlaceholders(), "true");
        doWriteAttribute("initMethod", def.getInitMethod(), null);
        doWriteAttribute("name", def.getName(), null);
        doWriteAttribute("builderMethod", def.getBuilderMethod(), "build");
        doWriteAttribute("destroyMethod", def.getDestroyMethod(), null);
        doWriteElement("script", def.getScript(), this::doWriteString);
        doWriteElement("constructors", new BeanConstructorsAdapter().marshal(def.getConstructors()), this::doWriteBeanConstructorsDefinition);
        doWriteElement("properties", new BeanPropertiesAdapter().marshal(def.getProperties()), this::doWriteBeanPropertiesDefinition);
        endElement(name);
    }
    protected void doWriteCatchDefinition(String name, CatchDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteElement("onWhen", def.getOnWhen(), this::doWriteOnWhenDefinition);
        doWriteList(null, "exception", def.getExceptions(), this::doWriteString);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteChoiceDefinition(String name, ChoiceDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("precondition", def.getPrecondition(), "false");
        doWriteList(null, null, def.getWhenClauses(), this::doWriteWhenDefinitionRef);
        doWriteElement("otherwise", def.getOtherwise(), this::doWriteOtherwiseDefinition);
        endElement(name);
    }
    protected void doWriteCircuitBreakerDefinition(String name, CircuitBreakerDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("inheritErrorHandler", toString(def.getInheritErrorHandler()), "false");
        doWriteAttribute("configuration", def.getConfiguration(), null);
        doWriteElement("resilience4jConfiguration", def.getResilience4jConfiguration(), this::doWriteResilience4jConfigurationDefinition);
        doWriteElement("onFallback", def.getOnFallback(), this::doWriteOnFallbackDefinition);
        doWriteElement("faultToleranceConfiguration", def.getFaultToleranceConfiguration(), this::doWriteFaultToleranceConfigurationDefinition);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteClaimCheckDefinition(String name, ClaimCheckDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("filter", def.getFilter(), null);
        doWriteAttribute("aggregationStrategy", def.getAggregationStrategy(), null);
        doWriteAttribute("aggregationStrategyMethodName", def.getAggregationStrategyMethodName(), null);
        doWriteAttribute("operation", def.getOperation(), null);
        doWriteAttribute("key", def.getKey(), null);
        endElement(name);
    }
    protected void doWriteContextScanDefinition(String name, ContextScanDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("includeNonSingletons", def.getIncludeNonSingletons(), null);
        doWriteList(null, "excludes", def.getExcludes(), this::doWriteString);
        doWriteList(null, "includes", def.getIncludes(), this::doWriteString);
        endElement(name);
    }
    protected void doWriteConvertBodyDefinition(String name, ConvertBodyDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("charset", def.getCharset(), null);
        doWriteAttribute("type", def.getType(), null);
        doWriteAttribute("mandatory", def.getMandatory(), "true");
        endElement(name);
    }
    protected void doWriteConvertHeaderDefinition(String name, ConvertHeaderDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("charset", def.getCharset(), null);
        doWriteAttribute("toName", def.getToName(), null);
        doWriteAttribute("name", def.getName(), null);
        doWriteAttribute("type", def.getType(), null);
        doWriteAttribute("mandatory", def.getMandatory(), "true");
        endElement(name);
    }
    protected void doWriteConvertVariableDefinition(String name, ConvertVariableDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("charset", def.getCharset(), null);
        doWriteAttribute("toName", def.getToName(), null);
        doWriteAttribute("name", def.getName(), null);
        doWriteAttribute("type", def.getType(), null);
        doWriteAttribute("mandatory", def.getMandatory(), "true");
        endElement(name);
    }
    protected void doWriteDataFormatDefinition(String name, DataFormatDefinition def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        endElement(name);
    }
    protected void doWriteDelayDefinition(String name, DelayDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("executorService", def.getExecutorService(), null);
        doWriteAttribute("callerRunsWhenRejected", def.getCallerRunsWhenRejected(), "true");
        doWriteAttribute("asyncDelayed", def.getAsyncDelayed(), "true");
        doWriteExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteDynamicRouterDefinition(String name, DynamicRouterDefinition<?> def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("uriDelimiter", def.getUriDelimiter(), ",");
        doWriteAttribute("ignoreInvalidEndpoints", def.getIgnoreInvalidEndpoints(), null);
        doWriteAttribute("cacheSize", def.getCacheSize(), null);
        doWriteExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteEnrichDefinition(String name, EnrichDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("variableReceive", def.getVariableReceive(), null);
        doWriteAttribute("variableSend", def.getVariableSend(), null);
        doWriteAttribute("cacheSize", def.getCacheSize(), null);
        doWriteAttribute("aggregationStrategy", def.getAggregationStrategy(), null);
        doWriteAttribute("ignoreInvalidEndpoint", def.getIgnoreInvalidEndpoint(), null);
        doWriteAttribute("autoStartComponents", def.getAutoStartComponents(), "true");
        doWriteAttribute("allowOptimisedComponents", def.getAllowOptimisedComponents(), "true");
        doWriteAttribute("aggregateOnException", def.getAggregateOnException(), null);
        doWriteAttribute("aggregationStrategyMethodName", def.getAggregationStrategyMethodName(), null);
        doWriteAttribute("shareUnitOfWork", def.getShareUnitOfWork(), null);
        doWriteAttribute("aggregationStrategyMethodAllowNull", def.getAggregationStrategyMethodAllowNull(), null);
        doWriteExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteErrorHandlerDefinition(String name, ErrorHandlerDefinition def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteElement(null, def.getErrorHandlerType(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "DeadLetterChannelDefinition" -> doWriteDeadLetterChannelDefinition("deadLetterChannel", (DeadLetterChannelDefinition) v);
                case "DefaultErrorHandlerDefinition" -> doWriteDefaultErrorHandlerDefinition("defaultErrorHandler", (DefaultErrorHandlerDefinition) v);
                case "NoErrorHandlerDefinition" -> doWriteNoErrorHandlerDefinition("noErrorHandler", (NoErrorHandlerDefinition) v);
                case "RefErrorHandlerDefinition" -> doWriteRefErrorHandlerDefinition("refErrorHandler", (RefErrorHandlerDefinition) v);
                case "JtaTransactionErrorHandlerDefinition" -> doWriteJtaTransactionErrorHandlerDefinition("jtaTransactionErrorHandler", (JtaTransactionErrorHandlerDefinition) v);
                case "SpringTransactionErrorHandlerDefinition" -> doWriteSpringTransactionErrorHandlerDefinition("springTransactionErrorHandler", (SpringTransactionErrorHandlerDefinition) v);
            }
        });
        endElement(name);
    }
    protected void doWriteExpressionNodeElements(ExpressionNode def) throws IOException {
        doWriteElement(null, def.getExpression(), this::doWriteExpressionDefinitionRef);
    }
    protected void doWriteExpressionNode(String name, ExpressionNode def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteExpressionSubElementDefinition(String name, ExpressionSubElementDefinition def) throws IOException {
        startExpressionElement(name);
        doWriteElement(null, def.getExpressionType(), this::doWriteExpressionDefinitionRef);
        endExpressionElement(name);
    }
    protected void doWriteFaultToleranceConfigurationCommonAttributes(FaultToleranceConfigurationCommon def) throws IOException {
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("delay", def.getDelay(), "5000");
        doWriteAttribute("bulkheadWaitingTaskQueue", def.getBulkheadWaitingTaskQueue(), "10");
        doWriteAttribute("typedGuard", def.getTypedGuard(), null);
        doWriteAttribute("failureRatio", def.getFailureRatio(), "50");
        doWriteAttribute("timeoutDuration", def.getTimeoutDuration(), "1000");
        doWriteAttribute("timeoutEnabled", def.getTimeoutEnabled(), "false");
        doWriteAttribute("timeoutPoolSize", def.getTimeoutPoolSize(), "10");
        doWriteAttribute("successThreshold", def.getSuccessThreshold(), "1");
        doWriteAttribute("requestVolumeThreshold", def.getRequestVolumeThreshold(), "20");
        doWriteAttribute("bulkheadMaxConcurrentCalls", def.getBulkheadMaxConcurrentCalls(), "10");
        doWriteAttribute("threadOffloadExecutorService", def.getThreadOffloadExecutorService(), null);
        doWriteAttribute("bulkheadEnabled", def.getBulkheadEnabled(), "false");
    }
    protected void doWriteFaultToleranceConfigurationCommon(String name, FaultToleranceConfigurationCommon def) throws IOException {
        startElement(name);
        doWriteFaultToleranceConfigurationCommonAttributes(def);
        endElement(name);
    }
    protected void doWriteFaultToleranceConfigurationDefinition(String name, FaultToleranceConfigurationDefinition def) throws IOException {
        startElement(name);
        doWriteFaultToleranceConfigurationCommonAttributes(def);
        endElement(name);
    }
    protected void doWriteFilterDefinition(String name, FilterDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("statusPropertyName", def.getStatusPropertyName(), null);
        doWriteOutputExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteFinallyDefinition(String name, FinallyDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteFromDefinition(String name, FromDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteAttribute("variableReceive", def.getVariableReceive(), null);
        doWriteAttribute("uri", def.getUri(), null);
        endElement(name);
    }
    protected void doWriteGlobalOptionDefinition(String name, GlobalOptionDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("value", def.getValue(), null);
        doWriteAttribute("key", def.getKey(), null);
        endElement(name);
    }
    protected void doWriteGlobalOptionsDefinition(String name, GlobalOptionsDefinition def) throws IOException {
        startElement(name);
        doWriteList(null, "globalOption", def.getGlobalOptions(), this::doWriteGlobalOptionDefinition);
        endElement(name);
    }
    protected void doWriteIdempotentConsumerDefinition(String name, IdempotentConsumerDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("completionEager", def.getCompletionEager(), "false");
        doWriteAttribute("skipDuplicate", def.getSkipDuplicate(), "true");
        doWriteAttribute("eager", def.getEager(), "true");
        doWriteAttribute("idempotentRepository", def.getIdempotentRepository(), null);
        doWriteAttribute("removeOnFailure", def.getRemoveOnFailure(), "true");
        doWriteOutputExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteIdentifiedTypeAttributes(IdentifiedType def) throws IOException {
        doWriteAttribute("id", def.getId(), null);
    }
    protected void doWriteIdentifiedType(String name, IdentifiedType def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        endElement(name);
    }
    protected void doWriteInputTypeDefinition(String name, InputTypeDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteAttribute("urn", def.getUrn(), null);
        doWriteAttribute("validate", def.getValidate(), "false");
        endElement(name);
    }
    protected void doWriteInterceptDefinitionElements(InterceptDefinition def) throws IOException {
        doWriteElement("onWhen", def.getOnWhen(), this::doWriteOnWhenDefinition);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
    }
    protected void doWriteInterceptDefinition(String name, InterceptDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteInterceptDefinitionElements(def);
        endElement(name);
    }
    protected void doWriteInterceptFromDefinition(String name, InterceptFromDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("uri", def.getUri(), null);
        doWriteInterceptDefinitionElements(def);
        endElement(name);
    }
    protected void doWriteInterceptSendToEndpointDefinition(String name, InterceptSendToEndpointDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("afterUri", def.getAfterUri(), null);
        doWriteAttribute("uri", def.getUri(), null);
        doWriteAttribute("skipSendToOriginalEndpoint", def.getSkipSendToOriginalEndpoint(), null);
        doWriteElement("onWhen", def.getOnWhen(), this::doWriteOnWhenDefinition);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteKameletDefinition(String name, KameletDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("name", def.getName(), null);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteLoadBalanceDefinition(String name, LoadBalanceDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteElement(null, def.getLoadBalancerType(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "CustomLoadBalancerDefinition" -> doWriteCustomLoadBalancerDefinition("customLoadBalancer", (CustomLoadBalancerDefinition) v);
                case "FailoverLoadBalancerDefinition" -> doWriteFailoverLoadBalancerDefinition("failoverLoadBalancer", (FailoverLoadBalancerDefinition) v);
                case "RandomLoadBalancerDefinition" -> doWriteRandomLoadBalancerDefinition("randomLoadBalancer", (RandomLoadBalancerDefinition) v);
                case "RoundRobinLoadBalancerDefinition" -> doWriteRoundRobinLoadBalancerDefinition("roundRobinLoadBalancer", (RoundRobinLoadBalancerDefinition) v);
                case "StickyLoadBalancerDefinition" -> doWriteStickyLoadBalancerDefinition("stickyLoadBalancer", (StickyLoadBalancerDefinition) v);
                case "TopicLoadBalancerDefinition" -> doWriteTopicLoadBalancerDefinition("topicLoadBalancer", (TopicLoadBalancerDefinition) v);
                case "WeightedLoadBalancerDefinition" -> doWriteWeightedLoadBalancerDefinition("weightedLoadBalancer", (WeightedLoadBalancerDefinition) v);
            }
        });
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteLoadBalancerDefinition(String name, LoadBalancerDefinition def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        endElement(name);
    }
    protected void doWriteLogDefinition(String name, LogDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("logName", def.getLogName(), null);
        doWriteAttribute("logLanguage", def.getLogLanguage(), null);
        doWriteAttribute("marker", def.getMarker(), null);
        doWriteAttribute("logger", def.getLogger(), null);
        doWriteAttribute("message", def.getMessage(), null);
        doWriteAttribute("loggingLevel", def.getLoggingLevel(), "INFO");
        endElement(name);
    }
    protected void doWriteLoopDefinition(String name, LoopDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("onPrepare", def.getOnPrepare(), null);
        doWriteAttribute("doWhile", def.getDoWhile(), null);
        doWriteAttribute("breakOnShutdown", def.getBreakOnShutdown(), null);
        doWriteAttribute("copy", def.getCopy(), null);
        doWriteOutputExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteMarshalDefinition(String name, MarshalDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("variableReceive", def.getVariableReceive(), null);
        doWriteAttribute("variableSend", def.getVariableSend(), null);
        doWriteElement(null, def.getDataFormatType(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "ASN1DataFormat" -> doWriteASN1DataFormat("asn1", (ASN1DataFormat) v);
                case "AvroDataFormat" -> doWriteAvroDataFormat("avro", (AvroDataFormat) v);
                case "BarcodeDataFormat" -> doWriteBarcodeDataFormat("barcode", (BarcodeDataFormat) v);
                case "Base64DataFormat" -> doWriteBase64DataFormat("base64", (Base64DataFormat) v);
                case "BeanioDataFormat" -> doWriteBeanioDataFormat("beanio", (BeanioDataFormat) v);
                case "BindyDataFormat" -> doWriteBindyDataFormat("bindy", (BindyDataFormat) v);
                case "CBORDataFormat" -> doWriteCBORDataFormat("cbor", (CBORDataFormat) v);
                case "CryptoDataFormat" -> doWriteCryptoDataFormat("crypto", (CryptoDataFormat) v);
                case "CsvDataFormat" -> doWriteCsvDataFormat("csv", (CsvDataFormat) v);
                case "CustomDataFormat" -> doWriteCustomDataFormat("custom", (CustomDataFormat) v);
                case "DfdlDataFormat" -> doWriteDfdlDataFormat("dfdl", (DfdlDataFormat) v);
                case "FhirJsonDataFormat" -> doWriteFhirJsonDataFormat("fhirJson", (FhirJsonDataFormat) v);
                case "FhirXmlDataFormat" -> doWriteFhirXmlDataFormat("fhirXml", (FhirXmlDataFormat) v);
                case "FlatpackDataFormat" -> doWriteFlatpackDataFormat("flatpack", (FlatpackDataFormat) v);
                case "ForyDataFormat" -> doWriteForyDataFormat("fory", (ForyDataFormat) v);
                case "GrokDataFormat" -> doWriteGrokDataFormat("grok", (GrokDataFormat) v);
                case "GzipDeflaterDataFormat" -> doWriteGzipDeflaterDataFormat("gzipDeflater", (GzipDeflaterDataFormat) v);
                case "HL7DataFormat" -> doWriteHL7DataFormat("hl7", (HL7DataFormat) v);
                case "IcalDataFormat" -> doWriteIcalDataFormat("ical", (IcalDataFormat) v);
                case "Iso8583DataFormat" -> doWriteIso8583DataFormat("iso8583", (Iso8583DataFormat) v);
                case "JacksonXMLDataFormat" -> doWriteJacksonXMLDataFormat("jacksonXml", (JacksonXMLDataFormat) v);
                case "JaxbDataFormat" -> doWriteJaxbDataFormat("jaxb", (JaxbDataFormat) v);
                case "JsonDataFormat" -> doWriteJsonDataFormat("json", (JsonDataFormat) v);
                case "JsonApiDataFormat" -> doWriteJsonApiDataFormat("jsonApi", (JsonApiDataFormat) v);
                case "LZFDataFormat" -> doWriteLZFDataFormat("lzf", (LZFDataFormat) v);
                case "MimeMultipartDataFormat" -> doWriteMimeMultipartDataFormat("mimeMultipart", (MimeMultipartDataFormat) v);
                case "ParquetAvroDataFormat" -> doWriteParquetAvroDataFormat("parquetAvro", (ParquetAvroDataFormat) v);
                case "ProtobufDataFormat" -> doWriteProtobufDataFormat("protobuf", (ProtobufDataFormat) v);
                case "RssDataFormat" -> doWriteRssDataFormat("rss", (RssDataFormat) v);
                case "SmooksDataFormat" -> doWriteSmooksDataFormat("smooks", (SmooksDataFormat) v);
                case "SoapDataFormat" -> doWriteSoapDataFormat("soap", (SoapDataFormat) v);
                case "SwiftMtDataFormat" -> doWriteSwiftMtDataFormat("swiftMt", (SwiftMtDataFormat) v);
                case "SwiftMxDataFormat" -> doWriteSwiftMxDataFormat("swiftMx", (SwiftMxDataFormat) v);
                case "SyslogDataFormat" -> doWriteSyslogDataFormat("syslog", (SyslogDataFormat) v);
                case "TarFileDataFormat" -> doWriteTarFileDataFormat("tarFile", (TarFileDataFormat) v);
                case "ThriftDataFormat" -> doWriteThriftDataFormat("thrift", (ThriftDataFormat) v);
                case "TidyMarkupDataFormat" -> doWriteTidyMarkupDataFormat("tidyMarkup", (TidyMarkupDataFormat) v);
                case "UniVocityCsvDataFormat" -> doWriteUniVocityCsvDataFormat("univocityCsv", (UniVocityCsvDataFormat) v);
                case "UniVocityFixedDataFormat" -> doWriteUniVocityFixedDataFormat("univocityFixed", (UniVocityFixedDataFormat) v);
                case "UniVocityTsvDataFormat" -> doWriteUniVocityTsvDataFormat("univocityTsv", (UniVocityTsvDataFormat) v);
                case "XMLSecurityDataFormat" -> doWriteXMLSecurityDataFormat("xmlSecurity", (XMLSecurityDataFormat) v);
                case "PGPDataFormat" -> doWritePGPDataFormat("pgp", (PGPDataFormat) v);
                case "YAMLDataFormat" -> doWriteYAMLDataFormat("yaml", (YAMLDataFormat) v);
                case "ZipDeflaterDataFormat" -> doWriteZipDeflaterDataFormat("zipDeflater", (ZipDeflaterDataFormat) v);
                case "ZipFileDataFormat" -> doWriteZipFileDataFormat("zipFile", (ZipFileDataFormat) v);
            }
        });
        endElement(name);
    }
    protected void doWriteMulticastDefinition(String name, MulticastDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("aggregationStrategy", def.getAggregationStrategy(), null);
        doWriteAttribute("onPrepare", def.getOnPrepare(), null);
        doWriteAttribute("executorService", def.getExecutorService(), null);
        doWriteAttribute("synchronous", def.getSynchronous(), null);
        doWriteAttribute("aggregationStrategyMethodName", def.getAggregationStrategyMethodName(), null);
        doWriteAttribute("timeout", def.getTimeout(), "0");
        doWriteAttribute("streaming", def.getStreaming(), null);
        doWriteAttribute("stopOnException", def.getStopOnException(), null);
        doWriteAttribute("parallelProcessing", def.getParallelProcessing(), null);
        doWriteAttribute("parallelAggregate", def.getParallelAggregate(), null);
        doWriteAttribute("shareUnitOfWork", def.getShareUnitOfWork(), null);
        doWriteAttribute("aggregationStrategyMethodAllowNull", def.getAggregationStrategyMethodAllowNull(), null);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteOnCompletionDefinition(String name, OnCompletionDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("parallelProcessing", def.getParallelProcessing(), null);
        doWriteAttribute("useOriginalMessage", def.getUseOriginalMessage(), null);
        doWriteAttribute("mode", def.getMode(), "AfterConsumer");
        doWriteAttribute("onCompleteOnly", def.getOnCompleteOnly(), null);
        doWriteAttribute("executorService", def.getExecutorService(), null);
        doWriteAttribute("onFailureOnly", def.getOnFailureOnly(), null);
        doWriteElement("onWhen", def.getOnWhen(), this::doWriteOnWhenDefinition);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteOnExceptionDefinition(String name, OnExceptionDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("useOriginalMessage", def.getUseOriginalMessage(), null);
        doWriteAttribute("onRedeliveryRef", def.getOnRedeliveryRef(), null);
        doWriteAttribute("useOriginalBody", def.getUseOriginalBody(), null);
        doWriteAttribute("onExceptionOccurredRef", def.getOnExceptionOccurredRef(), null);
        doWriteAttribute("redeliveryPolicyRef", def.getRedeliveryPolicyRef(), null);
        doWriteElement("continued", def.getContinued(), this::doWriteExpressionSubElementDefinition);
        doWriteList(null, "exception", def.getExceptions(), this::doWriteString);
        doWriteElement("retryWhile", def.getRetryWhile(), this::doWriteExpressionSubElementDefinition);
        doWriteElement("redeliveryPolicy", def.getRedeliveryPolicyType(), this::doWriteRedeliveryPolicyDefinition);
        doWriteElement("handled", def.getHandled(), this::doWriteExpressionSubElementDefinition);
        doWriteElement("onWhen", def.getOnWhen(), this::doWriteOnWhenDefinition);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteOnFallbackDefinition(String name, OnFallbackDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteAttribute("fallbackViaNetwork", def.getFallbackViaNetwork(), "false");
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteOnWhenDefinition(String name, OnWhenDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteElement(null, def.getExpression(), this::doWriteExpressionDefinitionRef);
        endElement(name);
    }
    protected void doWriteOptimisticLockRetryPolicyDefinition(String name, OptimisticLockRetryPolicyDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("retryDelay", def.getRetryDelay(), "50");
        doWriteAttribute("randomBackOff", def.getRandomBackOff(), null);
        doWriteAttribute("maximumRetries", def.getMaximumRetries(), null);
        doWriteAttribute("exponentialBackOff", def.getExponentialBackOff(), "true");
        doWriteAttribute("maximumRetryDelay", def.getMaximumRetryDelay(), "1000");
        endElement(name);
    }
    protected void doWriteOptionalIdentifiedDefinitionAttributes(OptionalIdentifiedDefinition<?> def) throws IOException {
        doWriteAttribute("description", def.getDescription(), null);
        doWriteAttribute("id", def.getId(), null);
        doWriteAttribute("customId", toString(def.getCustomId()), null);
    }
    protected void doWriteOptionalIdentifiedDefinition(String name, OptionalIdentifiedDefinition<?> def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWriteOtherwiseDefinition(String name, OtherwiseDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteAttribute("disabled", def.getDisabled(), null);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteOutputExpressionNodeElements(OutputExpressionNode def) throws IOException {
        doWriteExpressionNodeElements(def);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
    }
    protected void doWriteOutputExpressionNode(String name, OutputExpressionNode def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteOutputExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteOutputTypeDefinition(String name, OutputTypeDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteAttribute("urn", def.getUrn(), null);
        doWriteAttribute("validate", def.getValidate(), "false");
        endElement(name);
    }
    protected void doWritePackageScanDefinition(String name, PackageScanDefinition def) throws IOException {
        startElement(name);
        doWriteList(null, "excludes", def.getExcludes(), this::doWriteString);
        doWriteList(null, "includes", def.getIncludes(), this::doWriteString);
        doWriteList(null, "package", def.getPackages(), this::doWriteString);
        endElement(name);
    }
    protected void doWritePausableDefinition(String name, PausableDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("untilCheck", def.getUntilCheck(), null);
        doWriteAttribute("consumerListener", def.getConsumerListener(), null);
        endElement(name);
    }
    protected void doWritePipelineDefinition(String name, PipelineDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWritePolicyDefinition(String name, PolicyDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("ref", def.getRef(), null);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWritePollDefinition(String name, PollDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("variableReceive", def.getVariableReceive(), null);
        doWriteAttribute("uri", def.getUri(), null);
        doWriteAttribute("timeout", def.getTimeout(), "20000");
        endElement(name);
    }
    protected void doWritePollEnrichDefinition(String name, PollEnrichDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("variableReceive", def.getVariableReceive(), null);
        doWriteAttribute("cacheSize", def.getCacheSize(), null);
        doWriteAttribute("aggregationStrategy", def.getAggregationStrategy(), null);
        doWriteAttribute("ignoreInvalidEndpoint", def.getIgnoreInvalidEndpoint(), null);
        doWriteAttribute("autoStartComponents", def.getAutoStartComponents(), "true");
        doWriteAttribute("allowOptimisedComponents", def.getAllowOptimisedComponents(), "true");
        doWriteAttribute("aggregateOnException", def.getAggregateOnException(), null);
        doWriteAttribute("aggregationStrategyMethodName", def.getAggregationStrategyMethodName(), null);
        doWriteAttribute("timeout", def.getTimeout(), "-1");
        doWriteAttribute("aggregationStrategyMethodAllowNull", def.getAggregationStrategyMethodAllowNull(), null);
        doWriteExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteProcessDefinition(String name, ProcessDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("ref", def.getRef(), null);
        endElement(name);
    }
    protected void doWriteProcessorDefinitionAttributes(ProcessorDefinition<?> def) throws IOException {
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteAttribute("disabled", def.getDisabled(), null);
    }
    protected void doWriteProcessorDefinition(String name, ProcessorDefinition<?> def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWritePropertyDefinition(String name, PropertyDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("value", def.getValue(), null);
        doWriteAttribute("key", def.getKey(), null);
        endElement(name);
    }
    protected void doWritePropertyDefinitions(String name, PropertyDefinitions def) throws IOException {
        startElement(name);
        doWriteList(null, "property", def.getProperties(), this::doWritePropertyDefinition);
        endElement(name);
    }
    protected void doWritePropertyExpressionDefinition(String name, PropertyExpressionDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("key", def.getKey(), null);
        doWriteElement(null, def.getExpression(), this::doWriteExpressionDefinitionRef);
        endElement(name);
    }
    protected void doWriteRecipientListDefinition(String name, RecipientListDefinition<?> def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("cacheSize", def.getCacheSize(), null);
        doWriteAttribute("aggregationStrategy", def.getAggregationStrategy(), null);
        doWriteAttribute("onPrepare", def.getOnPrepare(), null);
        doWriteAttribute("executorService", def.getExecutorService(), null);
        doWriteAttribute("synchronous", def.getSynchronous(), null);
        doWriteAttribute("aggregationStrategyMethodName", def.getAggregationStrategyMethodName(), null);
        doWriteAttribute("timeout", def.getTimeout(), "0");
        doWriteAttribute("ignoreInvalidEndpoints", def.getIgnoreInvalidEndpoints(), null);
        doWriteAttribute("streaming", def.getStreaming(), null);
        doWriteAttribute("stopOnException", def.getStopOnException(), null);
        doWriteAttribute("delimiter", def.getDelimiter(), ",");
        doWriteAttribute("parallelProcessing", def.getParallelProcessing(), null);
        doWriteAttribute("parallelAggregate", def.getParallelAggregate(), null);
        doWriteAttribute("shareUnitOfWork", def.getShareUnitOfWork(), null);
        doWriteAttribute("aggregationStrategyMethodAllowNull", def.getAggregationStrategyMethodAllowNull(), null);
        doWriteExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteRedeliveryPolicyDefinition(String name, RedeliveryPolicyDefinition def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("logNewException", def.getLogNewException(), "true");
        doWriteAttribute("backOffMultiplier", def.getBackOffMultiplier(), "2.0");
        doWriteAttribute("exchangeFormatterRef", def.getExchangeFormatterRef(), null);
        doWriteAttribute("allowRedeliveryWhileStopping", def.getAllowRedeliveryWhileStopping(), "true");
        doWriteAttribute("delayPattern", def.getDelayPattern(), null);
        doWriteAttribute("retriesExhaustedLogLevel", def.getRetriesExhaustedLogLevel(), "ERROR");
        doWriteAttribute("logStackTrace", def.getLogStackTrace(), "true");
        doWriteAttribute("retryAttemptedLogInterval", def.getRetryAttemptedLogInterval(), "1");
        doWriteAttribute("logRetryAttempted", def.getLogRetryAttempted(), "true");
        doWriteAttribute("maximumRedeliveryDelay", def.getMaximumRedeliveryDelay(), "60000");
        doWriteAttribute("useExponentialBackOff", def.getUseExponentialBackOff(), null);
        doWriteAttribute("logExhaustedMessageHistory", def.getLogExhaustedMessageHistory(), null);
        doWriteAttribute("collisionAvoidanceFactor", def.getCollisionAvoidanceFactor(), "0.15");
        doWriteAttribute("logRetryStackTrace", def.getLogRetryStackTrace(), null);
        doWriteAttribute("asyncDelayedRedelivery", def.getAsyncDelayedRedelivery(), null);
        doWriteAttribute("disableRedelivery", def.getDisableRedelivery(), null);
        doWriteAttribute("logContinued", def.getLogContinued(), null);
        doWriteAttribute("retryAttemptedLogLevel", def.getRetryAttemptedLogLevel(), "DEBUG");
        doWriteAttribute("redeliveryDelay", def.getRedeliveryDelay(), "1000");
        doWriteAttribute("logExhaustedMessageBody", def.getLogExhaustedMessageBody(), null);
        doWriteAttribute("logHandled", def.getLogHandled(), null);
        doWriteAttribute("maximumRedeliveries", def.getMaximumRedeliveries(), null);
        doWriteAttribute("logExhausted", def.getLogExhausted(), "true");
        doWriteAttribute("useCollisionAvoidance", def.getUseCollisionAvoidance(), null);
        endElement(name);
    }
    protected void doWriteRemoveHeaderDefinition(String name, RemoveHeaderDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("name", def.getName(), null);
        endElement(name);
    }
    protected void doWriteRemoveHeadersDefinition(String name, RemoveHeadersDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("excludePattern", def.getExcludePattern(), null);
        doWriteAttribute("pattern", def.getPattern(), null);
        endElement(name);
    }
    protected void doWriteRemovePropertiesDefinition(String name, RemovePropertiesDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("excludePattern", def.getExcludePattern(), null);
        doWriteAttribute("pattern", def.getPattern(), null);
        endElement(name);
    }
    protected void doWriteRemovePropertyDefinition(String name, RemovePropertyDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("name", def.getName(), null);
        endElement(name);
    }
    protected void doWriteRemoveVariableDefinition(String name, RemoveVariableDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("name", def.getName(), null);
        endElement(name);
    }
    protected void doWriteResequenceDefinition(String name, ResequenceDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteElement(null, def.getExpression(), this::doWriteExpressionDefinitionRef);
        doWriteElement(null, def.getResequencerConfig(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "BatchResequencerConfig" -> doWriteBatchResequencerConfig("batchConfig", (BatchResequencerConfig) v);
                case "StreamResequencerConfig" -> doWriteStreamResequencerConfig("streamConfig", (StreamResequencerConfig) v);
            }
        });
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteResilience4jConfigurationCommonAttributes(Resilience4jConfigurationCommon def) throws IOException {
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("failureRateThreshold", def.getFailureRateThreshold(), "50");
        doWriteAttribute("bulkheadMaxWaitDuration", def.getBulkheadMaxWaitDuration(), "0");
        doWriteAttribute("slowCallDurationThreshold", def.getSlowCallDurationThreshold(), "60");
        doWriteAttribute("timeoutCancelRunningFuture", def.getTimeoutCancelRunningFuture(), "true");
        doWriteAttribute("minimumNumberOfCalls", def.getMinimumNumberOfCalls(), "100");
        doWriteAttribute("timeoutDuration", def.getTimeoutDuration(), "1000");
        doWriteAttribute("timeoutEnabled", def.getTimeoutEnabled(), "false");
        doWriteAttribute("timeoutExecutorService", def.getTimeoutExecutorService(), null);
        doWriteAttribute("permittedNumberOfCallsInHalfOpenState", def.getPermittedNumberOfCallsInHalfOpenState(), "10");
        doWriteAttribute("throwExceptionWhenHalfOpenOrOpenState", def.getThrowExceptionWhenHalfOpenOrOpenState(), "false");
        doWriteAttribute("slowCallRateThreshold", def.getSlowCallRateThreshold(), "100");
        doWriteAttribute("writableStackTraceEnabled", def.getWritableStackTraceEnabled(), "true");
        doWriteAttribute("automaticTransitionFromOpenToHalfOpenEnabled", def.getAutomaticTransitionFromOpenToHalfOpenEnabled(), "false");
        doWriteAttribute("circuitBreaker", def.getCircuitBreaker(), null);
        doWriteAttribute("slidingWindowSize", def.getSlidingWindowSize(), "100");
        doWriteAttribute("config", def.getConfig(), null);
        doWriteAttribute("bulkheadMaxConcurrentCalls", def.getBulkheadMaxConcurrentCalls(), "25");
        doWriteAttribute("slidingWindowType", def.getSlidingWindowType(), "COUNT_BASED");
        doWriteAttribute("bulkheadEnabled", def.getBulkheadEnabled(), "false");
        doWriteAttribute("waitDurationInOpenState", def.getWaitDurationInOpenState(), "60");
    }
    protected void doWriteResilience4jConfigurationCommonElements(Resilience4jConfigurationCommon def) throws IOException {
        doWriteList(null, "ignoreException", def.getIgnoreExceptions(), this::doWriteString);
        doWriteList(null, "recordException", def.getRecordExceptions(), this::doWriteString);
    }
    protected void doWriteResilience4jConfigurationCommon(String name, Resilience4jConfigurationCommon def) throws IOException {
        startElement(name);
        doWriteResilience4jConfigurationCommonAttributes(def);
        doWriteResilience4jConfigurationCommonElements(def);
        endElement(name);
    }
    protected void doWriteResilience4jConfigurationDefinition(String name, Resilience4jConfigurationDefinition def) throws IOException {
        startElement(name);
        doWriteResilience4jConfigurationCommonAttributes(def);
        doWriteResilience4jConfigurationCommonElements(def);
        endElement(name);
    }
    protected void doWriteRestContextRefDefinition(String name, RestContextRefDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("ref", def.getRef(), null);
        endElement(name);
    }
    protected void doWriteResumableDefinition(String name, ResumableDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("resumeStrategy", def.getResumeStrategy(), null);
        doWriteAttribute("intermittent", def.getIntermittent(), "false");
        doWriteAttribute("loggingLevel", def.getLoggingLevel(), "ERROR");
        endElement(name);
    }
    protected void doWriteRollbackDefinition(String name, RollbackDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("markRollbackOnly", def.getMarkRollbackOnly(), null);
        doWriteAttribute("message", def.getMessage(), null);
        doWriteAttribute("markRollbackOnlyLast", def.getMarkRollbackOnlyLast(), null);
        endElement(name);
    }
    protected void doWriteRouteBuilderDefinition(String name, RouteBuilderDefinition def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("ref", def.getRef(), null);
        endElement(name);
    }
    protected void doWriteRouteConfigurationContextRefDefinition(String name, RouteConfigurationContextRefDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("ref", def.getRef(), null);
        endElement(name);
    }
    protected void doWriteRouteConfigurationDefinition(String name, RouteConfigurationDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteAttribute("precondition", def.getPrecondition(), null);
        doWriteList(null, "onException", def.getOnExceptions(), this::doWriteOnExceptionDefinition);
        doWriteList(null, "onCompletion", def.getOnCompletions(), this::doWriteOnCompletionDefinition);
        doWriteList(null, "interceptSendToEndpoint", def.getInterceptSendTos(), this::doWriteInterceptSendToEndpointDefinition);
        doWriteElement("errorHandler", def.getErrorHandler(), this::doWriteErrorHandlerDefinition);
        doWriteList(null, "interceptFrom", def.getInterceptFroms(), this::doWriteInterceptFromDefinition);
        doWriteList(null, "intercept", def.getIntercepts(), this::doWriteInterceptDefinition);
        endElement(name);
    }
    protected void doWriteRouteConfigurationsDefinition(String name, RouteConfigurationsDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteList(null, null, def.getRouteConfigurations(), this::doWriteRouteConfigurationDefinitionRef);
        endElement(name);
    }
    protected void doWriteRouteContextRefDefinition(String name, RouteContextRefDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("ref", def.getRef(), null);
        endElement(name);
    }
    protected void doWriteRouteDefinition(String name, RouteDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("template", toString(def.isTemplate()), null);
        doWriteAttribute("routeConfigurationId", def.getRouteConfigurationId(), null);
        doWriteAttribute("streamCache", def.getStreamCache(), null);
        doWriteAttribute("trace", def.getTrace(), null);
        doWriteAttribute("rest", toString(def.isRest()), null);
        doWriteAttribute("routePolicyRef", def.getRoutePolicyRef(), null);
        doWriteAttribute("precondition", def.getPrecondition(), null);
        doWriteAttribute("shutdownRoute", def.getShutdownRoute(), "Default");
        doWriteAttribute("shutdownRunningTask", def.getShutdownRunningTask(), "CompleteCurrentTaskOnly");
        doWriteAttribute("startupOrder", toString(def.getStartupOrder()), null);
        doWriteAttribute("logMask", def.getLogMask(), null);
        doWriteAttribute("nodePrefixId", def.getNodePrefixId(), null);
        doWriteAttribute("messageHistory", def.getMessageHistory(), null);
        doWriteAttribute("kamelet", toString(def.isKamelet()), null);
        doWriteAttribute("autoStartup", def.getAutoStartup(), "true");
        doWriteAttribute("delayer", def.getDelayer(), null);
        doWriteAttribute("group", def.getGroup(), null);
        doWriteAttribute("errorHandlerRef", def.getErrorHandlerRef(), null);
        doWriteList(null, "routeProperty", def.getRouteProperties(), this::doWritePropertyDefinition);
        doWriteElement("errorHandler", def.getErrorHandler(), this::doWriteErrorHandlerDefinition);
        doWriteElement(null, def.getInput(), this::doWriteFromDefinitionRef);
        doWriteElement(null, def.getInputType(), this::doWriteInputTypeDefinitionRef);
        doWriteElement(null, def.getOutputType(), this::doWriteOutputTypeDefinitionRef);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteRouteTemplateContextRefDefinition(String name, RouteTemplateContextRefDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("ref", def.getRef(), null);
        endElement(name);
    }
    protected void doWriteRouteTemplateDefinition(String name, RouteTemplateDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteList(null, "templateParameter", def.getTemplateParameters(), this::doWriteRouteTemplateParameterDefinition);
        doWriteElement("route", def.getRoute(), this::doWriteRouteDefinition);
        doWriteList(null, "templateBean", def.getTemplateBeans(), this::doWriteBeanFactoryDefinition);
        endElement(name);
    }
    protected void doWriteRouteTemplateParameterDefinition(String name, RouteTemplateParameterDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("defaultValue", def.getDefaultValue(), null);
        doWriteAttribute("name", def.getName(), null);
        doWriteAttribute("description", def.getDescription(), null);
        doWriteAttribute("required", toString(def.getRequired()), null);
        endElement(name);
    }
    protected void doWriteRouteTemplatesDefinition(String name, RouteTemplatesDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteList(null, null, def.getRouteTemplates(), this::doWriteRouteTemplateDefinitionRef);
        endElement(name);
    }
    protected void doWriteRoutesDefinition(String name, RoutesDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteList(null, null, def.getRoutes(), this::doWriteRouteDefinitionRef);
        endElement(name);
    }
    protected void doWriteRoutingSlipDefinition(String name, RoutingSlipDefinition<?> def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("uriDelimiter", def.getUriDelimiter(), ",");
        doWriteAttribute("ignoreInvalidEndpoints", def.getIgnoreInvalidEndpoints(), null);
        doWriteAttribute("cacheSize", def.getCacheSize(), null);
        doWriteExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteSagaActionUriDefinition(String name, SagaActionUriDefinition def) throws IOException {
        startElement(name);
        doWriteSendDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWriteSagaDefinition(String name, SagaDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("propagation", def.getPropagation(), "REQUIRED");
        doWriteAttribute("completionMode", def.getCompletionMode(), "AUTO");
        doWriteAttribute("sagaService", def.getSagaService(), null);
        doWriteAttribute("timeout", def.getTimeout(), null);
        doWriteElement("completion", def.getCompletion(), this::doWriteSagaActionUriDefinition);
        doWriteList(null, "option", def.getOptions(), this::doWritePropertyExpressionDefinition);
        doWriteElement("compensation", def.getCompensation(), this::doWriteSagaActionUriDefinition);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteSamplingDefinition(String name, SamplingDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("messageFrequency", def.getMessageFrequency(), null);
        doWriteAttribute("samplePeriod", def.getSamplePeriod(), "1000");
        endElement(name);
    }
    protected void doWriteScriptDefinition(String name, ScriptDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteSendDefinitionAttributes(SendDefinition<?> def) throws IOException {
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("uri", def.getUri(), null);
    }
    protected void doWriteSendDefinition(String name, SendDefinition<?> def) throws IOException {
        startElement(name);
        doWriteSendDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWriteSetBodyDefinition(String name, SetBodyDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteSetExchangePatternDefinition(String name, SetExchangePatternDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("pattern", def.getPattern(), null);
        endElement(name);
    }
    protected void doWriteSetHeaderDefinition(String name, SetHeaderDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("name", def.getName(), null);
        doWriteExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteSetHeadersDefinition(String name, SetHeadersDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteList(null, null, def.getHeaders(), this::doWriteSetHeaderDefinitionRef);
        endElement(name);
    }
    protected void doWriteSetPropertyDefinition(String name, SetPropertyDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("name", def.getName(), null);
        doWriteExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteSetVariableDefinition(String name, SetVariableDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("name", def.getName(), null);
        doWriteExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteSetVariablesDefinition(String name, SetVariablesDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteList(null, null, def.getVariables(), this::doWriteSetVariableDefinitionRef);
        endElement(name);
    }
    protected void doWriteSortDefinition(String name, SortDefinition<?> def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("comparator", def.getComparator(), null);
        doWriteExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteSplitDefinition(String name, SplitDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("aggregationStrategy", def.getAggregationStrategy(), null);
        doWriteAttribute("onPrepare", def.getOnPrepare(), null);
        doWriteAttribute("executorService", def.getExecutorService(), null);
        doWriteAttribute("synchronous", def.getSynchronous(), null);
        doWriteAttribute("aggregationStrategyMethodName", def.getAggregationStrategyMethodName(), null);
        doWriteAttribute("timeout", def.getTimeout(), "0");
        doWriteAttribute("streaming", def.getStreaming(), null);
        doWriteAttribute("stopOnException", def.getStopOnException(), null);
        doWriteAttribute("delimiter", def.getDelimiter(), ",");
        doWriteAttribute("parallelProcessing", def.getParallelProcessing(), null);
        doWriteAttribute("parallelAggregate", def.getParallelAggregate(), null);
        doWriteAttribute("shareUnitOfWork", def.getShareUnitOfWork(), null);
        doWriteAttribute("aggregationStrategyMethodAllowNull", def.getAggregationStrategyMethodAllowNull(), null);
        doWriteOutputExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteStepDefinition(String name, StepDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteStopDefinition(String name, StopDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWriteTemplatedRouteDefinition(String name, TemplatedRouteDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("routeId", def.getRouteId(), null);
        doWriteAttribute("routeTemplateRef", def.getRouteTemplateRef(), null);
        doWriteAttribute("prefixId", def.getPrefixId(), null);
        doWriteAttribute("group", def.getGroup(), null);
        doWriteList(null, "bean", def.getBeans(), this::doWriteBeanFactoryDefinition);
        doWriteList(null, "parameter", def.getParameters(), this::doWriteTemplatedRouteParameterDefinition);
        endElement(name);
    }
    protected void doWriteTemplatedRouteParameterDefinition(String name, TemplatedRouteParameterDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("name", def.getName(), null);
        doWriteAttribute("value", def.getValue(), null);
        endElement(name);
    }
    protected void doWriteTemplatedRoutesDefinition(String name, TemplatedRoutesDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteList(null, null, def.getTemplatedRoutes(), this::doWriteTemplatedRouteDefinitionRef);
        endElement(name);
    }
    protected void doWriteThreadPoolProfileDefinition(String name, ThreadPoolProfileDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteAttribute("keepAliveTime", def.getKeepAliveTime(), null);
        doWriteAttribute("maxQueueSize", def.getMaxQueueSize(), null);
        doWriteAttribute("allowCoreThreadTimeOut", def.getAllowCoreThreadTimeOut(), null);
        doWriteAttribute("poolSize", def.getPoolSize(), null);
        doWriteAttribute("defaultProfile", def.getDefaultProfile(), null);
        doWriteAttribute("maxPoolSize", def.getMaxPoolSize(), null);
        doWriteAttribute("rejectedPolicy", def.getRejectedPolicy(), null);
        doWriteAttribute("timeUnit", def.getTimeUnit(), null);
        endElement(name);
    }
    protected void doWriteThreadsDefinition(String name, ThreadsDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("keepAliveTime", def.getKeepAliveTime(), null);
        doWriteAttribute("callerRunsWhenRejected", def.getCallerRunsWhenRejected(), "true");
        doWriteAttribute("maxQueueSize", def.getMaxQueueSize(), null);
        doWriteAttribute("executorService", def.getExecutorService(), null);
        doWriteAttribute("allowCoreThreadTimeOut", def.getAllowCoreThreadTimeOut(), null);
        doWriteAttribute("poolSize", def.getPoolSize(), null);
        doWriteAttribute("maxPoolSize", def.getMaxPoolSize(), null);
        doWriteAttribute("threadName", def.getThreadName(), "Threads");
        doWriteAttribute("rejectedPolicy", def.getRejectedPolicy(), null);
        doWriteAttribute("timeUnit", def.getTimeUnit(), null);
        endElement(name);
    }
    protected void doWriteThrottleDefinition(String name, ThrottleDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("mode", def.getMode(), "TotalRequests");
        doWriteAttribute("timePeriodMillis", def.getTimePeriodMillis(), "1000");
        doWriteAttribute("rejectExecution", def.getRejectExecution(), null);
        doWriteAttribute("callerRunsWhenRejected", def.getCallerRunsWhenRejected(), "true");
        doWriteAttribute("executorService", def.getExecutorService(), null);
        doWriteAttribute("asyncDelayed", def.getAsyncDelayed(), null);
        doWriteExpressionNodeElements(def);
        doWriteElement("correlationExpression", def.getCorrelationExpression(), this::doWriteExpressionSubElementDefinition);
        endElement(name);
    }
    protected void doWriteThrowExceptionDefinition(String name, ThrowExceptionDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("exceptionType", def.getExceptionType(), null);
        doWriteAttribute("ref", def.getRef(), null);
        doWriteAttribute("message", def.getMessage(), null);
        endElement(name);
    }
    protected void doWriteToDefinition(String name, ToDefinition def) throws IOException {
        startElement(name);
        doWriteSendDefinitionAttributes(def);
        doWriteAttribute("variableReceive", def.getVariableReceive(), null);
        doWriteAttribute("variableSend", def.getVariableSend(), null);
        doWriteAttribute("pattern", def.getPattern(), null);
        endElement(name);
    }
    protected void doWriteToDynamicDefinitionAttributes(ToDynamicDefinition def) throws IOException {
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("variableReceive", def.getVariableReceive(), null);
        doWriteAttribute("variableSend", def.getVariableSend(), null);
        doWriteAttribute("cacheSize", def.getCacheSize(), null);
        doWriteAttribute("ignoreInvalidEndpoint", def.getIgnoreInvalidEndpoint(), null);
        doWriteAttribute("autoStartComponents", def.getAutoStartComponents(), "true");
        doWriteAttribute("pattern", def.getPattern(), null);
        doWriteAttribute("allowOptimisedComponents", def.getAllowOptimisedComponents(), "true");
        doWriteAttribute("uri", def.getUri(), null);
    }
    protected void doWriteToDynamicDefinition(String name, ToDynamicDefinition def) throws IOException {
        startElement(name);
        doWriteToDynamicDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWriteTokenizerDefinition(String name, TokenizerDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteElement(null, def.getTokenizerImplementation(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "LangChain4jCharacterTokenizerDefinition" -> doWriteLangChain4jCharacterTokenizerDefinition("langChain4jCharacterTokenizer", (LangChain4jCharacterTokenizerDefinition) v);
                case "LangChain4jLineTokenizerDefinition" -> doWriteLangChain4jLineTokenizerDefinition("langChain4jLineTokenizer", (LangChain4jLineTokenizerDefinition) v);
                case "LangChain4jParagraphTokenizerDefinition" -> doWriteLangChain4jParagraphTokenizerDefinition("langChain4jParagraphTokenizer", (LangChain4jParagraphTokenizerDefinition) v);
                case "LangChain4jSentenceTokenizerDefinition" -> doWriteLangChain4jSentenceTokenizerDefinition("langChain4jSentenceTokenizer", (LangChain4jSentenceTokenizerDefinition) v);
                case "LangChain4jWordTokenizerDefinition" -> doWriteLangChain4jWordTokenizerDefinition("langChain4jWordTokenizer", (LangChain4jWordTokenizerDefinition) v);
            }
        });
        endElement(name);
    }
    protected void doWriteTokenizerImplementationDefinition(String name, TokenizerImplementationDefinition def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        endElement(name);
    }
    protected void doWriteTransactedDefinition(String name, TransactedDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("ref", def.getRef(), null);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteTransformDefinition(String name, TransformDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("toType", def.getToType(), null);
        doWriteAttribute("fromType", def.getFromType(), null);
        doWriteExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteTryDefinition(String name, TryDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteList(null, null, def.getOutputs(), this::doWriteProcessorDefinitionRef);
        endElement(name);
    }
    protected void doWriteUnmarshalDefinition(String name, UnmarshalDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("variableReceive", def.getVariableReceive(), null);
        doWriteAttribute("variableSend", def.getVariableSend(), null);
        doWriteAttribute("allowNullBody", def.getAllowNullBody(), "false");
        doWriteElement(null, def.getDataFormatType(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "ASN1DataFormat" -> doWriteASN1DataFormat("asn1", (ASN1DataFormat) v);
                case "AvroDataFormat" -> doWriteAvroDataFormat("avro", (AvroDataFormat) v);
                case "BarcodeDataFormat" -> doWriteBarcodeDataFormat("barcode", (BarcodeDataFormat) v);
                case "Base64DataFormat" -> doWriteBase64DataFormat("base64", (Base64DataFormat) v);
                case "BeanioDataFormat" -> doWriteBeanioDataFormat("beanio", (BeanioDataFormat) v);
                case "BindyDataFormat" -> doWriteBindyDataFormat("bindy", (BindyDataFormat) v);
                case "CBORDataFormat" -> doWriteCBORDataFormat("cbor", (CBORDataFormat) v);
                case "CryptoDataFormat" -> doWriteCryptoDataFormat("crypto", (CryptoDataFormat) v);
                case "CsvDataFormat" -> doWriteCsvDataFormat("csv", (CsvDataFormat) v);
                case "CustomDataFormat" -> doWriteCustomDataFormat("custom", (CustomDataFormat) v);
                case "DfdlDataFormat" -> doWriteDfdlDataFormat("dfdl", (DfdlDataFormat) v);
                case "FhirJsonDataFormat" -> doWriteFhirJsonDataFormat("fhirJson", (FhirJsonDataFormat) v);
                case "FhirXmlDataFormat" -> doWriteFhirXmlDataFormat("fhirXml", (FhirXmlDataFormat) v);
                case "FlatpackDataFormat" -> doWriteFlatpackDataFormat("flatpack", (FlatpackDataFormat) v);
                case "ForyDataFormat" -> doWriteForyDataFormat("fory", (ForyDataFormat) v);
                case "GrokDataFormat" -> doWriteGrokDataFormat("grok", (GrokDataFormat) v);
                case "GzipDeflaterDataFormat" -> doWriteGzipDeflaterDataFormat("gzipDeflater", (GzipDeflaterDataFormat) v);
                case "HL7DataFormat" -> doWriteHL7DataFormat("hl7", (HL7DataFormat) v);
                case "IcalDataFormat" -> doWriteIcalDataFormat("ical", (IcalDataFormat) v);
                case "Iso8583DataFormat" -> doWriteIso8583DataFormat("iso8583", (Iso8583DataFormat) v);
                case "JacksonXMLDataFormat" -> doWriteJacksonXMLDataFormat("jacksonXml", (JacksonXMLDataFormat) v);
                case "JaxbDataFormat" -> doWriteJaxbDataFormat("jaxb", (JaxbDataFormat) v);
                case "JsonDataFormat" -> doWriteJsonDataFormat("json", (JsonDataFormat) v);
                case "JsonApiDataFormat" -> doWriteJsonApiDataFormat("jsonApi", (JsonApiDataFormat) v);
                case "LZFDataFormat" -> doWriteLZFDataFormat("lzf", (LZFDataFormat) v);
                case "MimeMultipartDataFormat" -> doWriteMimeMultipartDataFormat("mimeMultipart", (MimeMultipartDataFormat) v);
                case "ParquetAvroDataFormat" -> doWriteParquetAvroDataFormat("parquetAvro", (ParquetAvroDataFormat) v);
                case "ProtobufDataFormat" -> doWriteProtobufDataFormat("protobuf", (ProtobufDataFormat) v);
                case "RssDataFormat" -> doWriteRssDataFormat("rss", (RssDataFormat) v);
                case "SmooksDataFormat" -> doWriteSmooksDataFormat("smooks", (SmooksDataFormat) v);
                case "SoapDataFormat" -> doWriteSoapDataFormat("soap", (SoapDataFormat) v);
                case "SwiftMtDataFormat" -> doWriteSwiftMtDataFormat("swiftMt", (SwiftMtDataFormat) v);
                case "SwiftMxDataFormat" -> doWriteSwiftMxDataFormat("swiftMx", (SwiftMxDataFormat) v);
                case "SyslogDataFormat" -> doWriteSyslogDataFormat("syslog", (SyslogDataFormat) v);
                case "TarFileDataFormat" -> doWriteTarFileDataFormat("tarFile", (TarFileDataFormat) v);
                case "ThriftDataFormat" -> doWriteThriftDataFormat("thrift", (ThriftDataFormat) v);
                case "TidyMarkupDataFormat" -> doWriteTidyMarkupDataFormat("tidyMarkup", (TidyMarkupDataFormat) v);
                case "UniVocityCsvDataFormat" -> doWriteUniVocityCsvDataFormat("univocityCsv", (UniVocityCsvDataFormat) v);
                case "UniVocityFixedDataFormat" -> doWriteUniVocityFixedDataFormat("univocityFixed", (UniVocityFixedDataFormat) v);
                case "UniVocityTsvDataFormat" -> doWriteUniVocityTsvDataFormat("univocityTsv", (UniVocityTsvDataFormat) v);
                case "XMLSecurityDataFormat" -> doWriteXMLSecurityDataFormat("xmlSecurity", (XMLSecurityDataFormat) v);
                case "PGPDataFormat" -> doWritePGPDataFormat("pgp", (PGPDataFormat) v);
                case "YAMLDataFormat" -> doWriteYAMLDataFormat("yaml", (YAMLDataFormat) v);
                case "ZipDeflaterDataFormat" -> doWriteZipDeflaterDataFormat("zipDeflater", (ZipDeflaterDataFormat) v);
                case "ZipFileDataFormat" -> doWriteZipFileDataFormat("zipFile", (ZipFileDataFormat) v);
            }
        });
        endElement(name);
    }
    protected void doWriteValidateDefinition(String name, ValidateDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("predicateExceptionFactory", def.getPredicateExceptionFactory(), null);
        doWriteExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteValueDefinition(String name, ValueDefinition def) throws IOException {
        startElement(name);
        doWriteValue(def.getValue());
        endElement(name);
    }
    protected void doWriteWhenDefinition(String name, WhenDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteAttribute("disabled", def.getDisabled(), null);
        doWriteBasicOutputExpressionNodeElements(def);
        endElement(name);
    }
    protected void doWriteWireTapDefinition(String name, WireTapDefinition<?> def) throws IOException {
        startElement(name);
        doWriteToDynamicDefinitionAttributes(def);
        doWriteAttribute("dynamicUri", def.getDynamicUri(), "true");
        doWriteAttribute("onPrepare", def.getOnPrepare(), null);
        doWriteAttribute("executorService", def.getExecutorService(), null);
        doWriteAttribute("copy", def.getCopy(), "true");
        endElement(name);
    }
    protected void doWriteApplicationDefinition(String name, ApplicationDefinition def) throws IOException {
        startElement(name);
        doWriteBeansDefinitionElements(def);
        endElement(name);
    }
    protected void doWriteBeanConstructorDefinition(String name, BeanConstructorDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("index", toString(def.getIndex()), null);
        doWriteAttribute("value", def.getValue(), null);
        endElement(name);
    }
    protected void doWriteBeanConstructorsDefinition(String name, BeanConstructorsDefinition def) throws IOException {
        startElement(name);
        doWriteList(null, "constructor", def.getConstructors(), this::doWriteBeanConstructorDefinition);
        endElement(name);
    }
    protected void doWriteBeanPropertiesDefinition(String name, BeanPropertiesDefinition def) throws IOException {
        startElement(name);
        doWriteList(null, "property", def.getProperties(), this::doWriteBeanPropertyDefinition);
        endElement(name);
    }
    protected void doWriteBeanPropertyDefinition(String name, BeanPropertyDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("value", def.getValue(), null);
        doWriteAttribute("key", def.getKey(), null);
        doWriteElement("properties", def.getProperties(), this::doWriteBeanPropertiesDefinition);
        endElement(name);
    }
    protected void doWriteBeansDefinitionElements(BeansDefinition def) throws IOException {
        doWriteList(null, "route", def.getRoutes(), this::doWriteRouteDefinition);
        domElements(def.getSpringOrBlueprintBeans());
        doWriteList("dataFormats", "dataFormat", def.getDataFormats(), this::doWriteDataFormatDefinition);
        doWriteList(null, "component-scan", def.getComponentScanning(), this::doWriteComponentScanDefinition);
        doWriteList(null, "bean", def.getBeans(), this::doWriteBeanFactoryDefinition);
        doWriteList(null, "restConfiguration", def.getRestConfigurations(), this::doWriteRestConfigurationDefinition);
        doWriteList(null, "rest", def.getRests(), this::doWriteRestDefinition);
        doWriteList(null, "routeConfiguration", def.getRouteConfigurations(), this::doWriteRouteConfigurationDefinition);
        doWriteList(null, "routeTemplate", def.getRouteTemplates(), this::doWriteRouteTemplateDefinition);
        doWriteList(null, "templatedRoute", def.getTemplatedRoutes(), this::doWriteTemplatedRouteDefinition);
    }
    protected void doWriteBeansDefinition(String name, BeansDefinition def) throws IOException {
        startElement(name);
        doWriteBeansDefinitionElements(def);
        endElement(name);
    }
    protected void doWriteComponentScanDefinition(String name, ComponentScanDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("base-package", def.getBasePackage(), null);
        endElement(name);
    }
    protected void doWriteBlacklistServiceCallServiceFilterConfiguration(String name, BlacklistServiceCallServiceFilterConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteServiceCallConfigurationElements(def);
        doWriteList(null, "servers", def.getServers(), this::doWriteString);
        endElement(name);
    }
    protected void doWriteCachingServiceCallServiceDiscoveryConfiguration(String name, CachingServiceCallServiceDiscoveryConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("units", def.getUnits(), "SECONDS");
        doWriteAttribute("timeout", def.getTimeout(), "60");
        doWriteServiceCallConfigurationElements(def);
        doWriteElement(null, def.getServiceDiscoveryConfiguration(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "ConsulServiceCallServiceDiscoveryConfiguration" -> doWriteConsulServiceCallServiceDiscoveryConfiguration("consulServiceDiscovery", (ConsulServiceCallServiceDiscoveryConfiguration) v);
                case "DnsServiceCallServiceDiscoveryConfiguration" -> doWriteDnsServiceCallServiceDiscoveryConfiguration("dnsServiceDiscovery", (DnsServiceCallServiceDiscoveryConfiguration) v);
                case "KubernetesServiceCallServiceDiscoveryConfiguration" -> doWriteKubernetesServiceCallServiceDiscoveryConfiguration("kubernetesServiceDiscovery", (KubernetesServiceCallServiceDiscoveryConfiguration) v);
                case "CombinedServiceCallServiceDiscoveryConfiguration" -> doWriteCombinedServiceCallServiceDiscoveryConfiguration("combinedServiceDiscovery", (CombinedServiceCallServiceDiscoveryConfiguration) v);
                case "StaticServiceCallServiceDiscoveryConfiguration" -> doWriteStaticServiceCallServiceDiscoveryConfiguration("staticServiceDiscovery", (StaticServiceCallServiceDiscoveryConfiguration) v);
            }
        });
        endElement(name);
    }
    protected void doWriteCombinedServiceCallServiceDiscoveryConfiguration(String name, CombinedServiceCallServiceDiscoveryConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteServiceCallConfigurationElements(def);
        doWriteList(null, null, def.getServiceDiscoveryConfigurations(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "ConsulServiceCallServiceDiscoveryConfiguration" -> doWriteConsulServiceCallServiceDiscoveryConfiguration("consulServiceDiscovery", (ConsulServiceCallServiceDiscoveryConfiguration) v);
                case "DnsServiceCallServiceDiscoveryConfiguration" -> doWriteDnsServiceCallServiceDiscoveryConfiguration("dnsServiceDiscovery", (DnsServiceCallServiceDiscoveryConfiguration) v);
                case "KubernetesServiceCallServiceDiscoveryConfiguration" -> doWriteKubernetesServiceCallServiceDiscoveryConfiguration("kubernetesServiceDiscovery", (KubernetesServiceCallServiceDiscoveryConfiguration) v);
                case "StaticServiceCallServiceDiscoveryConfiguration" -> doWriteStaticServiceCallServiceDiscoveryConfiguration("staticServiceDiscovery", (StaticServiceCallServiceDiscoveryConfiguration) v);
                case "CachingServiceCallServiceDiscoveryConfiguration" -> doWriteCachingServiceCallServiceDiscoveryConfiguration("cachingServiceDiscovery", (CachingServiceCallServiceDiscoveryConfiguration) v);
            }
        });
        endElement(name);
    }
    protected void doWriteCombinedServiceCallServiceFilterConfiguration(String name, CombinedServiceCallServiceFilterConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteServiceCallConfigurationElements(def);
        doWriteList(null, null, def.getServiceFilterConfigurations(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "BlacklistServiceCallServiceFilterConfiguration" -> doWriteBlacklistServiceCallServiceFilterConfiguration("blacklistServiceFilter", (BlacklistServiceCallServiceFilterConfiguration) v);
                case "CustomServiceCallServiceFilterConfiguration" -> doWriteCustomServiceCallServiceFilterConfiguration("customServiceFilter", (CustomServiceCallServiceFilterConfiguration) v);
                case "HealthyServiceCallServiceFilterConfiguration" -> doWriteHealthyServiceCallServiceFilterConfiguration("healthyServiceFilter", (HealthyServiceCallServiceFilterConfiguration) v);
                case "PassThroughServiceCallServiceFilterConfiguration" -> doWritePassThroughServiceCallServiceFilterConfiguration("passThroughServiceFilter", (PassThroughServiceCallServiceFilterConfiguration) v);
            }
        });
        endElement(name);
    }
    protected void doWriteConsulServiceCallServiceDiscoveryConfiguration(String name, ConsulServiceCallServiceDiscoveryConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("password", def.getPassword(), null);
        doWriteAttribute("readTimeoutMillis", def.getReadTimeoutMillis(), null);
        doWriteAttribute("aclToken", def.getAclToken(), null);
        doWriteAttribute("connectTimeoutMillis", def.getConnectTimeoutMillis(), null);
        doWriteAttribute("writeTimeoutMillis", def.getWriteTimeoutMillis(), null);
        doWriteAttribute("datacenter", def.getDatacenter(), null);
        doWriteAttribute("userName", def.getUserName(), null);
        doWriteAttribute("blockSeconds", def.getBlockSeconds(), "10");
        doWriteAttribute("url", def.getUrl(), null);
        doWriteServiceCallConfigurationElements(def);
        endElement(name);
    }
    protected void doWriteCustomServiceCallServiceFilterConfiguration(String name, CustomServiceCallServiceFilterConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("ref", def.getServiceFilterRef(), null);
        doWriteServiceCallConfigurationElements(def);
        endElement(name);
    }
    protected void doWriteDefaultServiceCallServiceLoadBalancerConfiguration(String name, DefaultServiceCallServiceLoadBalancerConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteServiceCallConfigurationElements(def);
        endElement(name);
    }
    protected void doWriteDnsServiceCallServiceDiscoveryConfiguration(String name, DnsServiceCallServiceDiscoveryConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("domain", def.getDomain(), null);
        doWriteAttribute("proto", def.getProto(), "_tcp");
        doWriteServiceCallConfigurationElements(def);
        endElement(name);
    }
    protected void doWriteHealthyServiceCallServiceFilterConfiguration(String name, HealthyServiceCallServiceFilterConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteServiceCallConfigurationElements(def);
        endElement(name);
    }
    protected void doWriteKubernetesServiceCallServiceDiscoveryConfiguration(String name, KubernetesServiceCallServiceDiscoveryConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("lookup", def.getLookup(), "environment");
        doWriteAttribute("portProtocol", def.getPortProtocol(), null);
        doWriteAttribute("caCertData", def.getCaCertData(), null);
        doWriteAttribute("portName", def.getPortName(), null);
        doWriteAttribute("oauthToken", def.getOauthToken(), null);
        doWriteAttribute("clientKeyAlgo", def.getClientKeyAlgo(), null);
        doWriteAttribute("clientCertFile", def.getClientCertFile(), null);
        doWriteAttribute("dnsDomain", def.getDnsDomain(), null);
        doWriteAttribute("password", def.getPassword(), null);
        doWriteAttribute("apiVersion", def.getApiVersion(), null);
        doWriteAttribute("clientKeyData", def.getClientKeyData(), null);
        doWriteAttribute("masterUrl", def.getMasterUrl(), null);
        doWriteAttribute("namespace", def.getNamespace(), null);
        doWriteAttribute("clientCertData", def.getClientCertData(), null);
        doWriteAttribute("clientKeyFile", def.getClientKeyFile(), null);
        doWriteAttribute("caCertFile", def.getCaCertFile(), null);
        doWriteAttribute("clientKeyPassphrase", def.getClientKeyPassphrase(), null);
        doWriteAttribute("trustCerts", def.getTrustCerts(), null);
        doWriteAttribute("username", def.getUsername(), null);
        doWriteServiceCallConfigurationElements(def);
        endElement(name);
    }
    protected void doWritePassThroughServiceCallServiceFilterConfiguration(String name, PassThroughServiceCallServiceFilterConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteServiceCallConfigurationElements(def);
        endElement(name);
    }
    protected void doWriteServiceCallConfigurationElements(ServiceCallConfiguration def) throws IOException {
        doWriteList(null, "properties", def.getProperties(), this::doWritePropertyDefinition);
    }
    protected void doWriteServiceCallConfiguration(String name, ServiceCallConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteServiceCallConfigurationElements(def);
        endElement(name);
    }
    protected void doWriteServiceCallConfigurationDefinition(String name, ServiceCallConfigurationDefinition def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("serviceDiscoveryRef", def.getServiceDiscoveryRef(), null);
        doWriteAttribute("pattern", def.getPattern(), null);
        doWriteAttribute("uri", def.getUri(), null);
        doWriteAttribute("expressionRef", def.getExpressionRef(), null);
        doWriteAttribute("component", def.getComponent(), "http");
        doWriteAttribute("loadBalancerRef", def.getLoadBalancerRef(), null);
        doWriteAttribute("serviceFilterRef", def.getServiceFilterRef(), null);
        doWriteAttribute("serviceChooserRef", def.getServiceChooserRef(), null);
        doWriteElement(null, def.getServiceFilterConfiguration(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "BlacklistServiceCallServiceFilterConfiguration" -> doWriteBlacklistServiceCallServiceFilterConfiguration("blacklistServiceFilter", (BlacklistServiceCallServiceFilterConfiguration) v);
                case "CombinedServiceCallServiceFilterConfiguration" -> doWriteCombinedServiceCallServiceFilterConfiguration("combinedServiceFilter", (CombinedServiceCallServiceFilterConfiguration) v);
                case "CustomServiceCallServiceFilterConfiguration" -> doWriteCustomServiceCallServiceFilterConfiguration("customServiceFilter", (CustomServiceCallServiceFilterConfiguration) v);
                case "HealthyServiceCallServiceFilterConfiguration" -> doWriteHealthyServiceCallServiceFilterConfiguration("healthyServiceFilter", (HealthyServiceCallServiceFilterConfiguration) v);
                case "PassThroughServiceCallServiceFilterConfiguration" -> doWritePassThroughServiceCallServiceFilterConfiguration("passThroughServiceFilter", (PassThroughServiceCallServiceFilterConfiguration) v);
            }
        });
        doWriteElement(null, def.getLoadBalancerConfiguration(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "DefaultServiceCallServiceLoadBalancerConfiguration" -> doWriteDefaultServiceCallServiceLoadBalancerConfiguration("defaultLoadBalancer", (DefaultServiceCallServiceLoadBalancerConfiguration) v);
            }
        });
        doWriteElement(null, def.getServiceDiscoveryConfiguration(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "CachingServiceCallServiceDiscoveryConfiguration" -> doWriteCachingServiceCallServiceDiscoveryConfiguration("cachingServiceDiscovery", (CachingServiceCallServiceDiscoveryConfiguration) v);
                case "CombinedServiceCallServiceDiscoveryConfiguration" -> doWriteCombinedServiceCallServiceDiscoveryConfiguration("combinedServiceDiscovery", (CombinedServiceCallServiceDiscoveryConfiguration) v);
                case "ConsulServiceCallServiceDiscoveryConfiguration" -> doWriteConsulServiceCallServiceDiscoveryConfiguration("consulServiceDiscovery", (ConsulServiceCallServiceDiscoveryConfiguration) v);
                case "DnsServiceCallServiceDiscoveryConfiguration" -> doWriteDnsServiceCallServiceDiscoveryConfiguration("dnsServiceDiscovery", (DnsServiceCallServiceDiscoveryConfiguration) v);
                case "KubernetesServiceCallServiceDiscoveryConfiguration" -> doWriteKubernetesServiceCallServiceDiscoveryConfiguration("kubernetesServiceDiscovery", (KubernetesServiceCallServiceDiscoveryConfiguration) v);
                case "StaticServiceCallServiceDiscoveryConfiguration" -> doWriteStaticServiceCallServiceDiscoveryConfiguration("staticServiceDiscovery", (StaticServiceCallServiceDiscoveryConfiguration) v);
                case "ZooKeeperServiceCallServiceDiscoveryConfiguration" -> doWriteZooKeeperServiceCallServiceDiscoveryConfiguration("zookeeperServiceDiscovery", (ZooKeeperServiceCallServiceDiscoveryConfiguration) v);
            }
        });
        doWriteElement("expression", def.getExpressionConfiguration(), this::doWriteServiceCallExpressionConfiguration);
        endElement(name);
    }
    protected void doWriteServiceCallDefinition(String name, ServiceCallDefinition def) throws IOException {
        startElement(name);
        doWriteProcessorDefinitionAttributes(def);
        doWriteAttribute("serviceDiscoveryRef", def.getServiceDiscoveryRef(), null);
        doWriteAttribute("configurationRef", def.getConfigurationRef(), null);
        doWriteAttribute("pattern", def.getPattern(), null);
        doWriteAttribute("uri", def.getUri(), null);
        doWriteAttribute("expressionRef", def.getExpressionRef(), null);
        doWriteAttribute("component", def.getComponent(), "http");
        doWriteAttribute("loadBalancerRef", def.getLoadBalancerRef(), null);
        doWriteAttribute("serviceFilterRef", def.getServiceFilterRef(), null);
        doWriteAttribute("name", def.getName(), null);
        doWriteAttribute("serviceChooserRef", def.getServiceChooserRef(), null);
        doWriteElement(null, def.getServiceFilterConfiguration(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "BlacklistServiceCallServiceFilterConfiguration" -> doWriteBlacklistServiceCallServiceFilterConfiguration("blacklistServiceFilter", (BlacklistServiceCallServiceFilterConfiguration) v);
                case "CombinedServiceCallServiceFilterConfiguration" -> doWriteCombinedServiceCallServiceFilterConfiguration("combinedServiceFilter", (CombinedServiceCallServiceFilterConfiguration) v);
                case "CustomServiceCallServiceFilterConfiguration" -> doWriteCustomServiceCallServiceFilterConfiguration("customServiceFilter", (CustomServiceCallServiceFilterConfiguration) v);
                case "HealthyServiceCallServiceFilterConfiguration" -> doWriteHealthyServiceCallServiceFilterConfiguration("healthyServiceFilter", (HealthyServiceCallServiceFilterConfiguration) v);
                case "PassThroughServiceCallServiceFilterConfiguration" -> doWritePassThroughServiceCallServiceFilterConfiguration("passThroughServiceFilter", (PassThroughServiceCallServiceFilterConfiguration) v);
            }
        });
        doWriteElement(null, def.getLoadBalancerConfiguration(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "DefaultServiceCallServiceLoadBalancerConfiguration" -> doWriteDefaultServiceCallServiceLoadBalancerConfiguration("defaultLoadBalancer", (DefaultServiceCallServiceLoadBalancerConfiguration) v);
            }
        });
        doWriteElement(null, def.getServiceDiscoveryConfiguration(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "CachingServiceCallServiceDiscoveryConfiguration" -> doWriteCachingServiceCallServiceDiscoveryConfiguration("cachingServiceDiscovery", (CachingServiceCallServiceDiscoveryConfiguration) v);
                case "CombinedServiceCallServiceDiscoveryConfiguration" -> doWriteCombinedServiceCallServiceDiscoveryConfiguration("combinedServiceDiscovery", (CombinedServiceCallServiceDiscoveryConfiguration) v);
                case "ConsulServiceCallServiceDiscoveryConfiguration" -> doWriteConsulServiceCallServiceDiscoveryConfiguration("consulServiceDiscovery", (ConsulServiceCallServiceDiscoveryConfiguration) v);
                case "DnsServiceCallServiceDiscoveryConfiguration" -> doWriteDnsServiceCallServiceDiscoveryConfiguration("dnsServiceDiscovery", (DnsServiceCallServiceDiscoveryConfiguration) v);
                case "KubernetesServiceCallServiceDiscoveryConfiguration" -> doWriteKubernetesServiceCallServiceDiscoveryConfiguration("kubernetesServiceDiscovery", (KubernetesServiceCallServiceDiscoveryConfiguration) v);
                case "StaticServiceCallServiceDiscoveryConfiguration" -> doWriteStaticServiceCallServiceDiscoveryConfiguration("staticServiceDiscovery", (StaticServiceCallServiceDiscoveryConfiguration) v);
                case "ZooKeeperServiceCallServiceDiscoveryConfiguration" -> doWriteZooKeeperServiceCallServiceDiscoveryConfiguration("zookeeperServiceDiscovery", (ZooKeeperServiceCallServiceDiscoveryConfiguration) v);
            }
        });
        doWriteElement("expression", def.getExpressionConfiguration(), this::doWriteServiceCallExpressionConfiguration);
        endElement(name);
    }
    protected void doWriteServiceCallExpressionConfiguration(String name, ServiceCallExpressionConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("hostHeader", def.getHostHeader(), "CamelServiceCallServiceHost");
        doWriteAttribute("portHeader", def.getPortHeader(), "CamelServiceCallServicePort");
        doWriteServiceCallConfigurationElements(def);
        doWriteElement(null, def.getExpressionType(), this::doWriteExpressionDefinitionRef);
        endElement(name);
    }
    protected void doWriteServiceCallServiceChooserConfiguration(String name, ServiceCallServiceChooserConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteServiceCallConfigurationElements(def);
        endElement(name);
    }
    protected void doWriteServiceCallServiceDiscoveryConfiguration(String name, ServiceCallServiceDiscoveryConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteServiceCallConfigurationElements(def);
        endElement(name);
    }
    protected void doWriteServiceCallServiceFilterConfiguration(String name, ServiceCallServiceFilterConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteServiceCallConfigurationElements(def);
        endElement(name);
    }
    protected void doWriteServiceCallServiceLoadBalancerConfiguration(String name, ServiceCallServiceLoadBalancerConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteServiceCallConfigurationElements(def);
        endElement(name);
    }
    protected void doWriteStaticServiceCallServiceDiscoveryConfiguration(String name, StaticServiceCallServiceDiscoveryConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteServiceCallConfigurationElements(def);
        doWriteList(null, "servers", def.getServers(), this::doWriteString);
        endElement(name);
    }
    protected void doWriteZooKeeperServiceCallServiceDiscoveryConfiguration(String name, ZooKeeperServiceCallServiceDiscoveryConfiguration def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("reconnectMaxRetries", def.getReconnectMaxRetries(), null);
        doWriteAttribute("nodes", def.getNodes(), null);
        doWriteAttribute("basePath", def.getBasePath(), null);
        doWriteAttribute("reconnectBaseSleepTime", def.getReconnectBaseSleepTime(), null);
        doWriteAttribute("namespace", def.getNamespace(), null);
        doWriteAttribute("reconnectMaxSleepTime", def.getReconnectMaxSleepTime(), null);
        doWriteAttribute("sessionTimeout", def.getSessionTimeout(), null);
        doWriteAttribute("connectionTimeout", def.getConnectionTimeout(), null);
        doWriteServiceCallConfigurationElements(def);
        endElement(name);
    }
    protected void doWriteBatchResequencerConfig(String name, BatchResequencerConfig def) throws IOException {
        startElement(name);
        doWriteAttribute("reverse", def.getReverse(), null);
        doWriteAttribute("batchSize", def.getBatchSize(), "100");
        doWriteAttribute("allowDuplicates", def.getAllowDuplicates(), null);
        doWriteAttribute("batchTimeout", def.getBatchTimeout(), "1000");
        doWriteAttribute("ignoreInvalidExchanges", def.getIgnoreInvalidExchanges(), null);
        endElement(name);
    }
    protected void doWriteResequencerConfig(String name, ResequencerConfig def) throws IOException {
        startElement(name);
        endElement(name);
    }
    protected void doWriteStreamResequencerConfig(String name, StreamResequencerConfig def) throws IOException {
        startElement(name);
        doWriteAttribute("comparator", def.getComparator(), null);
        doWriteAttribute("timeout", def.getTimeout(), "1000");
        doWriteAttribute("rejectOld", def.getRejectOld(), null);
        doWriteAttribute("ignoreInvalidExchanges", def.getIgnoreInvalidExchanges(), null);
        doWriteAttribute("deliveryAttemptInterval", def.getDeliveryAttemptInterval(), "1000");
        doWriteAttribute("capacity", def.getCapacity(), "1000");
        endElement(name);
    }
    protected void doWriteASN1DataFormat(String name, ASN1DataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("unmarshalType", def.getUnmarshalTypeName(), null);
        doWriteAttribute("usingIterator", def.getUsingIterator(), null);
        endElement(name);
    }
    protected void doWriteAvroDataFormat(String name, AvroDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("allowUnmarshallType", def.getAllowUnmarshallType(), null);
        doWriteAttribute("include", def.getInclude(), null);
        doWriteAttribute("contentTypeHeader", def.getContentTypeHeader(), "true");
        doWriteAttribute("unmarshalType", def.getUnmarshalTypeName(), null);
        doWriteAttribute("autoDiscoverSchemaResolver", def.getAutoDiscoverSchemaResolver(), "true");
        doWriteAttribute("timezone", def.getTimezone(), null);
        doWriteAttribute("moduleClassNames", def.getModuleClassNames(), null);
        doWriteAttribute("instanceClassName", def.getInstanceClassName(), null);
        doWriteAttribute("collectionType", def.getCollectionTypeName(), null);
        doWriteAttribute("allowJmsType", def.getAllowJmsType(), null);
        doWriteAttribute("jsonView", def.getJsonViewTypeName(), null);
        doWriteAttribute("enableFeatures", def.getEnableFeatures(), null);
        doWriteAttribute("useList", def.getUseList(), null);
        doWriteAttribute("disableFeatures", def.getDisableFeatures(), null);
        doWriteAttribute("moduleRefs", def.getModuleRefs(), null);
        doWriteAttribute("schemaResolver", def.getSchemaResolver(), null);
        doWriteAttribute("useDefaultObjectMapper", def.getUseDefaultObjectMapper(), "true");
        doWriteAttribute("objectMapper", def.getObjectMapper(), null);
        doWriteAttribute("library", toString(def.getLibrary()), "avroJackson");
        doWriteAttribute("autoDiscoverObjectMapper", def.getAutoDiscoverObjectMapper(), null);
        endElement(name);
    }
    protected void doWriteBarcodeDataFormat(String name, BarcodeDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("barcodeFormat", def.getBarcodeFormat(), null);
        doWriteAttribute("width", def.getWidth(), null);
        doWriteAttribute("imageType", def.getImageType(), null);
        doWriteAttribute("height", def.getHeight(), null);
        endElement(name);
    }
    protected void doWriteBase64DataFormat(String name, Base64DataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("urlSafe", def.getUrlSafe(), null);
        doWriteAttribute("lineSeparator", def.getLineSeparator(), null);
        doWriteAttribute("lineLength", def.getLineLength(), "76");
        endElement(name);
    }
    protected void doWriteBeanioDataFormat(String name, BeanioDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("mapping", def.getMapping(), null);
        doWriteAttribute("ignoreUnexpectedRecords", def.getIgnoreUnexpectedRecords(), null);
        doWriteAttribute("ignoreUnidentifiedRecords", def.getIgnoreUnidentifiedRecords(), null);
        doWriteAttribute("beanReaderErrorHandlerType", def.getBeanReaderErrorHandlerType(), null);
        doWriteAttribute("unmarshalSingleObject", def.getUnmarshalSingleObject(), null);
        doWriteAttribute("encoding", def.getEncoding(), null);
        doWriteAttribute("streamName", def.getStreamName(), null);
        doWriteAttribute("ignoreInvalidRecords", def.getIgnoreInvalidRecords(), null);
        endElement(name);
    }
    protected void doWriteBindyDataFormat(String name, BindyDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("unwrapSingleInstance", def.getUnwrapSingleInstance(), "true");
        doWriteAttribute("classType", def.getClassTypeAsString(), null);
        doWriteAttribute("locale", def.getLocale(), null);
        doWriteAttribute("type", def.getType(), null);
        doWriteAttribute("allowEmptyStream", def.getAllowEmptyStream(), "false");
        endElement(name);
    }
    protected void doWriteCBORDataFormat(String name, CBORDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("allowUnmarshallType", def.getAllowUnmarshallType(), "false");
        doWriteAttribute("useDefaultObjectMapper", def.getUseDefaultObjectMapper(), "true");
        doWriteAttribute("prettyPrint", def.getPrettyPrint(), "false");
        doWriteAttribute("objectMapper", def.getObjectMapper(), null);
        doWriteAttribute("unmarshalType", def.getUnmarshalTypeName(), null);
        doWriteAttribute("collectionType", def.getCollectionTypeName(), null);
        doWriteAttribute("allowJmsType", def.getAllowJmsType(), "false");
        doWriteAttribute("enableFeatures", def.getEnableFeatures(), null);
        doWriteAttribute("useList", def.getUseList(), "false");
        doWriteAttribute("disableFeatures", def.getDisableFeatures(), null);
        endElement(name);
    }
    protected void doWriteCryptoDataFormat(String name, CryptoDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("shouldAppendHMAC", def.getShouldAppendHMAC(), "true");
        doWriteAttribute("inline", def.getInline(), "false");
        doWriteAttribute("macAlgorithm", def.getMacAlgorithm(), "HmacSHA1");
        doWriteAttribute("algorithmParameterRef", def.getAlgorithmParameterRef(), null);
        doWriteAttribute("initVectorRef", def.getInitVectorRef(), null);
        doWriteAttribute("cryptoProvider", def.getCryptoProvider(), null);
        doWriteAttribute("keyRef", def.getKeyRef(), null);
        doWriteAttribute("bufferSize", def.getBufferSize(), "4096");
        doWriteAttribute("algorithm", def.getAlgorithm(), null);
        endElement(name);
    }
    protected void doWriteCsvDataFormat(String name, CsvDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("escapeDisabled", def.getEscapeDisabled(), null);
        doWriteAttribute("recordConverterRef", def.getRecordConverterRef(), null);
        doWriteAttribute("ignoreEmptyLines", def.getIgnoreEmptyLines(), null);
        doWriteAttribute("trailingDelimiter", def.getTrailingDelimiter(), null);
        doWriteAttribute("lazyLoad", def.getLazyLoad(), null);
        doWriteAttribute("headerDisabled", def.getHeaderDisabled(), null);
        doWriteAttribute("commentMarkerDisabled", def.getCommentMarkerDisabled(), null);
        doWriteAttribute("skipHeaderRecord", def.getSkipHeaderRecord(), null);
        doWriteAttribute("quote", def.getQuote(), null);
        doWriteAttribute("useMaps", def.getUseMaps(), null);
        doWriteAttribute("trim", def.getTrim(), null);
        doWriteAttribute("delimiter", def.getDelimiter(), null);
        doWriteAttribute("nullString", def.getNullString(), null);
        doWriteAttribute("allowMissingColumnNames", def.getAllowMissingColumnNames(), null);
        doWriteAttribute("escape", def.getEscape(), null);
        doWriteAttribute("nullStringDisabled", def.getNullStringDisabled(), null);
        doWriteAttribute("commentMarker", def.getCommentMarker(), null);
        doWriteAttribute("formatRef", def.getFormatRef(), null);
        doWriteAttribute("quoteMode", def.getQuoteMode(), null);
        doWriteAttribute("formatName", def.getFormatName(), "DEFAULT");
        doWriteAttribute("ignoreSurroundingSpaces", def.getIgnoreSurroundingSpaces(), null);
        doWriteAttribute("quoteDisabled", def.getQuoteDisabled(), null);
        doWriteAttribute("useOrderedMaps", def.getUseOrderedMaps(), null);
        doWriteAttribute("ignoreHeaderCase", def.getIgnoreHeaderCase(), null);
        doWriteAttribute("recordSeparatorDisabled", def.getRecordSeparatorDisabled(), null);
        doWriteAttribute("captureHeaderRecord", def.getCaptureHeaderRecord(), null);
        doWriteAttribute("marshallerFactoryRef", def.getMarshallerFactoryRef(), null);
        doWriteAttribute("recordSeparator", def.getRecordSeparator(), null);
        doWriteList(null, "header", def.getHeader(), this::doWriteString);
        endElement(name);
    }
    protected void doWriteCustomDataFormat(String name, CustomDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("ref", def.getRef(), null);
        endElement(name);
    }
    protected void doWriteDataFormatsDefinition(String name, DataFormatsDefinition def) throws IOException {
        startElement(name);
        doWriteList(null, null, def.getDataFormats(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "ASN1DataFormat" -> doWriteASN1DataFormat("asn1", (ASN1DataFormat) v);
                case "AvroDataFormat" -> doWriteAvroDataFormat("avro", (AvroDataFormat) v);
                case "BarcodeDataFormat" -> doWriteBarcodeDataFormat("barcode", (BarcodeDataFormat) v);
                case "Base64DataFormat" -> doWriteBase64DataFormat("base64", (Base64DataFormat) v);
                case "BeanioDataFormat" -> doWriteBeanioDataFormat("beanio", (BeanioDataFormat) v);
                case "BindyDataFormat" -> doWriteBindyDataFormat("bindy", (BindyDataFormat) v);
                case "CBORDataFormat" -> doWriteCBORDataFormat("cbor", (CBORDataFormat) v);
                case "CryptoDataFormat" -> doWriteCryptoDataFormat("crypto", (CryptoDataFormat) v);
                case "CsvDataFormat" -> doWriteCsvDataFormat("csv", (CsvDataFormat) v);
                case "CustomDataFormat" -> doWriteCustomDataFormat("custom", (CustomDataFormat) v);
                case "DfdlDataFormat" -> doWriteDfdlDataFormat("dfdl", (DfdlDataFormat) v);
                case "FhirJsonDataFormat" -> doWriteFhirJsonDataFormat("fhirJson", (FhirJsonDataFormat) v);
                case "FhirXmlDataFormat" -> doWriteFhirXmlDataFormat("fhirXml", (FhirXmlDataFormat) v);
                case "FlatpackDataFormat" -> doWriteFlatpackDataFormat("flatpack", (FlatpackDataFormat) v);
                case "ForyDataFormat" -> doWriteForyDataFormat("fory", (ForyDataFormat) v);
                case "GrokDataFormat" -> doWriteGrokDataFormat("grok", (GrokDataFormat) v);
                case "GzipDeflaterDataFormat" -> doWriteGzipDeflaterDataFormat("gzipDeflater", (GzipDeflaterDataFormat) v);
                case "HL7DataFormat" -> doWriteHL7DataFormat("hl7", (HL7DataFormat) v);
                case "IcalDataFormat" -> doWriteIcalDataFormat("ical", (IcalDataFormat) v);
                case "Iso8583DataFormat" -> doWriteIso8583DataFormat("iso8583", (Iso8583DataFormat) v);
                case "JacksonXMLDataFormat" -> doWriteJacksonXMLDataFormat("jacksonXml", (JacksonXMLDataFormat) v);
                case "JaxbDataFormat" -> doWriteJaxbDataFormat("jaxb", (JaxbDataFormat) v);
                case "JsonDataFormat" -> doWriteJsonDataFormat("json", (JsonDataFormat) v);
                case "JsonApiDataFormat" -> doWriteJsonApiDataFormat("jsonApi", (JsonApiDataFormat) v);
                case "LZFDataFormat" -> doWriteLZFDataFormat("lzf", (LZFDataFormat) v);
                case "MimeMultipartDataFormat" -> doWriteMimeMultipartDataFormat("mimeMultipart", (MimeMultipartDataFormat) v);
                case "ParquetAvroDataFormat" -> doWriteParquetAvroDataFormat("parquetAvro", (ParquetAvroDataFormat) v);
                case "PGPDataFormat" -> doWritePGPDataFormat("pgp", (PGPDataFormat) v);
                case "ProtobufDataFormat" -> doWriteProtobufDataFormat("protobuf", (ProtobufDataFormat) v);
                case "RssDataFormat" -> doWriteRssDataFormat("rss", (RssDataFormat) v);
                case "SmooksDataFormat" -> doWriteSmooksDataFormat("smooks", (SmooksDataFormat) v);
                case "SoapDataFormat" -> doWriteSoapDataFormat("soap", (SoapDataFormat) v);
                case "SwiftMtDataFormat" -> doWriteSwiftMtDataFormat("swiftMt", (SwiftMtDataFormat) v);
                case "SwiftMxDataFormat" -> doWriteSwiftMxDataFormat("swiftMx", (SwiftMxDataFormat) v);
                case "SyslogDataFormat" -> doWriteSyslogDataFormat("syslog", (SyslogDataFormat) v);
                case "TarFileDataFormat" -> doWriteTarFileDataFormat("tarFile", (TarFileDataFormat) v);
                case "ThriftDataFormat" -> doWriteThriftDataFormat("thrift", (ThriftDataFormat) v);
                case "TidyMarkupDataFormat" -> doWriteTidyMarkupDataFormat("tidyMarkup", (TidyMarkupDataFormat) v);
                case "UniVocityCsvDataFormat" -> doWriteUniVocityCsvDataFormat("univocityCsv", (UniVocityCsvDataFormat) v);
                case "UniVocityFixedDataFormat" -> doWriteUniVocityFixedDataFormat("univocityFixed", (UniVocityFixedDataFormat) v);
                case "UniVocityTsvDataFormat" -> doWriteUniVocityTsvDataFormat("univocityTsv", (UniVocityTsvDataFormat) v);
                case "XMLSecurityDataFormat" -> doWriteXMLSecurityDataFormat("xmlSecurity", (XMLSecurityDataFormat) v);
                case "YAMLDataFormat" -> doWriteYAMLDataFormat("yaml", (YAMLDataFormat) v);
                case "ZipDeflaterDataFormat" -> doWriteZipDeflaterDataFormat("zipDeflater", (ZipDeflaterDataFormat) v);
                case "ZipFileDataFormat" -> doWriteZipFileDataFormat("zipFile", (ZipFileDataFormat) v);
            }
        });
        endElement(name);
    }
    protected void doWriteDfdlDataFormat(String name, DfdlDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("rootElement", def.getRootElement(), null);
        doWriteAttribute("schemaUri", def.getSchemaUri(), null);
        doWriteAttribute("rootNamespace", def.getRootNamespace(), null);
        endElement(name);
    }
    protected void doWriteFhirDataformatAttributes(FhirDataformat def) throws IOException {
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("contentTypeHeader", def.getContentTypeHeader(), "true");
        doWriteAttribute("dontStripVersionsFromReferencesAtPaths", def.getDontStripVersionsFromReferencesAtPaths(), null);
        doWriteAttribute("parserOptions", def.getParserOptions(), null);
        doWriteAttribute("prettyPrint", def.getPrettyPrint(), null);
        doWriteAttribute("dontEncodeElements", def.getDontEncodeElements(), null);
        doWriteAttribute("summaryMode", def.getSummaryMode(), null);
        doWriteAttribute("forceResourceId", def.getForceResourceId(), null);
        doWriteAttribute("encodeElementsAppliesToChildResourcesOnly", def.getEncodeElementsAppliesToChildResourcesOnly(), null);
        doWriteAttribute("parserErrorHandler", def.getParserErrorHandler(), null);
        doWriteAttribute("serverBaseUrl", def.getServerBaseUrl(), null);
        doWriteAttribute("fhirVersion", def.getFhirVersion(), "R4");
        doWriteAttribute("suppressNarratives", def.getSuppressNarratives(), null);
        doWriteAttribute("fhirContext", def.getFhirContext(), null);
        doWriteAttribute("stripVersionsFromReferences", def.getStripVersionsFromReferences(), null);
        doWriteAttribute("encodeElements", def.getEncodeElements(), null);
        doWriteAttribute("preferTypes", def.getPreferTypes(), null);
        doWriteAttribute("overrideResourceIdWithBundleEntryFullUrl", def.getOverrideResourceIdWithBundleEntryFullUrl(), null);
        doWriteAttribute("omitResourceId", def.getOmitResourceId(), null);
    }
    protected void doWriteFhirDataformat(String name, FhirDataformat def) throws IOException {
        startElement(name);
        doWriteFhirDataformatAttributes(def);
        endElement(name);
    }
    protected void doWriteFhirJsonDataFormat(String name, FhirJsonDataFormat def) throws IOException {
        startElement(name);
        doWriteFhirDataformatAttributes(def);
        endElement(name);
    }
    protected void doWriteFhirXmlDataFormat(String name, FhirXmlDataFormat def) throws IOException {
        startElement(name);
        doWriteFhirDataformatAttributes(def);
        endElement(name);
    }
    protected void doWriteFlatpackDataFormat(String name, FlatpackDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("allowShortLines", def.getAllowShortLines(), null);
        doWriteAttribute("delimiter", def.getDelimiter(), ",");
        doWriteAttribute("fixed", def.getFixed(), null);
        doWriteAttribute("definition", def.getDefinition(), null);
        doWriteAttribute("ignoreFirstRecord", def.getIgnoreFirstRecord(), "true");
        doWriteAttribute("parserFactoryRef", def.getParserFactoryRef(), null);
        doWriteAttribute("textQualifier", def.getTextQualifier(), null);
        doWriteAttribute("ignoreExtraColumns", def.getIgnoreExtraColumns(), null);
        endElement(name);
    }
    protected void doWriteForyDataFormat(String name, ForyDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("allowAutoWiredFory", def.getAllowAutoWiredFory(), "true");
        doWriteAttribute("unmarshalType", def.getUnmarshalTypeName(), null);
        doWriteAttribute("threadSafe", def.getThreadSafe(), "true");
        doWriteAttribute("requireClassRegistration", def.getRequireClassRegistration(), "true");
        endElement(name);
    }
    protected void doWriteGrokDataFormat(String name, GrokDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("flattened", def.getFlattened(), null);
        doWriteAttribute("namedOnly", def.getNamedOnly(), null);
        doWriteAttribute("pattern", def.getPattern(), null);
        doWriteAttribute("allowMultipleMatchesPerLine", def.getAllowMultipleMatchesPerLine(), "true");
        endElement(name);
    }
    protected void doWriteGzipDeflaterDataFormat(String name, GzipDeflaterDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        endElement(name);
    }
    protected void doWriteHL7DataFormat(String name, HL7DataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("validate", def.getValidate(), "true");
        endElement(name);
    }
    protected void doWriteIcalDataFormat(String name, IcalDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("validating", def.getValidating(), null);
        endElement(name);
    }
    protected void doWriteIso8583DataFormat(String name, Iso8583DataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("allowAutoWiredMessageFormat", def.getAllowAutoWiredMessageFormat(), "true");
        doWriteAttribute("isoType", def.getIsoType(), null);
        doWriteAttribute("configFile", def.getConfigFile(), "j8583-config.xml");
        endElement(name);
    }
    protected void doWriteJacksonXMLDataFormat(String name, JacksonXMLDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("include", def.getInclude(), null);
        doWriteAttribute("allowUnmarshallType", def.getAllowUnmarshallType(), null);
        doWriteAttribute("contentTypeHeader", def.getContentTypeHeader(), "true");
        doWriteAttribute("prettyPrint", def.getPrettyPrint(), null);
        doWriteAttribute("unmarshalType", def.getUnmarshalTypeName(), null);
        doWriteAttribute("timezone", def.getTimezone(), null);
        doWriteAttribute("moduleClassNames", def.getModuleClassNames(), null);
        doWriteAttribute("collectionType", def.getCollectionTypeName(), null);
        doWriteAttribute("allowJmsType", def.getAllowJmsType(), null);
        doWriteAttribute("jsonView", def.getJsonViewTypeName(), null);
        doWriteAttribute("enableFeatures", def.getEnableFeatures(), null);
        doWriteAttribute("useList", def.getUseList(), null);
        doWriteAttribute("maxStringLength", def.getMaxStringLength(), null);
        doWriteAttribute("disableFeatures", def.getDisableFeatures(), null);
        doWriteAttribute("moduleRefs", def.getModuleRefs(), null);
        doWriteAttribute("enableJaxbAnnotationModule", def.getEnableJaxbAnnotationModule(), null);
        doWriteAttribute("xmlMapper", def.getXmlMapper(), null);
        endElement(name);
    }
    protected void doWriteJaxbDataFormat(String name, JaxbDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("accessExternalSchemaProtocols", def.getAccessExternalSchemaProtocols(), "false");
        doWriteAttribute("schema", def.getSchema(), null);
        doWriteAttribute("contentTypeHeader", def.getContentTypeHeader(), "true");
        doWriteAttribute("prettyPrint", def.getPrettyPrint(), "true");
        doWriteAttribute("schemaLocation", def.getSchemaLocation(), null);
        doWriteAttribute("contextPathIsClassName", def.getContextPathIsClassName(), null);
        doWriteAttribute("ignoreJAXBElement", def.getIgnoreJAXBElement(), "true");
        doWriteAttribute("xmlStreamWriterWrapper", def.getXmlStreamWriterWrapper(), null);
        doWriteAttribute("schemaSeverityLevel", def.getSchemaSeverityLevel(), "0");
        doWriteAttribute("contextPath", def.getContextPath(), null);
        doWriteAttribute("noNamespaceSchemaLocation", def.getNoNamespaceSchemaLocation(), null);
        doWriteAttribute("encoding", def.getEncoding(), null);
        doWriteAttribute("fragment", def.getFragment(), null);
        doWriteAttribute("filterNonXmlChars", def.getFilterNonXmlChars(), null);
        doWriteAttribute("mustBeJAXBElement", def.getMustBeJAXBElement(), null);
        doWriteAttribute("objectFactory", def.getObjectFactory(), "true");
        doWriteAttribute("namespacePrefixRef", def.getNamespacePrefixRef(), null);
        doWriteAttribute("partClass", def.getPartClass(), null);
        doWriteAttribute("jaxbProviderProperties", def.getJaxbProviderProperties(), null);
        doWriteAttribute("partNamespace", def.getPartNamespace(), null);
        endElement(name);
    }
    protected void doWriteJsonApiDataFormat(String name, JsonApiDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("dataFormatTypes", def.getDataFormatTypes(), null);
        doWriteAttribute("mainFormatType", def.getMainFormatType(), null);
        endElement(name);
    }
    protected void doWriteJsonDataFormat(String name, JsonDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("dateFormatPattern", def.getDateFormatPattern(), null);
        doWriteAttribute("contentTypeHeader", def.getContentTypeHeader(), "true");
        doWriteAttribute("timezone", def.getTimezone(), null);
        doWriteAttribute("moduleClassNames", def.getModuleClassNames(), null);
        doWriteAttribute("collectionType", def.getCollectionTypeName(), null);
        doWriteAttribute("allowJmsType", def.getAllowJmsType(), null);
        doWriteAttribute("jsonView", def.getJsonViewTypeName(), null);
        doWriteAttribute("enableFeatures", def.getEnableFeatures(), null);
        doWriteAttribute("library", toString(def.getLibrary()), "Jackson");
        doWriteAttribute("autoDiscoverObjectMapper", def.getAutoDiscoverObjectMapper(), "false");
        doWriteAttribute("allowUnmarshallType", def.getAllowUnmarshallType(), null);
        doWriteAttribute("include", def.getInclude(), null);
        doWriteAttribute("prettyPrint", def.getPrettyPrint(), null);
        doWriteAttribute("unmarshalType", def.getUnmarshalTypeName(), null);
        doWriteAttribute("autoDiscoverSchemaResolver", def.getAutoDiscoverSchemaResolver(), "true");
        doWriteAttribute("useList", def.getUseList(), null);
        doWriteAttribute("maxStringLength", def.getMaxStringLength(), null);
        doWriteAttribute("disableFeatures", def.getDisableFeatures(), null);
        doWriteAttribute("moduleRefs", def.getModuleRefs(), null);
        doWriteAttribute("schemaResolver", def.getSchemaResolver(), null);
        doWriteAttribute("combineUnicodeSurrogates", def.getCombineUnicodeSurrogates(), null);
        doWriteAttribute("useDefaultObjectMapper", def.getUseDefaultObjectMapper(), "true");
        doWriteAttribute("objectMapper", def.getObjectMapper(), null);
        doWriteAttribute("namingStrategy", def.getNamingStrategy(), null);
        endElement(name);
    }
    protected void doWriteLZFDataFormat(String name, LZFDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("usingParallelCompression", def.getUsingParallelCompression(), null);
        endElement(name);
    }
    protected void doWriteMimeMultipartDataFormat(String name, MimeMultipartDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("headersInline", def.getHeadersInline(), null);
        doWriteAttribute("multipartWithoutAttachment", def.getMultipartWithoutAttachment(), null);
        doWriteAttribute("multipartSubType", def.getMultipartSubType(), "mixed");
        doWriteAttribute("includeHeaders", def.getIncludeHeaders(), null);
        doWriteAttribute("binaryContent", def.getBinaryContent(), null);
        endElement(name);
    }
    protected void doWritePGPDataFormat(String name, PGPDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("armored", def.getArmored(), "false");
        doWriteAttribute("signaturePassword", def.getSignaturePassword(), null);
        doWriteAttribute("signatureKeyRing", def.getSignatureKeyRing(), null);
        doWriteAttribute("signatureVerificationOption", def.getSignatureVerificationOption(), null);
        doWriteAttribute("keyFileName", def.getKeyFileName(), null);
        doWriteAttribute("signatureKeyUserid", def.getSignatureKeyUserid(), null);
        doWriteAttribute("integrity", def.getIntegrity(), "true");
        doWriteAttribute("password", def.getPassword(), null);
        doWriteAttribute("provider", def.getProvider(), null);
        doWriteAttribute("compressionAlgorithm", def.getCompressionAlgorithm(), null);
        doWriteAttribute("keyUserid", def.getKeyUserid(), null);
        doWriteAttribute("signatureKeyFileName", def.getSignatureKeyFileName(), null);
        doWriteAttribute("hashAlgorithm", def.getHashAlgorithm(), null);
        doWriteAttribute("algorithm", def.getAlgorithm(), null);
        endElement(name);
    }
    protected void doWriteParquetAvroDataFormat(String name, ParquetAvroDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("compressionCodecName", def.getCompressionCodecName(), "GZIP");
        doWriteAttribute("unmarshalType", def.getUnmarshalTypeName(), null);
        doWriteAttribute("lazyLoad", def.getLazyLoad(), null);
        endElement(name);
    }
    protected void doWriteProtobufDataFormat(String name, ProtobufDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("contentTypeHeader", def.getContentTypeHeader(), "true");
        doWriteAttribute("contentTypeFormat", def.getContentTypeFormat(), "native");
        doWriteAttribute("timezone", def.getTimezone(), null);
        doWriteAttribute("moduleClassNames", def.getModuleClassNames(), null);
        doWriteAttribute("collectionType", def.getCollectionTypeName(), null);
        doWriteAttribute("allowJmsType", def.getAllowJmsType(), null);
        doWriteAttribute("jsonView", def.getJsonViewTypeName(), null);
        doWriteAttribute("enableFeatures", def.getEnableFeatures(), null);
        doWriteAttribute("library", toString(def.getLibrary()), "GoogleProtobuf");
        doWriteAttribute("autoDiscoverObjectMapper", def.getAutoDiscoverObjectMapper(), "false");
        doWriteAttribute("allowUnmarshallType", def.getAllowUnmarshallType(), null);
        doWriteAttribute("include", def.getInclude(), null);
        doWriteAttribute("unmarshalType", def.getUnmarshalTypeName(), null);
        doWriteAttribute("autoDiscoverSchemaResolver", def.getAutoDiscoverSchemaResolver(), "true");
        doWriteAttribute("instanceClass", def.getInstanceClass(), null);
        doWriteAttribute("useList", def.getUseList(), null);
        doWriteAttribute("disableFeatures", def.getDisableFeatures(), null);
        doWriteAttribute("moduleRefs", def.getModuleRefs(), null);
        doWriteAttribute("schemaResolver", def.getSchemaResolver(), null);
        doWriteAttribute("useDefaultObjectMapper", def.getUseDefaultObjectMapper(), "true");
        doWriteAttribute("objectMapper", def.getObjectMapper(), null);
        endElement(name);
    }
    protected void doWriteRssDataFormat(String name, RssDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        endElement(name);
    }
    protected void doWriteSmooksDataFormat(String name, SmooksDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("smooksConfig", def.getSmooksConfig(), null);
        endElement(name);
    }
    protected void doWriteSoapDataFormat(String name, SoapDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("schema", def.getSchema(), null);
        doWriteAttribute("namespacePrefixRef", def.getNamespacePrefixRef(), null);
        doWriteAttribute("elementNameStrategyRef", def.getElementNameStrategyRef(), null);
        doWriteAttribute("contextPath", def.getContextPath(), null);
        doWriteAttribute("encoding", def.getEncoding(), null);
        doWriteAttribute("version", def.getVersion(), "1.1");
        endElement(name);
    }
    protected void doWriteSwiftMtDataFormat(String name, SwiftMtDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("writeInJson", def.getWriteInJson(), null);
        endElement(name);
    }
    protected void doWriteSwiftMxDataFormat(String name, SwiftMxDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("readMessageId", def.getReadMessageId(), null);
        doWriteAttribute("writeInJson", def.getWriteInJson(), null);
        doWriteAttribute("writeConfigRef", def.getWriteConfigRef(), null);
        doWriteAttribute("readConfigRef", def.getReadConfigRef(), null);
        endElement(name);
    }
    protected void doWriteSyslogDataFormat(String name, SyslogDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        endElement(name);
    }
    protected void doWriteTarFileDataFormat(String name, TarFileDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("maxDecompressedSize", def.getMaxDecompressedSize(), "1073741824");
        doWriteAttribute("usingIterator", def.getUsingIterator(), null);
        doWriteAttribute("preservePathElements", def.getPreservePathElements(), null);
        doWriteAttribute("allowEmptyDirectory", def.getAllowEmptyDirectory(), null);
        endElement(name);
    }
    protected void doWriteThriftDataFormat(String name, ThriftDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("contentTypeHeader", def.getContentTypeHeader(), "true");
        doWriteAttribute("contentTypeFormat", def.getContentTypeFormat(), "binary");
        doWriteAttribute("instanceClass", def.getInstanceClass(), null);
        endElement(name);
    }
    protected void doWriteTidyMarkupDataFormat(String name, TidyMarkupDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("omitXmlDeclaration", def.getOmitXmlDeclaration(), null);
        doWriteAttribute("dataObjectType", def.getDataObjectTypeName(), "org.w3c.dom.Node");
        endElement(name);
    }
    protected void doWriteUniVocityAbstractDataFormatAttributes(UniVocityAbstractDataFormat def) throws IOException {
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("headerExtractionEnabled", def.getHeaderExtractionEnabled(), null);
        doWriteAttribute("skipEmptyLines", def.getSkipEmptyLines(), "true");
        doWriteAttribute("asMap", def.getAsMap(), null);
        doWriteAttribute("ignoreLeadingWhitespaces", def.getIgnoreLeadingWhitespaces(), "true");
        doWriteAttribute("lineSeparator", def.getLineSeparator(), null);
        doWriteAttribute("ignoreTrailingWhitespaces", def.getIgnoreTrailingWhitespaces(), "true");
        doWriteAttribute("lazyLoad", def.getLazyLoad(), null);
        doWriteAttribute("nullValue", def.getNullValue(), null);
        doWriteAttribute("normalizedLineSeparator", def.getNormalizedLineSeparator(), null);
        doWriteAttribute("emptyValue", def.getEmptyValue(), null);
        doWriteAttribute("headersDisabled", def.getHeadersDisabled(), null);
        doWriteAttribute("comment", def.getComment(), "#");
        doWriteAttribute("numberOfRecordsToRead", def.getNumberOfRecordsToRead(), null);
    }
    protected void doWriteUniVocityAbstractDataFormatElements(UniVocityAbstractDataFormat def) throws IOException {
        doWriteList(null, null, def.getHeaders(), this::doWriteUniVocityHeaderRef);
    }
    protected void doWriteUniVocityAbstractDataFormat(String name, UniVocityAbstractDataFormat def) throws IOException {
        startElement(name);
        doWriteUniVocityAbstractDataFormatAttributes(def);
        doWriteUniVocityAbstractDataFormatElements(def);
        endElement(name);
    }
    protected void doWriteUniVocityCsvDataFormat(String name, UniVocityCsvDataFormat def) throws IOException {
        startElement(name);
        doWriteUniVocityAbstractDataFormatAttributes(def);
        doWriteAttribute("quoteEscape", def.getQuoteEscape(), "\"");
        doWriteAttribute("quote", def.getQuote(), "\"");
        doWriteAttribute("delimiter", def.getDelimiter(), ",");
        doWriteAttribute("quoteAllFields", def.getQuoteAllFields(), null);
        doWriteUniVocityAbstractDataFormatElements(def);
        endElement(name);
    }
    protected void doWriteUniVocityFixedDataFormat(String name, UniVocityFixedDataFormat def) throws IOException {
        startElement(name);
        doWriteUniVocityAbstractDataFormatAttributes(def);
        doWriteAttribute("recordEndsOnNewline", def.getRecordEndsOnNewline(), null);
        doWriteAttribute("padding", def.getPadding(), null);
        doWriteAttribute("skipTrailingCharsUntilNewline", def.getSkipTrailingCharsUntilNewline(), null);
        doWriteUniVocityAbstractDataFormatElements(def);
        endElement(name);
    }
    protected void doWriteUniVocityHeader(String name, UniVocityHeader def) throws IOException {
        startElement(name);
        doWriteAttribute("length", def.getLength(), null);
        doWriteValue(def.getName());
        endElement(name);
    }
    protected void doWriteUniVocityTsvDataFormat(String name, UniVocityTsvDataFormat def) throws IOException {
        startElement(name);
        doWriteUniVocityAbstractDataFormatAttributes(def);
        doWriteAttribute("escapeChar", def.getEscapeChar(), "\\");
        doWriteUniVocityAbstractDataFormatElements(def);
        endElement(name);
    }
    protected void doWriteXMLSecurityDataFormat(String name, XMLSecurityDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("addKeyValueForEncryptedKey", def.getAddKeyValueForEncryptedKey(), "true");
        doWriteAttribute("keyCipherAlgorithm", def.getKeyCipherAlgorithm(), "RSA_OAEP");
        doWriteAttribute("recipientKeyAlias", def.getRecipientKeyAlias(), null);
        doWriteAttribute("keyOrTrustStoreParametersRef", def.getKeyOrTrustStoreParametersRef(), null);
        doWriteAttribute("digestAlgorithm", def.getDigestAlgorithm(), "SHA1");
        doWriteAttribute("mgfAlgorithm", def.getMgfAlgorithm(), "MGF1_SHA1");
        doWriteAttribute("secureTagContents", def.getSecureTagContents(), null);
        doWriteAttribute("passPhraseByte", toString(def.getPassPhraseByte()), null);
        doWriteAttribute("keyPassword", def.getKeyPassword(), null);
        doWriteAttribute("secureTag", def.getSecureTag(), null);
        doWriteAttribute("xmlCipherAlgorithm", def.getXmlCipherAlgorithm(), "AES-256-GCM");
        doWriteAttribute("passPhrase", def.getPassPhrase(), null);
        endElement(name);
    }
    protected void doWriteYAMLDataFormat(String name, YAMLDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("resolver", def.getResolver(), null);
        doWriteAttribute("unmarshalType", def.getUnmarshalTypeName(), null);
        doWriteAttribute("prettyFlow", def.getPrettyFlow(), null);
        doWriteAttribute("allowAnyType", def.getAllowAnyType(), null);
        doWriteAttribute("representer", def.getRepresenter(), null);
        doWriteAttribute("constructor", def.getConstructor(), null);
        doWriteAttribute("library", toString(def.getLibrary()), "SnakeYAML");
        doWriteAttribute("maxAliasesForCollections", def.getMaxAliasesForCollections(), "50");
        doWriteAttribute("dumperOptions", def.getDumperOptions(), null);
        doWriteAttribute("useApplicationContextClassLoader", def.getUseApplicationContextClassLoader(), "true");
        doWriteAttribute("allowRecursiveKeys", def.getAllowRecursiveKeys(), null);
        doWriteList(null, "typeFilter", def.getTypeFilters(), this::doWriteYAMLTypeFilterDefinition);
        endElement(name);
    }
    protected void doWriteYAMLTypeFilterDefinition(String name, YAMLTypeFilterDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("type", def.getType(), null);
        doWriteAttribute("value", def.getValue(), null);
        endElement(name);
    }
    protected void doWriteZipDeflaterDataFormat(String name, ZipDeflaterDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("compressionLevel", def.getCompressionLevel(), "-1");
        endElement(name);
    }
    protected void doWriteZipFileDataFormat(String name, ZipFileDataFormat def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("maxDecompressedSize", def.getMaxDecompressedSize(), "1073741824");
        doWriteAttribute("usingIterator", def.getUsingIterator(), null);
        doWriteAttribute("preservePathElements", def.getPreservePathElements(), null);
        doWriteAttribute("allowEmptyDirectory", def.getAllowEmptyDirectory(), null);
        endElement(name);
    }
    protected void doWriteDeadLetterChannelDefinition(String name, DeadLetterChannelDefinition def) throws IOException {
        startElement(name);
        doWriteDefaultErrorHandlerDefinitionAttributes(def);
        doWriteAttribute("deadLetterHandleNewException", def.getDeadLetterHandleNewException(), "true");
        doWriteAttribute("deadLetterUri", def.getDeadLetterUri(), null);
        doWriteDefaultErrorHandlerDefinitionElements(def);
        endElement(name);
    }
    protected void doWriteDefaultErrorHandlerDefinitionAttributes(DefaultErrorHandlerDefinition def) throws IOException {
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("executorServiceRef", def.getExecutorServiceRef(), null);
        doWriteAttribute("level", def.getLevel(), "ERROR");
        doWriteAttribute("loggerRef", def.getLoggerRef(), null);
        doWriteAttribute("useOriginalMessage", def.getUseOriginalMessage(), null);
        doWriteAttribute("onRedeliveryRef", def.getOnRedeliveryRef(), null);
        doWriteAttribute("retryWhileRef", def.getRetryWhileRef(), null);
        doWriteAttribute("logName", def.getLogName(), null);
        doWriteAttribute("useOriginalBody", def.getUseOriginalBody(), null);
        doWriteAttribute("onPrepareFailureRef", def.getOnPrepareFailureRef(), null);
        doWriteAttribute("onExceptionOccurredRef", def.getOnExceptionOccurredRef(), null);
        doWriteAttribute("redeliveryPolicyRef", def.getRedeliveryPolicyRef(), null);
    }
    protected void doWriteDefaultErrorHandlerDefinitionElements(DefaultErrorHandlerDefinition def) throws IOException {
        doWriteElement("redeliveryPolicy", def.getRedeliveryPolicy(), this::doWriteRedeliveryPolicyDefinition);
    }
    protected void doWriteDefaultErrorHandlerDefinition(String name, DefaultErrorHandlerDefinition def) throws IOException {
        startElement(name);
        doWriteDefaultErrorHandlerDefinitionAttributes(def);
        doWriteDefaultErrorHandlerDefinitionElements(def);
        endElement(name);
    }
    protected void doWriteJtaTransactionErrorHandlerDefinition(String name, JtaTransactionErrorHandlerDefinition def) throws IOException {
        startElement(name);
        doWriteTransactionErrorHandlerDefinitionAttributes(def);
        doWriteDefaultErrorHandlerDefinitionElements(def);
        endElement(name);
    }
    protected void doWriteNoErrorHandlerDefinition(String name, NoErrorHandlerDefinition def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        endElement(name);
    }
    protected void doWriteRefErrorHandlerDefinition(String name, RefErrorHandlerDefinition def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("ref", def.getRef(), null);
        endElement(name);
    }
    protected void doWriteSpringTransactionErrorHandlerDefinition(String name, SpringTransactionErrorHandlerDefinition def) throws IOException {
        startElement(name);
        doWriteTransactionErrorHandlerDefinitionAttributes(def);
        doWriteDefaultErrorHandlerDefinitionElements(def);
        endElement(name);
    }
    protected void doWriteTransactionErrorHandlerDefinitionAttributes(TransactionErrorHandlerDefinition def) throws IOException {
        doWriteDefaultErrorHandlerDefinitionAttributes(def);
        doWriteAttribute("rollbackLoggingLevel", def.getRollbackLoggingLevel(), "WARN");
        doWriteAttribute("transactedPolicyRef", def.getTransactedPolicyRef(), null);
    }
    protected void doWriteTransactionErrorHandlerDefinition(String name, TransactionErrorHandlerDefinition def) throws IOException {
        startElement(name);
        doWriteTransactionErrorHandlerDefinitionAttributes(def);
        doWriteDefaultErrorHandlerDefinitionElements(def);
        endElement(name);
    }
    protected void doWriteCSimpleExpression(String name, CSimpleExpression def) throws IOException {
        startElement(name);
        doWriteTypedExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteConstantExpression(String name, ConstantExpression def) throws IOException {
        startElement(name);
        doWriteTypedExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteDatasonnetExpression(String name, DatasonnetExpression def) throws IOException {
        startElement(name);
        doWriteSingleInputTypedExpressionDefinitionAttributes(def);
        doWriteAttribute("outputMediaType", def.getOutputMediaType(), null);
        doWriteAttribute("bodyMediaType", def.getBodyMediaType(), null);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteExchangePropertyExpression(String name, ExchangePropertyExpression def) throws IOException {
        startElement(name);
        doWriteExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteExpressionDefinitionAttributes(ExpressionDefinition def) throws IOException {
        doWriteAttribute("trim", def.getTrim(), "true");
        doWriteAttribute("id", def.getId(), null);
    }
    protected void doWriteExpressionDefinition(String name, ExpressionDefinition def) throws IOException {
        startElement(name);
        doWriteExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteGroovyExpression(String name, GroovyExpression def) throws IOException {
        startElement(name);
        doWriteTypedExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteHeaderExpression(String name, HeaderExpression def) throws IOException {
        startElement(name);
        doWriteExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteHl7TerserExpression(String name, Hl7TerserExpression def) throws IOException {
        startElement(name);
        doWriteSingleInputTypedExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteJavaExpression(String name, JavaExpression def) throws IOException {
        startElement(name);
        doWriteTypedExpressionDefinitionAttributes(def);
        doWriteAttribute("preCompile", def.getPreCompile(), "true");
        doWriteAttribute("singleQuotes", def.getSingleQuotes(), "true");
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteJavaScriptExpression(String name, JavaScriptExpression def) throws IOException {
        startElement(name);
        doWriteTypedExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteJoorExpression(String name, JoorExpression def) throws IOException {
        startElement(name);
        doWriteTypedExpressionDefinitionAttributes(def);
        doWriteAttribute("preCompile", def.getPreCompile(), "true");
        doWriteAttribute("singleQuotes", def.getSingleQuotes(), "true");
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteJqExpression(String name, JqExpression def) throws IOException {
        startElement(name);
        doWriteSingleInputTypedExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteJsonPathExpression(String name, JsonPathExpression def) throws IOException {
        startElement(name);
        doWriteSingleInputTypedExpressionDefinitionAttributes(def);
        doWriteAttribute("unpackArray", def.getUnpackArray(), "false");
        doWriteAttribute("writeAsString", def.getWriteAsString(), "false");
        doWriteAttribute("allowSimple", def.getAllowSimple(), "true");
        doWriteAttribute("suppressExceptions", def.getSuppressExceptions(), "false");
        doWriteAttribute("allowEasyPredicate", def.getAllowEasyPredicate(), "true");
        doWriteAttribute("option", def.getOption(), null);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteLanguageExpression(String name, LanguageExpression def) throws IOException {
        startElement(name);
        doWriteExpressionDefinitionAttributes(def);
        doWriteAttribute("language", def.getLanguage(), null);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteMethodCallExpression(String name, MethodCallExpression def) throws IOException {
        startElement(name);
        doWriteTypedExpressionDefinitionAttributes(def);
        doWriteAttribute("ref", def.getRef(), null);
        doWriteAttribute("method", def.getMethod(), null);
        doWriteAttribute("scope", def.getScope(), "Singleton");
        doWriteAttribute("beanType", def.getBeanTypeName(), null);
        doWriteAttribute("validate", def.getValidate(), "true");
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteMvelExpression(String name, MvelExpression def) throws IOException {
        startElement(name);
        doWriteTypedExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteNamespaceAwareExpressionElements(NamespaceAwareExpression def) throws IOException {
        doWriteList(null, "namespace", def.getNamespace(), this::doWritePropertyDefinition);
    }
    protected void doWriteNamespaceAwareExpression(String name, NamespaceAwareExpression def) throws IOException {
        startElement(name);
        doWriteSingleInputTypedExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        doWriteNamespaceAwareExpressionElements(def);
        endElement(name);
    }
    protected void doWriteOgnlExpression(String name, OgnlExpression def) throws IOException {
        startElement(name);
        doWriteTypedExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWritePythonExpression(String name, PythonExpression def) throws IOException {
        startElement(name);
        doWriteTypedExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteRefExpression(String name, RefExpression def) throws IOException {
        startElement(name);
        doWriteTypedExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteSimpleExpression(String name, SimpleExpression def) throws IOException {
        startElement(name);
        doWriteTypedExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteSingleInputTypedExpressionDefinitionAttributes(SingleInputTypedExpressionDefinition def) throws IOException {
        doWriteTypedExpressionDefinitionAttributes(def);
        doWriteAttribute("source", def.getSource(), null);
    }
    protected void doWriteSingleInputTypedExpressionDefinition(String name, SingleInputTypedExpressionDefinition def) throws IOException {
        startElement(name);
        doWriteSingleInputTypedExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteSpELExpression(String name, SpELExpression def) throws IOException {
        startElement(name);
        doWriteTypedExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteTokenizerExpression(String name, TokenizerExpression def) throws IOException {
        startElement(name);
        doWriteSingleInputTypedExpressionDefinitionAttributes(def);
        doWriteAttribute("regex", def.getRegex(), null);
        doWriteAttribute("endToken", def.getEndToken(), null);
        doWriteAttribute("includeTokens", def.getIncludeTokens(), null);
        doWriteAttribute("skipFirst", def.getSkipFirst(), null);
        doWriteAttribute("xml", def.getXml(), null);
        doWriteAttribute("inheritNamespaceTagName", def.getInheritNamespaceTagName(), null);
        doWriteAttribute("groupDelimiter", def.getGroupDelimiter(), null);
        doWriteAttribute("group", def.getGroup(), null);
        doWriteAttribute("token", def.getToken(), null);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteTypedExpressionDefinitionAttributes(TypedExpressionDefinition def) throws IOException {
        doWriteExpressionDefinitionAttributes(def);
        doWriteAttribute("resultType", def.getResultTypeName(), null);
    }
    protected void doWriteTypedExpressionDefinition(String name, TypedExpressionDefinition def) throws IOException {
        startElement(name);
        doWriteTypedExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteVariableExpression(String name, VariableExpression def) throws IOException {
        startElement(name);
        doWriteExpressionDefinitionAttributes(def);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteWasmExpression(String name, WasmExpression def) throws IOException {
        startElement(name);
        doWriteTypedExpressionDefinitionAttributes(def);
        doWriteAttribute("module", def.getModule(), null);
        doWriteValue(def.getExpression());
        endElement(name);
    }
    protected void doWriteXMLTokenizerExpression(String name, XMLTokenizerExpression def) throws IOException {
        startElement(name);
        doWriteSingleInputTypedExpressionDefinitionAttributes(def);
        doWriteAttribute("mode", def.getMode(), "i");
        doWriteAttribute("group", def.getGroup(), null);
        doWriteValue(def.getExpression());
        doWriteNamespaceAwareExpressionElements(def);
        endElement(name);
    }
    protected void doWriteXPathExpression(String name, XPathExpression def) throws IOException {
        startElement(name);
        doWriteSingleInputTypedExpressionDefinitionAttributes(def);
        doWriteAttribute("preCompile", def.getPreCompile(), "true");
        doWriteAttribute("objectModel", def.getObjectModel(), null);
        doWriteAttribute("logNamespaces", def.getLogNamespaces(), null);
        doWriteAttribute("threadSafety", def.getThreadSafety(), null);
        doWriteAttribute("factoryRef", def.getFactoryRef(), null);
        doWriteAttribute("resultQName", def.getResultQName(), "NODESET");
        doWriteAttribute("saxon", def.getSaxon(), null);
        doWriteAttribute("documentType", def.getDocumentTypeName(), null);
        doWriteValue(def.getExpression());
        doWriteNamespaceAwareExpressionElements(def);
        endElement(name);
    }
    protected void doWriteXQueryExpression(String name, XQueryExpression def) throws IOException {
        startElement(name);
        doWriteSingleInputTypedExpressionDefinitionAttributes(def);
        doWriteAttribute("configurationRef", def.getConfigurationRef(), null);
        doWriteValue(def.getExpression());
        doWriteNamespaceAwareExpressionElements(def);
        endElement(name);
    }
    protected void doWriteCustomLoadBalancerDefinition(String name, CustomLoadBalancerDefinition def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("ref", def.getRef(), null);
        endElement(name);
    }
    protected void doWriteFailoverLoadBalancerDefinition(String name, FailoverLoadBalancerDefinition def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("inheritErrorHandler", toString(def.getInheritErrorHandler()), "true");
        doWriteAttribute("sticky", def.getSticky(), null);
        doWriteAttribute("maximumFailoverAttempts", def.getMaximumFailoverAttempts(), "-1");
        doWriteAttribute("roundRobin", def.getRoundRobin(), null);
        doWriteList(null, "exception", def.getExceptions(), this::doWriteString);
        endElement(name);
    }
    protected void doWriteRandomLoadBalancerDefinition(String name, RandomLoadBalancerDefinition def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        endElement(name);
    }
    protected void doWriteRoundRobinLoadBalancerDefinition(String name, RoundRobinLoadBalancerDefinition def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        endElement(name);
    }
    protected void doWriteStickyLoadBalancerDefinition(String name, StickyLoadBalancerDefinition def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteElement("correlationExpression", def.getCorrelationExpression(), this::doWriteExpressionSubElementDefinition);
        endElement(name);
    }
    protected void doWriteTopicLoadBalancerDefinition(String name, TopicLoadBalancerDefinition def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        endElement(name);
    }
    protected void doWriteWeightedLoadBalancerDefinition(String name, WeightedLoadBalancerDefinition def) throws IOException {
        startElement(name);
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("distributionRatioDelimiter", def.getDistributionRatioDelimiter(), ",");
        doWriteAttribute("distributionRatio", def.getDistributionRatio(), null);
        doWriteAttribute("roundRobin", def.getRoundRobin(), null);
        endElement(name);
    }
    protected void doWriteApiKeyDefinition(String name, ApiKeyDefinition def) throws IOException {
        startElement(name);
        doWriteRestSecurityDefinitionAttributes(def);
        doWriteAttribute("inHeader", def.getInHeader(), null);
        doWriteAttribute("inCookie", def.getInCookie(), null);
        doWriteAttribute("name", def.getName(), null);
        doWriteAttribute("inQuery", def.getInQuery(), null);
        endElement(name);
    }
    protected void doWriteBasicAuthDefinition(String name, BasicAuthDefinition def) throws IOException {
        startElement(name);
        doWriteRestSecurityDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWriteBearerTokenDefinition(String name, BearerTokenDefinition def) throws IOException {
        startElement(name);
        doWriteRestSecurityDefinitionAttributes(def);
        doWriteAttribute("format", def.getFormat(), null);
        endElement(name);
    }
    protected void doWriteDeleteDefinition(String name, DeleteDefinition def) throws IOException {
        startElement(name);
        doWriteVerbDefinitionAttributes(def);
        doWriteVerbDefinitionElements(def);
        endElement(name);
    }
    protected void doWriteGetDefinition(String name, GetDefinition def) throws IOException {
        startElement(name);
        doWriteVerbDefinitionAttributes(def);
        doWriteVerbDefinitionElements(def);
        endElement(name);
    }
    protected void doWriteHeadDefinition(String name, HeadDefinition def) throws IOException {
        startElement(name);
        doWriteVerbDefinitionAttributes(def);
        doWriteVerbDefinitionElements(def);
        endElement(name);
    }
    protected void doWriteMutualTLSDefinition(String name, MutualTLSDefinition def) throws IOException {
        startElement(name);
        doWriteRestSecurityDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWriteOAuth2Definition(String name, OAuth2Definition def) throws IOException {
        startElement(name);
        doWriteRestSecurityDefinitionAttributes(def);
        doWriteAttribute("tokenUrl", def.getTokenUrl(), null);
        doWriteAttribute("authorizationUrl", def.getAuthorizationUrl(), null);
        doWriteAttribute("refreshUrl", def.getRefreshUrl(), null);
        doWriteAttribute("flow", def.getFlow(), null);
        doWriteList(null, "scopes", def.getScopes(), this::doWriteRestPropertyDefinition);
        endElement(name);
    }
    protected void doWriteOpenApiDefinition(String name, OpenApiDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteAttribute("mockIncludePattern", def.getMockIncludePattern(), "classpath:camel-mock/**");
        doWriteAttribute("missingOperation", def.getMissingOperation(), "fail");
        doWriteAttribute("routeId", def.getRouteId(), null);
        doWriteAttribute("apiContextPath", def.getApiContextPath(), null);
        doWriteAttribute("specification", def.getSpecification(), null);
        doWriteAttribute("disabled", def.getDisabled(), null);
        endElement(name);
    }
    protected void doWriteOpenIdConnectDefinition(String name, OpenIdConnectDefinition def) throws IOException {
        startElement(name);
        doWriteRestSecurityDefinitionAttributes(def);
        doWriteAttribute("url", def.getUrl(), null);
        endElement(name);
    }
    protected void doWriteParamDefinition(String name, ParamDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("arrayType", def.getArrayType(), "string");
        doWriteAttribute("dataFormat", def.getDataFormat(), null);
        doWriteAttribute("defaultValue", def.getDefaultValue(), null);
        doWriteAttribute("dataType", def.getDataType(), "string");
        doWriteAttribute("name", def.getName(), null);
        doWriteAttribute("description", def.getDescription(), null);
        doWriteAttribute("type", toString(def.getType()), "path");
        doWriteAttribute("collectionFormat", toString(def.getCollectionFormat()), "csv");
        doWriteAttribute("required", toString(def.getRequired()), "true");
        doWriteList("allowableValues", "value", def.getAllowableValues(), this::doWriteValueDefinition);
        doWriteList(null, "examples", def.getExamples(), this::doWriteRestPropertyDefinition);
        endElement(name);
    }
    protected void doWritePatchDefinition(String name, PatchDefinition def) throws IOException {
        startElement(name);
        doWriteVerbDefinitionAttributes(def);
        doWriteVerbDefinitionElements(def);
        endElement(name);
    }
    protected void doWritePostDefinition(String name, PostDefinition def) throws IOException {
        startElement(name);
        doWriteVerbDefinitionAttributes(def);
        doWriteVerbDefinitionElements(def);
        endElement(name);
    }
    protected void doWritePutDefinition(String name, PutDefinition def) throws IOException {
        startElement(name);
        doWriteVerbDefinitionAttributes(def);
        doWriteVerbDefinitionElements(def);
        endElement(name);
    }
    protected void doWriteResponseHeaderDefinition(String name, ResponseHeaderDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("arrayType", def.getArrayType(), "string");
        doWriteAttribute("dataFormat", def.getDataFormat(), null);
        doWriteAttribute("dataType", def.getDataType(), "string");
        doWriteAttribute("name", def.getName(), null);
        doWriteAttribute("description", def.getDescription(), null);
        doWriteAttribute("collectionFormat", toString(def.getCollectionFormat()), "csv");
        doWriteAttribute("example", def.getExample(), null);
        doWriteList("allowableValues", "value", def.getAllowableValues(), this::doWriteValueDefinition);
        endElement(name);
    }
    protected void doWriteResponseMessageDefinition(String name, ResponseMessageDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("code", def.getCode(), "200");
        doWriteAttribute("responseModel", def.getResponseModel(), null);
        doWriteAttribute("message", def.getMessage(), null);
        doWriteAttribute("contentType", def.getContentType(), null);
        doWriteList(null, "header", def.getHeaders(), this::doWriteResponseHeaderDefinition);
        doWriteList(null, "examples", def.getExamples(), this::doWriteRestPropertyDefinition);
        endElement(name);
    }
    protected void doWriteRestBindingDefinition(String name, RestBindingDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteAttribute("enableCORS", def.getEnableCORS(), "false");
        doWriteAttribute("type", def.getType(), null);
        doWriteAttribute("outType", def.getOutType(), null);
        doWriteAttribute("clientResponseValidation", def.getClientResponseValidation(), "false");
        doWriteAttribute("component", def.getComponent(), null);
        doWriteAttribute("bindingMode", def.getBindingMode(), "off");
        doWriteAttribute("enableNoContentResponse", def.getEnableNoContentResponse(), "false");
        doWriteAttribute("skipBindingOnErrorCode", def.getSkipBindingOnErrorCode(), "false");
        doWriteAttribute("clientRequestValidation", def.getClientRequestValidation(), "false");
        doWriteAttribute("produces", def.getProduces(), null);
        doWriteAttribute("consumes", def.getConsumes(), null);
        endElement(name);
    }
    protected void doWriteRestConfigurationDefinition(String name, RestConfigurationDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("scheme", def.getScheme(), null);
        doWriteAttribute("inlineRoutes", def.getInlineRoutes(), "true");
        doWriteAttribute("apiContextPath", def.getApiContextPath(), null);
        doWriteAttribute("hostNameResolver", toString(def.getHostNameResolver()), "allLocalIp");
        doWriteAttribute("skipBindingOnErrorCode", def.getSkipBindingOnErrorCode(), "false");
        doWriteAttribute("clientRequestValidation", def.getClientRequestValidation(), "false");
        doWriteAttribute("producerApiDoc", def.getProducerApiDoc(), null);
        doWriteAttribute("host", def.getHost(), null);
        doWriteAttribute("producerComponent", def.getProducerComponent(), null);
        doWriteAttribute("enableCORS", def.getEnableCORS(), "false");
        doWriteAttribute("bindingPackageScan", def.getBindingPackageScan(), null);
        doWriteAttribute("useXForwardHeaders", def.getUseXForwardHeaders(), null);
        doWriteAttribute("apiHost", def.getApiHost(), null);
        doWriteAttribute("contextPath", def.getContextPath(), null);
        doWriteAttribute("apiContextRouteId", def.getApiContextRouteId(), null);
        doWriteAttribute("clientResponseValidation", def.getClientResponseValidation(), "false");
        doWriteAttribute("component", def.getComponent(), null);
        doWriteAttribute("bindingMode", toString(def.getBindingMode()), "off");
        doWriteAttribute("port", def.getPort(), null);
        doWriteAttribute("enableNoContentResponse", def.getEnableNoContentResponse(), "false");
        doWriteAttribute("xmlDataFormat", def.getXmlDataFormat(), null);
        doWriteAttribute("apiVendorExtension", def.getApiVendorExtension(), "false");
        doWriteAttribute("apiComponent", def.getApiComponent(), null);
        doWriteAttribute("jsonDataFormat", def.getJsonDataFormat(), null);
        doWriteList(null, "consumerProperty", def.getConsumerProperties(), this::doWriteRestPropertyDefinition);
        doWriteList(null, "corsHeaders", def.getCorsHeaders(), this::doWriteRestPropertyDefinition);
        doWriteList(null, "componentProperty", def.getComponentProperties(), this::doWriteRestPropertyDefinition);
        doWriteList(null, "validationLevels", def.getValidationLevels(), this::doWriteRestPropertyDefinition);
        doWriteList(null, "apiProperty", def.getApiProperties(), this::doWriteRestPropertyDefinition);
        doWriteList(null, "endpointProperty", def.getEndpointProperties(), this::doWriteRestPropertyDefinition);
        doWriteList(null, "dataFormatProperty", def.getDataFormatProperties(), this::doWriteRestPropertyDefinition);
        endElement(name);
    }
    protected void doWriteRestDefinition(String name, RestDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteAttribute("enableCORS", def.getEnableCORS(), "false");
        doWriteAttribute("clientResponseValidation", def.getClientResponseValidation(), "false");
        doWriteAttribute("path", def.getPath(), null);
        doWriteAttribute("bindingMode", def.getBindingMode(), "off");
        doWriteAttribute("apiDocs", def.getApiDocs(), "true");
        doWriteAttribute("enableNoContentResponse", def.getEnableNoContentResponse(), "false");
        doWriteAttribute("skipBindingOnErrorCode", def.getSkipBindingOnErrorCode(), "false");
        doWriteAttribute("clientRequestValidation", def.getClientRequestValidation(), "false");
        doWriteAttribute("produces", def.getProduces(), null);
        doWriteAttribute("disabled", def.getDisabled(), null);
        doWriteAttribute("tag", def.getTag(), null);
        doWriteAttribute("consumes", def.getConsumes(), null);
        doWriteElement("openApi", def.getOpenApi(), this::doWriteOpenApiDefinition);
        doWriteList(null, "securityRequirements", def.getSecurityRequirements(), this::doWriteSecurityDefinition);
        doWriteList(null, null, def.getVerbs(), this::doWriteVerbDefinitionRef);
        doWriteElement("securityDefinitions", def.getSecurityDefinitions(), this::doWriteRestSecuritiesDefinition);
        endElement(name);
    }
    protected void doWriteRestPropertyDefinition(String name, RestPropertyDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("value", def.getValue(), null);
        doWriteAttribute("key", def.getKey(), null);
        endElement(name);
    }
    protected void doWriteRestSecuritiesDefinition(String name, RestSecuritiesDefinition def) throws IOException {
        startElement(name);
        doWriteList(null, null, def.getSecurityDefinitions(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "ApiKeyDefinition" -> doWriteApiKeyDefinition("apiKey", (ApiKeyDefinition) v);
                case "BasicAuthDefinition" -> doWriteBasicAuthDefinition("basicAuth", (BasicAuthDefinition) v);
                case "BearerTokenDefinition" -> doWriteBearerTokenDefinition("bearerToken", (BearerTokenDefinition) v);
                case "OAuth2Definition" -> doWriteOAuth2Definition("oauth2", (OAuth2Definition) v);
                case "OpenIdConnectDefinition" -> doWriteOpenIdConnectDefinition("openIdConnect", (OpenIdConnectDefinition) v);
                case "MutualTLSDefinition" -> doWriteMutualTLSDefinition("mutualTLS", (MutualTLSDefinition) v);
            }
        });
        endElement(name);
    }
    protected void doWriteRestSecurityDefinitionAttributes(RestSecurityDefinition def) throws IOException {
        doWriteAttribute("description", def.getDescription(), null);
        doWriteAttribute("key", def.getKey(), null);
    }
    protected void doWriteRestSecurityDefinition(String name, RestSecurityDefinition def) throws IOException {
        startElement(name);
        doWriteRestSecurityDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWriteRestsDefinition(String name, RestsDefinition def) throws IOException {
        startElement(name);
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteList(null, null, def.getRests(), this::doWriteRestDefinitionRef);
        endElement(name);
    }
    protected void doWriteSecurityDefinition(String name, SecurityDefinition def) throws IOException {
        startElement(name);
        doWriteAttribute("scopes", def.getScopes(), null);
        doWriteAttribute("key", def.getKey(), null);
        endElement(name);
    }
    protected void doWriteVerbDefinitionAttributes(VerbDefinition def) throws IOException {
        doWriteOptionalIdentifiedDefinitionAttributes(def);
        doWriteAttribute("enableCORS", def.getEnableCORS(), "false");
        doWriteAttribute("deprecated", def.getDeprecated(), "false");
        doWriteAttribute("streamCache", def.getStreamCache(), null);
        doWriteAttribute("type", def.getType(), null);
        doWriteAttribute("outType", def.getOutType(), null);
        doWriteAttribute("clientResponseValidation", def.getClientResponseValidation(), "false");
        doWriteAttribute("path", def.getPath(), null);
        doWriteAttribute("routeId", def.getRouteId(), null);
        doWriteAttribute("bindingMode", def.getBindingMode(), "off");
        doWriteAttribute("apiDocs", def.getApiDocs(), "true");
        doWriteAttribute("enableNoContentResponse", def.getEnableNoContentResponse(), "false");
        doWriteAttribute("skipBindingOnErrorCode", def.getSkipBindingOnErrorCode(), "false");
        doWriteAttribute("clientRequestValidation", def.getClientRequestValidation(), "false");
        doWriteAttribute("produces", def.getProduces(), null);
        doWriteAttribute("disabled", def.getDisabled(), null);
        doWriteAttribute("consumes", def.getConsumes(), null);
    }
    protected void doWriteVerbDefinitionElements(VerbDefinition def) throws IOException {
        doWriteList(null, null, def.getParams(), this::doWriteParamDefinitionRef);
        doWriteList(null, null, def.getSecurity(), this::doWriteSecurityDefinitionRef);
        doWriteList(null, null, def.getResponseMsgs(), this::doWriteResponseMessageDefinitionRef);
        doWriteElement("to", def.getTo(), this::doWriteToDefinition);
    }
    protected void doWriteVerbDefinition(String name, VerbDefinition def) throws IOException {
        startElement(name);
        doWriteVerbDefinitionAttributes(def);
        doWriteVerbDefinitionElements(def);
        endElement(name);
    }
    protected void doWriteLangChain4jCharacterTokenizerDefinition(String name, LangChain4jCharacterTokenizerDefinition def) throws IOException {
        startElement(name);
        doWriteLangChain4jTokenizerDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWriteLangChain4jLineTokenizerDefinition(String name, LangChain4jLineTokenizerDefinition def) throws IOException {
        startElement(name);
        doWriteLangChain4jTokenizerDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWriteLangChain4jParagraphTokenizerDefinition(String name, LangChain4jParagraphTokenizerDefinition def) throws IOException {
        startElement(name);
        doWriteLangChain4jTokenizerDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWriteLangChain4jSentenceTokenizerDefinition(String name, LangChain4jSentenceTokenizerDefinition def) throws IOException {
        startElement(name);
        doWriteLangChain4jTokenizerDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWriteLangChain4jTokenizerDefinitionAttributes(LangChain4jTokenizerDefinition def) throws IOException {
        doWriteIdentifiedTypeAttributes(def);
        doWriteAttribute("modelName", def.getModelName(), null);
        doWriteAttribute("maxTokens", def.getMaxTokens(), null);
        doWriteAttribute("tokenizerType", def.getTokenizerType(), null);
        doWriteAttribute("maxOverlap", def.getMaxOverlap(), null);
    }
    protected void doWriteLangChain4jTokenizerDefinition(String name, LangChain4jTokenizerDefinition def) throws IOException {
        startElement(name);
        doWriteLangChain4jTokenizerDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWriteLangChain4jWordTokenizerDefinition(String name, LangChain4jWordTokenizerDefinition def) throws IOException {
        startElement(name);
        doWriteLangChain4jTokenizerDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWriteCustomTransformerDefinition(String name, CustomTransformerDefinition def) throws IOException {
        startElement(name);
        doWriteTransformerDefinitionAttributes(def);
        doWriteAttribute("ref", def.getRef(), null);
        doWriteAttribute("className", def.getClassName(), null);
        endElement(name);
    }
    protected void doWriteDataFormatTransformerDefinition(String name, DataFormatTransformerDefinition def) throws IOException {
        startElement(name);
        doWriteTransformerDefinitionAttributes(def);
        doWriteElement(null, def.getDataFormatType(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "ASN1DataFormat" -> doWriteASN1DataFormat("asn1", (ASN1DataFormat) v);
                case "AvroDataFormat" -> doWriteAvroDataFormat("avro", (AvroDataFormat) v);
                case "BarcodeDataFormat" -> doWriteBarcodeDataFormat("barcode", (BarcodeDataFormat) v);
                case "Base64DataFormat" -> doWriteBase64DataFormat("base64", (Base64DataFormat) v);
                case "BeanioDataFormat" -> doWriteBeanioDataFormat("beanio", (BeanioDataFormat) v);
                case "BindyDataFormat" -> doWriteBindyDataFormat("bindy", (BindyDataFormat) v);
                case "CBORDataFormat" -> doWriteCBORDataFormat("cbor", (CBORDataFormat) v);
                case "CryptoDataFormat" -> doWriteCryptoDataFormat("crypto", (CryptoDataFormat) v);
                case "CsvDataFormat" -> doWriteCsvDataFormat("csv", (CsvDataFormat) v);
                case "CustomDataFormat" -> doWriteCustomDataFormat("custom", (CustomDataFormat) v);
                case "DfdlDataFormat" -> doWriteDfdlDataFormat("dfdl", (DfdlDataFormat) v);
                case "FhirJsonDataFormat" -> doWriteFhirJsonDataFormat("fhirJson", (FhirJsonDataFormat) v);
                case "FhirXmlDataFormat" -> doWriteFhirXmlDataFormat("fhirXml", (FhirXmlDataFormat) v);
                case "FlatpackDataFormat" -> doWriteFlatpackDataFormat("flatpack", (FlatpackDataFormat) v);
                case "ForyDataFormat" -> doWriteForyDataFormat("fory", (ForyDataFormat) v);
                case "GrokDataFormat" -> doWriteGrokDataFormat("grok", (GrokDataFormat) v);
                case "GzipDeflaterDataFormat" -> doWriteGzipDeflaterDataFormat("gzipDeflater", (GzipDeflaterDataFormat) v);
                case "HL7DataFormat" -> doWriteHL7DataFormat("hl7", (HL7DataFormat) v);
                case "IcalDataFormat" -> doWriteIcalDataFormat("ical", (IcalDataFormat) v);
                case "Iso8583DataFormat" -> doWriteIso8583DataFormat("iso8583", (Iso8583DataFormat) v);
                case "JacksonXMLDataFormat" -> doWriteJacksonXMLDataFormat("jacksonXml", (JacksonXMLDataFormat) v);
                case "JaxbDataFormat" -> doWriteJaxbDataFormat("jaxb", (JaxbDataFormat) v);
                case "JsonDataFormat" -> doWriteJsonDataFormat("json", (JsonDataFormat) v);
                case "JsonApiDataFormat" -> doWriteJsonApiDataFormat("jsonApi", (JsonApiDataFormat) v);
                case "LZFDataFormat" -> doWriteLZFDataFormat("lzf", (LZFDataFormat) v);
                case "MimeMultipartDataFormat" -> doWriteMimeMultipartDataFormat("mimeMultipart", (MimeMultipartDataFormat) v);
                case "ParquetAvroDataFormat" -> doWriteParquetAvroDataFormat("parquetAvro", (ParquetAvroDataFormat) v);
                case "ProtobufDataFormat" -> doWriteProtobufDataFormat("protobuf", (ProtobufDataFormat) v);
                case "RssDataFormat" -> doWriteRssDataFormat("rss", (RssDataFormat) v);
                case "SmooksDataFormat" -> doWriteSmooksDataFormat("smooks", (SmooksDataFormat) v);
                case "SoapDataFormat" -> doWriteSoapDataFormat("soap", (SoapDataFormat) v);
                case "SwiftMtDataFormat" -> doWriteSwiftMtDataFormat("swiftMt", (SwiftMtDataFormat) v);
                case "SwiftMxDataFormat" -> doWriteSwiftMxDataFormat("swiftMx", (SwiftMxDataFormat) v);
                case "SyslogDataFormat" -> doWriteSyslogDataFormat("syslog", (SyslogDataFormat) v);
                case "TarFileDataFormat" -> doWriteTarFileDataFormat("tarFile", (TarFileDataFormat) v);
                case "ThriftDataFormat" -> doWriteThriftDataFormat("thrift", (ThriftDataFormat) v);
                case "TidyMarkupDataFormat" -> doWriteTidyMarkupDataFormat("tidyMarkup", (TidyMarkupDataFormat) v);
                case "UniVocityCsvDataFormat" -> doWriteUniVocityCsvDataFormat("univocityCsv", (UniVocityCsvDataFormat) v);
                case "UniVocityFixedDataFormat" -> doWriteUniVocityFixedDataFormat("univocityFixed", (UniVocityFixedDataFormat) v);
                case "UniVocityTsvDataFormat" -> doWriteUniVocityTsvDataFormat("univocityTsv", (UniVocityTsvDataFormat) v);
                case "XMLSecurityDataFormat" -> doWriteXMLSecurityDataFormat("xmlSecurity", (XMLSecurityDataFormat) v);
                case "PGPDataFormat" -> doWritePGPDataFormat("pgp", (PGPDataFormat) v);
                case "YAMLDataFormat" -> doWriteYAMLDataFormat("yaml", (YAMLDataFormat) v);
                case "ZipDeflaterDataFormat" -> doWriteZipDeflaterDataFormat("zipDeflater", (ZipDeflaterDataFormat) v);
                case "ZipFileDataFormat" -> doWriteZipFileDataFormat("zipFile", (ZipFileDataFormat) v);
            }
        });
        endElement(name);
    }
    protected void doWriteEndpointTransformerDefinition(String name, EndpointTransformerDefinition def) throws IOException {
        startElement(name);
        doWriteTransformerDefinitionAttributes(def);
        doWriteAttribute("ref", def.getRef(), null);
        doWriteAttribute("uri", def.getUri(), null);
        endElement(name);
    }
    protected void doWriteLoadTransformerDefinition(String name, LoadTransformerDefinition def) throws IOException {
        startElement(name);
        doWriteTransformerDefinitionAttributes(def);
        doWriteAttribute("defaults", def.getDefaults(), "false");
        doWriteAttribute("packageScan", def.getPackageScan(), null);
        endElement(name);
    }
    protected void doWriteTransformerDefinitionAttributes(TransformerDefinition def) throws IOException {
        doWriteAttribute("toType", def.getToType(), null);
        doWriteAttribute("fromType", def.getFromType(), null);
        doWriteAttribute("scheme", def.getScheme(), null);
        doWriteAttribute("name", def.getName(), null);
    }
    protected void doWriteTransformerDefinition(String name, TransformerDefinition def) throws IOException {
        startElement(name);
        doWriteTransformerDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWriteTransformersDefinition(String name, TransformersDefinition def) throws IOException {
        startElement(name);
        doWriteList(null, null, def.getTransformers(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "DataFormatTransformerDefinition" -> doWriteDataFormatTransformerDefinition("dataFormatTransformer", (DataFormatTransformerDefinition) v);
                case "EndpointTransformerDefinition" -> doWriteEndpointTransformerDefinition("endpointTransformer", (EndpointTransformerDefinition) v);
                case "LoadTransformerDefinition" -> doWriteLoadTransformerDefinition("loadTransformer", (LoadTransformerDefinition) v);
                case "CustomTransformerDefinition" -> doWriteCustomTransformerDefinition("customTransformer", (CustomTransformerDefinition) v);
            }
        });
        endElement(name);
    }
    protected void doWriteCustomValidatorDefinition(String name, CustomValidatorDefinition def) throws IOException {
        startElement(name);
        doWriteValidatorDefinitionAttributes(def);
        doWriteAttribute("ref", def.getRef(), null);
        doWriteAttribute("className", def.getClassName(), null);
        endElement(name);
    }
    protected void doWriteEndpointValidatorDefinition(String name, EndpointValidatorDefinition def) throws IOException {
        startElement(name);
        doWriteValidatorDefinitionAttributes(def);
        doWriteAttribute("ref", def.getRef(), null);
        doWriteAttribute("uri", def.getUri(), null);
        endElement(name);
    }
    protected void doWritePredicateValidatorDefinition(String name, PredicateValidatorDefinition def) throws IOException {
        startElement(name);
        doWriteValidatorDefinitionAttributes(def);
        doWriteElement(null, def.getExpression(), this::doWriteExpressionDefinitionRef);
        endElement(name);
    }
    protected void doWriteValidatorDefinitionAttributes(ValidatorDefinition def) throws IOException {
        doWriteAttribute("type", def.getType(), null);
    }
    protected void doWriteValidatorDefinition(String name, ValidatorDefinition def) throws IOException {
        startElement(name);
        doWriteValidatorDefinitionAttributes(def);
        endElement(name);
    }
    protected void doWriteValidatorsDefinition(String name, ValidatorsDefinition def) throws IOException {
        startElement(name);
        doWriteList(null, null, def.getValidators(), (n, v) -> {
            switch (v.getClass().getSimpleName()) {
                case "EndpointValidatorDefinition" -> doWriteEndpointValidatorDefinition("endpointValidator", (EndpointValidatorDefinition) v);
                case "PredicateValidatorDefinition" -> doWritePredicateValidatorDefinition("predicateValidator", (PredicateValidatorDefinition) v);
                case "CustomValidatorDefinition" -> doWriteCustomValidatorDefinition("customValidator", (CustomValidatorDefinition) v);
            }
        });
        endElement(name);
    }

    protected void doWriteFromDefinitionRef(String n, FromDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "FromDefinition" -> doWriteFromDefinition("from", (FromDefinition) v);
            }
        }
    }
    protected void doWriteInputTypeDefinitionRef(String n, InputTypeDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "InputTypeDefinition" -> doWriteInputTypeDefinition("inputType", (InputTypeDefinition) v);
            }
        }
    }
    protected void doWriteOptionalIdentifiedDefinitionRef(String n, OptionalIdentifiedDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "AggregateDefinition" -> doWriteAggregateDefinition("aggregate", (AggregateDefinition) v);
                case "BeanDefinition" -> doWriteBeanDefinition("bean", (BeanDefinition) v);
                case "CatchDefinition" -> doWriteCatchDefinition("doCatch", (CatchDefinition) v);
                case "ChoiceDefinition" -> doWriteChoiceDefinition("choice", (ChoiceDefinition) v);
                case "CircuitBreakerDefinition" -> doWriteCircuitBreakerDefinition("circuitBreaker", (CircuitBreakerDefinition) v);
                case "ClaimCheckDefinition" -> doWriteClaimCheckDefinition("claimCheck", (ClaimCheckDefinition) v);
                case "ConvertBodyDefinition" -> doWriteConvertBodyDefinition("convertBodyTo", (ConvertBodyDefinition) v);
                case "ConvertHeaderDefinition" -> doWriteConvertHeaderDefinition("convertHeaderTo", (ConvertHeaderDefinition) v);
                case "ConvertVariableDefinition" -> doWriteConvertVariableDefinition("convertVariableTo", (ConvertVariableDefinition) v);
                case "DelayDefinition" -> doWriteDelayDefinition("delay", (DelayDefinition) v);
                case "DynamicRouterDefinition" -> doWriteDynamicRouterDefinition("dynamicRouter", (DynamicRouterDefinition) v);
                case "EnrichDefinition" -> doWriteEnrichDefinition("enrich", (EnrichDefinition) v);
                case "FilterDefinition" -> doWriteFilterDefinition("filter", (FilterDefinition) v);
                case "FinallyDefinition" -> doWriteFinallyDefinition("doFinally", (FinallyDefinition) v);
                case "FromDefinition" -> doWriteFromDefinition("from", (FromDefinition) v);
                case "IdempotentConsumerDefinition" -> doWriteIdempotentConsumerDefinition("idempotentConsumer", (IdempotentConsumerDefinition) v);
                case "InputTypeDefinition" -> doWriteInputTypeDefinition("inputType", (InputTypeDefinition) v);
                case "InterceptDefinition" -> doWriteInterceptDefinition("intercept", (InterceptDefinition) v);
                case "InterceptFromDefinition" -> doWriteInterceptFromDefinition("interceptFrom", (InterceptFromDefinition) v);
                case "InterceptSendToEndpointDefinition" -> doWriteInterceptSendToEndpointDefinition("interceptSendToEndpoint", (InterceptSendToEndpointDefinition) v);
                case "KameletDefinition" -> doWriteKameletDefinition("kamelet", (KameletDefinition) v);
                case "LoadBalanceDefinition" -> doWriteLoadBalanceDefinition("loadBalance", (LoadBalanceDefinition) v);
                case "LogDefinition" -> doWriteLogDefinition("log", (LogDefinition) v);
                case "LoopDefinition" -> doWriteLoopDefinition("loop", (LoopDefinition) v);
                case "MarshalDefinition" -> doWriteMarshalDefinition("marshal", (MarshalDefinition) v);
                case "MulticastDefinition" -> doWriteMulticastDefinition("multicast", (MulticastDefinition) v);
                case "OnCompletionDefinition" -> doWriteOnCompletionDefinition("onCompletion", (OnCompletionDefinition) v);
                case "OnExceptionDefinition" -> doWriteOnExceptionDefinition("onException", (OnExceptionDefinition) v);
                case "OnFallbackDefinition" -> doWriteOnFallbackDefinition("onFallback", (OnFallbackDefinition) v);
                case "OnWhenDefinition" -> doWriteOnWhenDefinition("onWhen", (OnWhenDefinition) v);
                case "OtherwiseDefinition" -> doWriteOtherwiseDefinition("otherwise", (OtherwiseDefinition) v);
                case "OutputTypeDefinition" -> doWriteOutputTypeDefinition("outputType", (OutputTypeDefinition) v);
                case "PausableDefinition" -> doWritePausableDefinition("pausable", (PausableDefinition) v);
                case "PipelineDefinition" -> doWritePipelineDefinition("pipeline", (PipelineDefinition) v);
                case "PolicyDefinition" -> doWritePolicyDefinition("policy", (PolicyDefinition) v);
                case "PollDefinition" -> doWritePollDefinition("poll", (PollDefinition) v);
                case "PollEnrichDefinition" -> doWritePollEnrichDefinition("pollEnrich", (PollEnrichDefinition) v);
                case "ProcessDefinition" -> doWriteProcessDefinition("process", (ProcessDefinition) v);
                case "RecipientListDefinition" -> doWriteRecipientListDefinition("recipientList", (RecipientListDefinition) v);
                case "RemoveHeaderDefinition" -> doWriteRemoveHeaderDefinition("removeHeader", (RemoveHeaderDefinition) v);
                case "RemoveHeadersDefinition" -> doWriteRemoveHeadersDefinition("removeHeaders", (RemoveHeadersDefinition) v);
                case "RemovePropertiesDefinition" -> doWriteRemovePropertiesDefinition("removeProperties", (RemovePropertiesDefinition) v);
                case "RemovePropertyDefinition" -> doWriteRemovePropertyDefinition("removeProperty", (RemovePropertyDefinition) v);
                case "RemoveVariableDefinition" -> doWriteRemoveVariableDefinition("removeVariable", (RemoveVariableDefinition) v);
                case "ResequenceDefinition" -> doWriteResequenceDefinition("resequence", (ResequenceDefinition) v);
                case "ResumableDefinition" -> doWriteResumableDefinition("resumable", (ResumableDefinition) v);
                case "RollbackDefinition" -> doWriteRollbackDefinition("rollback", (RollbackDefinition) v);
                case "RouteConfigurationDefinition" -> doWriteRouteConfigurationDefinition("routeConfiguration", (RouteConfigurationDefinition) v);
                case "RouteConfigurationsDefinition" -> doWriteRouteConfigurationsDefinition("routeConfigurations", (RouteConfigurationsDefinition) v);
                case "RouteDefinition" -> doWriteRouteDefinition("route", (RouteDefinition) v);
                case "RouteTemplateDefinition" -> doWriteRouteTemplateDefinition("routeTemplate", (RouteTemplateDefinition) v);
                case "RouteTemplatesDefinition" -> doWriteRouteTemplatesDefinition("routeTemplates", (RouteTemplatesDefinition) v);
                case "RoutesDefinition" -> doWriteRoutesDefinition("routes", (RoutesDefinition) v);
                case "RoutingSlipDefinition" -> doWriteRoutingSlipDefinition("routingSlip", (RoutingSlipDefinition) v);
                case "SagaDefinition" -> doWriteSagaDefinition("saga", (SagaDefinition) v);
                case "SamplingDefinition" -> doWriteSamplingDefinition("sample", (SamplingDefinition) v);
                case "ScriptDefinition" -> doWriteScriptDefinition("script", (ScriptDefinition) v);
                case "SetBodyDefinition" -> doWriteSetBodyDefinition("setBody", (SetBodyDefinition) v);
                case "SetExchangePatternDefinition" -> doWriteSetExchangePatternDefinition("setExchangePattern", (SetExchangePatternDefinition) v);
                case "SetHeaderDefinition" -> doWriteSetHeaderDefinition("setHeader", (SetHeaderDefinition) v);
                case "SetHeadersDefinition" -> doWriteSetHeadersDefinition("setHeaders", (SetHeadersDefinition) v);
                case "SetPropertyDefinition" -> doWriteSetPropertyDefinition("setProperty", (SetPropertyDefinition) v);
                case "SetVariableDefinition" -> doWriteSetVariableDefinition("setVariable", (SetVariableDefinition) v);
                case "SetVariablesDefinition" -> doWriteSetVariablesDefinition("setVariables", (SetVariablesDefinition) v);
                case "SortDefinition" -> doWriteSortDefinition("sort", (SortDefinition) v);
                case "SplitDefinition" -> doWriteSplitDefinition("split", (SplitDefinition) v);
                case "StepDefinition" -> doWriteStepDefinition("step", (StepDefinition) v);
                case "StopDefinition" -> doWriteStopDefinition("stop", (StopDefinition) v);
                case "TemplatedRoutesDefinition" -> doWriteTemplatedRoutesDefinition("templatedRoutes", (TemplatedRoutesDefinition) v);
                case "ThreadPoolProfileDefinition" -> doWriteThreadPoolProfileDefinition("threadPoolProfile", (ThreadPoolProfileDefinition) v);
                case "ThreadsDefinition" -> doWriteThreadsDefinition("threads", (ThreadsDefinition) v);
                case "ThrottleDefinition" -> doWriteThrottleDefinition("throttle", (ThrottleDefinition) v);
                case "ThrowExceptionDefinition" -> doWriteThrowExceptionDefinition("throwException", (ThrowExceptionDefinition) v);
                case "ToDefinition" -> doWriteToDefinition("to", (ToDefinition) v);
                case "ToDynamicDefinition" -> doWriteToDynamicDefinition("toD", (ToDynamicDefinition) v);
                case "TokenizerDefinition" -> doWriteTokenizerDefinition("tokenizer", (TokenizerDefinition) v);
                case "TransactedDefinition" -> doWriteTransactedDefinition("transacted", (TransactedDefinition) v);
                case "TransformDefinition" -> doWriteTransformDefinition("transform", (TransformDefinition) v);
                case "TryDefinition" -> doWriteTryDefinition("doTry", (TryDefinition) v);
                case "UnmarshalDefinition" -> doWriteUnmarshalDefinition("unmarshal", (UnmarshalDefinition) v);
                case "ValidateDefinition" -> doWriteValidateDefinition("validate", (ValidateDefinition) v);
                case "WhenDefinition" -> doWriteWhenDefinition("when", (WhenDefinition) v);
                case "WireTapDefinition" -> doWriteWireTapDefinition("wireTap", (WireTapDefinition) v);
                case "ServiceCallDefinition" -> doWriteServiceCallDefinition("serviceCall", (ServiceCallDefinition) v);
                case "DeleteDefinition" -> doWriteDeleteDefinition("delete", (DeleteDefinition) v);
                case "GetDefinition" -> doWriteGetDefinition("get", (GetDefinition) v);
                case "HeadDefinition" -> doWriteHeadDefinition("head", (HeadDefinition) v);
                case "OpenApiDefinition" -> doWriteOpenApiDefinition("openApi", (OpenApiDefinition) v);
                case "PatchDefinition" -> doWritePatchDefinition("patch", (PatchDefinition) v);
                case "PostDefinition" -> doWritePostDefinition("post", (PostDefinition) v);
                case "PutDefinition" -> doWritePutDefinition("put", (PutDefinition) v);
                case "RestBindingDefinition" -> doWriteRestBindingDefinition("restBinding", (RestBindingDefinition) v);
                case "RestDefinition" -> doWriteRestDefinition("rest", (RestDefinition) v);
                case "RestsDefinition" -> doWriteRestsDefinition("rests", (RestsDefinition) v);
            }
        }
    }
    protected void doWriteOutputTypeDefinitionRef(String n, OutputTypeDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "OutputTypeDefinition" -> doWriteOutputTypeDefinition("outputType", (OutputTypeDefinition) v);
            }
        }
    }
    protected void doWriteProcessorDefinitionRef(String n, ProcessorDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "AggregateDefinition" -> doWriteAggregateDefinition("aggregate", (AggregateDefinition) v);
                case "BeanDefinition" -> doWriteBeanDefinition("bean", (BeanDefinition) v);
                case "CatchDefinition" -> doWriteCatchDefinition("doCatch", (CatchDefinition) v);
                case "ChoiceDefinition" -> doWriteChoiceDefinition("choice", (ChoiceDefinition) v);
                case "CircuitBreakerDefinition" -> doWriteCircuitBreakerDefinition("circuitBreaker", (CircuitBreakerDefinition) v);
                case "ClaimCheckDefinition" -> doWriteClaimCheckDefinition("claimCheck", (ClaimCheckDefinition) v);
                case "ConvertBodyDefinition" -> doWriteConvertBodyDefinition("convertBodyTo", (ConvertBodyDefinition) v);
                case "ConvertHeaderDefinition" -> doWriteConvertHeaderDefinition("convertHeaderTo", (ConvertHeaderDefinition) v);
                case "ConvertVariableDefinition" -> doWriteConvertVariableDefinition("convertVariableTo", (ConvertVariableDefinition) v);
                case "DelayDefinition" -> doWriteDelayDefinition("delay", (DelayDefinition) v);
                case "DynamicRouterDefinition" -> doWriteDynamicRouterDefinition("dynamicRouter", (DynamicRouterDefinition) v);
                case "EnrichDefinition" -> doWriteEnrichDefinition("enrich", (EnrichDefinition) v);
                case "FilterDefinition" -> doWriteFilterDefinition("filter", (FilterDefinition) v);
                case "FinallyDefinition" -> doWriteFinallyDefinition("doFinally", (FinallyDefinition) v);
                case "IdempotentConsumerDefinition" -> doWriteIdempotentConsumerDefinition("idempotentConsumer", (IdempotentConsumerDefinition) v);
                case "InterceptDefinition" -> doWriteInterceptDefinition("intercept", (InterceptDefinition) v);
                case "InterceptFromDefinition" -> doWriteInterceptFromDefinition("interceptFrom", (InterceptFromDefinition) v);
                case "InterceptSendToEndpointDefinition" -> doWriteInterceptSendToEndpointDefinition("interceptSendToEndpoint", (InterceptSendToEndpointDefinition) v);
                case "KameletDefinition" -> doWriteKameletDefinition("kamelet", (KameletDefinition) v);
                case "LoadBalanceDefinition" -> doWriteLoadBalanceDefinition("loadBalance", (LoadBalanceDefinition) v);
                case "LogDefinition" -> doWriteLogDefinition("log", (LogDefinition) v);
                case "LoopDefinition" -> doWriteLoopDefinition("loop", (LoopDefinition) v);
                case "MarshalDefinition" -> doWriteMarshalDefinition("marshal", (MarshalDefinition) v);
                case "MulticastDefinition" -> doWriteMulticastDefinition("multicast", (MulticastDefinition) v);
                case "OnCompletionDefinition" -> doWriteOnCompletionDefinition("onCompletion", (OnCompletionDefinition) v);
                case "OnExceptionDefinition" -> doWriteOnExceptionDefinition("onException", (OnExceptionDefinition) v);
                case "PausableDefinition" -> doWritePausableDefinition("pausable", (PausableDefinition) v);
                case "PipelineDefinition" -> doWritePipelineDefinition("pipeline", (PipelineDefinition) v);
                case "PolicyDefinition" -> doWritePolicyDefinition("policy", (PolicyDefinition) v);
                case "PollDefinition" -> doWritePollDefinition("poll", (PollDefinition) v);
                case "PollEnrichDefinition" -> doWritePollEnrichDefinition("pollEnrich", (PollEnrichDefinition) v);
                case "ProcessDefinition" -> doWriteProcessDefinition("process", (ProcessDefinition) v);
                case "RecipientListDefinition" -> doWriteRecipientListDefinition("recipientList", (RecipientListDefinition) v);
                case "RemoveHeaderDefinition" -> doWriteRemoveHeaderDefinition("removeHeader", (RemoveHeaderDefinition) v);
                case "RemoveHeadersDefinition" -> doWriteRemoveHeadersDefinition("removeHeaders", (RemoveHeadersDefinition) v);
                case "RemovePropertiesDefinition" -> doWriteRemovePropertiesDefinition("removeProperties", (RemovePropertiesDefinition) v);
                case "RemovePropertyDefinition" -> doWriteRemovePropertyDefinition("removeProperty", (RemovePropertyDefinition) v);
                case "RemoveVariableDefinition" -> doWriteRemoveVariableDefinition("removeVariable", (RemoveVariableDefinition) v);
                case "ResequenceDefinition" -> doWriteResequenceDefinition("resequence", (ResequenceDefinition) v);
                case "ResumableDefinition" -> doWriteResumableDefinition("resumable", (ResumableDefinition) v);
                case "RollbackDefinition" -> doWriteRollbackDefinition("rollback", (RollbackDefinition) v);
                case "RouteDefinition" -> doWriteRouteDefinition("route", (RouteDefinition) v);
                case "RoutingSlipDefinition" -> doWriteRoutingSlipDefinition("routingSlip", (RoutingSlipDefinition) v);
                case "SagaDefinition" -> doWriteSagaDefinition("saga", (SagaDefinition) v);
                case "SamplingDefinition" -> doWriteSamplingDefinition("sample", (SamplingDefinition) v);
                case "ScriptDefinition" -> doWriteScriptDefinition("script", (ScriptDefinition) v);
                case "SetBodyDefinition" -> doWriteSetBodyDefinition("setBody", (SetBodyDefinition) v);
                case "SetExchangePatternDefinition" -> doWriteSetExchangePatternDefinition("setExchangePattern", (SetExchangePatternDefinition) v);
                case "SetHeaderDefinition" -> doWriteSetHeaderDefinition("setHeader", (SetHeaderDefinition) v);
                case "SetHeadersDefinition" -> doWriteSetHeadersDefinition("setHeaders", (SetHeadersDefinition) v);
                case "SetPropertyDefinition" -> doWriteSetPropertyDefinition("setProperty", (SetPropertyDefinition) v);
                case "SetVariableDefinition" -> doWriteSetVariableDefinition("setVariable", (SetVariableDefinition) v);
                case "SetVariablesDefinition" -> doWriteSetVariablesDefinition("setVariables", (SetVariablesDefinition) v);
                case "SortDefinition" -> doWriteSortDefinition("sort", (SortDefinition) v);
                case "SplitDefinition" -> doWriteSplitDefinition("split", (SplitDefinition) v);
                case "StepDefinition" -> doWriteStepDefinition("step", (StepDefinition) v);
                case "StopDefinition" -> doWriteStopDefinition("stop", (StopDefinition) v);
                case "ThreadsDefinition" -> doWriteThreadsDefinition("threads", (ThreadsDefinition) v);
                case "ThrottleDefinition" -> doWriteThrottleDefinition("throttle", (ThrottleDefinition) v);
                case "ThrowExceptionDefinition" -> doWriteThrowExceptionDefinition("throwException", (ThrowExceptionDefinition) v);
                case "ToDefinition" -> doWriteToDefinition("to", (ToDefinition) v);
                case "ToDynamicDefinition" -> doWriteToDynamicDefinition("toD", (ToDynamicDefinition) v);
                case "TokenizerDefinition" -> doWriteTokenizerDefinition("tokenizer", (TokenizerDefinition) v);
                case "TransactedDefinition" -> doWriteTransactedDefinition("transacted", (TransactedDefinition) v);
                case "TransformDefinition" -> doWriteTransformDefinition("transform", (TransformDefinition) v);
                case "TryDefinition" -> doWriteTryDefinition("doTry", (TryDefinition) v);
                case "UnmarshalDefinition" -> doWriteUnmarshalDefinition("unmarshal", (UnmarshalDefinition) v);
                case "ValidateDefinition" -> doWriteValidateDefinition("validate", (ValidateDefinition) v);
                case "WireTapDefinition" -> doWriteWireTapDefinition("wireTap", (WireTapDefinition) v);
                case "ServiceCallDefinition" -> doWriteServiceCallDefinition("serviceCall", (ServiceCallDefinition) v);
            }
        }
    }
    protected void doWriteRouteConfigurationDefinitionRef(String n, RouteConfigurationDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "RouteConfigurationDefinition" -> doWriteRouteConfigurationDefinition("routeConfiguration", (RouteConfigurationDefinition) v);
            }
        }
    }
    protected void doWriteRouteDefinitionRef(String n, RouteDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "RouteDefinition" -> doWriteRouteDefinition("route", (RouteDefinition) v);
            }
        }
    }
    protected void doWriteRouteTemplateDefinitionRef(String n, RouteTemplateDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "RouteTemplateDefinition" -> doWriteRouteTemplateDefinition("routeTemplate", (RouteTemplateDefinition) v);
            }
        }
    }
    protected void doWriteSetHeaderDefinitionRef(String n, SetHeaderDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "SetHeaderDefinition" -> doWriteSetHeaderDefinition("setHeader", (SetHeaderDefinition) v);
            }
        }
    }
    protected void doWriteSetVariableDefinitionRef(String n, SetVariableDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "SetVariableDefinition" -> doWriteSetVariableDefinition("setVariable", (SetVariableDefinition) v);
            }
        }
    }
    protected void doWriteTemplatedRouteDefinitionRef(String n, TemplatedRouteDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "TemplatedRouteDefinition" -> doWriteTemplatedRouteDefinition("templatedRoute", (TemplatedRouteDefinition) v);
            }
        }
    }
    protected void doWriteWhenDefinitionRef(String n, WhenDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "WhenDefinition" -> doWriteWhenDefinition("when", (WhenDefinition) v);
            }
        }
    }
    protected void doWriteUniVocityHeaderRef(String n, UniVocityHeader v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "UniVocityHeader" -> doWriteUniVocityHeader("univocityHeader", (UniVocityHeader) v);
            }
        }
    }
    protected void doWriteExpressionDefinitionRef(String n, ExpressionDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "CSimpleExpression" -> doWriteCSimpleExpression("csimple", (CSimpleExpression) v);
                case "ConstantExpression" -> doWriteConstantExpression("constant", (ConstantExpression) v);
                case "DatasonnetExpression" -> doWriteDatasonnetExpression("datasonnet", (DatasonnetExpression) v);
                case "ExchangePropertyExpression" -> doWriteExchangePropertyExpression("exchangeProperty", (ExchangePropertyExpression) v);
                case "ExpressionDefinition" -> doWriteExpressionDefinition("expressionDefinition", (ExpressionDefinition) v);
                case "GroovyExpression" -> doWriteGroovyExpression("groovy", (GroovyExpression) v);
                case "HeaderExpression" -> doWriteHeaderExpression("header", (HeaderExpression) v);
                case "Hl7TerserExpression" -> doWriteHl7TerserExpression("hl7terser", (Hl7TerserExpression) v);
                case "JavaExpression" -> doWriteJavaExpression("java", (JavaExpression) v);
                case "JavaScriptExpression" -> doWriteJavaScriptExpression("js", (JavaScriptExpression) v);
                case "JoorExpression" -> doWriteJoorExpression("joor", (JoorExpression) v);
                case "JqExpression" -> doWriteJqExpression("jq", (JqExpression) v);
                case "JsonPathExpression" -> doWriteJsonPathExpression("jsonpath", (JsonPathExpression) v);
                case "LanguageExpression" -> doWriteLanguageExpression("language", (LanguageExpression) v);
                case "MethodCallExpression" -> doWriteMethodCallExpression("method", (MethodCallExpression) v);
                case "MvelExpression" -> doWriteMvelExpression("mvel", (MvelExpression) v);
                case "OgnlExpression" -> doWriteOgnlExpression("ognl", (OgnlExpression) v);
                case "PythonExpression" -> doWritePythonExpression("python", (PythonExpression) v);
                case "RefExpression" -> doWriteRefExpression("ref", (RefExpression) v);
                case "SimpleExpression" -> doWriteSimpleExpression("simple", (SimpleExpression) v);
                case "SpELExpression" -> doWriteSpELExpression("spel", (SpELExpression) v);
                case "TokenizerExpression" -> doWriteTokenizerExpression("tokenize", (TokenizerExpression) v);
                case "VariableExpression" -> doWriteVariableExpression("variable", (VariableExpression) v);
                case "WasmExpression" -> doWriteWasmExpression("wasm", (WasmExpression) v);
                case "XMLTokenizerExpression" -> doWriteXMLTokenizerExpression("xtokenize", (XMLTokenizerExpression) v);
                case "XPathExpression" -> doWriteXPathExpression("xpath", (XPathExpression) v);
                case "XQueryExpression" -> doWriteXQueryExpression("xquery", (XQueryExpression) v);
            }
        }
    }
    protected void doWriteParamDefinitionRef(String n, ParamDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "ParamDefinition" -> doWriteParamDefinition("param", (ParamDefinition) v);
            }
        }
    }
    protected void doWriteResponseMessageDefinitionRef(String n, ResponseMessageDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "ResponseMessageDefinition" -> doWriteResponseMessageDefinition("responseMessage", (ResponseMessageDefinition) v);
            }
        }
    }
    protected void doWriteRestDefinitionRef(String n, RestDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "RestDefinition" -> doWriteRestDefinition("rest", (RestDefinition) v);
            }
        }
    }
    protected void doWriteSecurityDefinitionRef(String n, SecurityDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "SecurityDefinition" -> doWriteSecurityDefinition("security", (SecurityDefinition) v);
            }
        }
    }
    protected void doWriteVerbDefinitionRef(String n, VerbDefinition v) throws IOException {
        if (v != null) {
            switch (v.getClass().getSimpleName()) {
                case "DeleteDefinition" -> doWriteDeleteDefinition("delete", (DeleteDefinition) v);
                case "GetDefinition" -> doWriteGetDefinition("get", (GetDefinition) v);
                case "HeadDefinition" -> doWriteHeadDefinition("head", (HeadDefinition) v);
                case "PatchDefinition" -> doWritePatchDefinition("patch", (PatchDefinition) v);
                case "PostDefinition" -> doWritePostDefinition("post", (PostDefinition) v);
                case "PutDefinition" -> doWritePutDefinition("put", (PutDefinition) v);
            }
        }
    }

    protected void doWriteAttribute(
            String attribute,
            String value)
            throws IOException {
        doWriteAttribute(attribute, value, null);
    }
    protected void doWriteAttribute(
            String attribute,
            String value,
            String defaultValue)
            throws IOException {
        if (value != null) {
            if (defaultValue == null || !defaultValue.equals(value)) {
                attribute(attribute, value);
            }
        }
    }
    protected void doWriteValue(String value) throws IOException {
        if (value != null) {
            value(value);
        }
    }
    protected <T> void doWriteList(String wrapperName, String name, List<T> list, ElementSerializer<T> elementSerializer) throws IOException {
        if (list != null) {
            if (wrapperName != null) {
                startElement(wrapperName);
            }
            for (T v : list) {
                elementSerializer.doWriteElement(name, v);
            }
            if (wrapperName != null) {
                endElement(wrapperName);
            }
        }
    }
    protected <T> void doWriteElement(String name, T v, ElementSerializer<T> elementSerializer) throws IOException {
        if (v != null) {
            elementSerializer.doWriteElement(name, v);
        }
    }
    protected String toString(Boolean b) {
        return b != null ? b.toString() : null;
    }
    protected String toString(Enum<?> e) {
        return e != null ? e.name() : null;
    }
    protected String toString(Number n) {
        return n != null ? n.toString() : null;
    }
    protected String toString(byte[] b) {
        return b != null ? Base64.getEncoder().encodeToString(b) : null;
    }
    protected void doWriteString(String name, String value) throws IOException {
        if (value != null) {
            startElement(name);
            text(name, value);
            endElement(name);
        }
    }
    protected void doWriteNamespaces(
            NamespaceAwareExpression def)
            throws IOException {
        if (def.getNamespaceAsMap() != null) {
            for (var e : def.getNamespaceAsMap().entrySet()) {
                doWriteAttribute("xmlns:" + e.getKey(), e.getValue());
            }
        }
    }

    public interface ElementSerializer<T> {
        void doWriteElement(String name, T value) throws IOException;
    }
}
