/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.connection.SmartConnectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DelegatingConnectionFactory
implements SmartConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
InitializingBean {
    @Nullable
    private ConnectionFactory targetConnectionFactory;
    private boolean shouldStopConnections = false;

    public void setTargetConnectionFactory(@Nullable ConnectionFactory targetConnectionFactory) {
        this.targetConnectionFactory = targetConnectionFactory;
    }

    @Nullable
    public ConnectionFactory getTargetConnectionFactory() {
        return this.targetConnectionFactory;
    }

    private ConnectionFactory obtainTargetConnectionFactory() {
        ConnectionFactory target = this.getTargetConnectionFactory();
        Assert.state(target != null, "No 'targetConnectionFactory' set");
        return target;
    }

    public void setShouldStopConnections(boolean shouldStopConnections) {
        this.shouldStopConnections = shouldStopConnections;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.getTargetConnectionFactory() == null) {
            throw new IllegalArgumentException("'targetConnectionFactory' is required");
        }
    }

    @Override
    public Connection createConnection() throws JMSException {
        return this.obtainTargetConnectionFactory().createConnection();
    }

    @Override
    public Connection createConnection(String username, String password) throws JMSException {
        return this.obtainTargetConnectionFactory().createConnection(username, password);
    }

    @Override
    public QueueConnection createQueueConnection() throws JMSException {
        ConnectionFactory target = this.obtainTargetConnectionFactory();
        if (target instanceof QueueConnectionFactory) {
            QueueConnectionFactory queueFactory = (QueueConnectionFactory)target;
            return queueFactory.createQueueConnection();
        }
        Connection con = target.createConnection();
        if (!(con instanceof QueueConnection)) {
            throw new IllegalStateException("'targetConnectionFactory' is not a QueueConnectionFactory");
        }
        QueueConnection queueConnection = (QueueConnection)con;
        return queueConnection;
    }

    @Override
    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        ConnectionFactory target = this.obtainTargetConnectionFactory();
        if (target instanceof QueueConnectionFactory) {
            QueueConnectionFactory queueFactory = (QueueConnectionFactory)target;
            return queueFactory.createQueueConnection(username, password);
        }
        Connection con = target.createConnection(username, password);
        if (!(con instanceof QueueConnection)) {
            throw new IllegalStateException("'targetConnectionFactory' is not a QueueConnectionFactory");
        }
        QueueConnection queueConnection = (QueueConnection)con;
        return queueConnection;
    }

    @Override
    public TopicConnection createTopicConnection() throws JMSException {
        ConnectionFactory target = this.obtainTargetConnectionFactory();
        if (target instanceof TopicConnectionFactory) {
            TopicConnectionFactory topicFactory = (TopicConnectionFactory)target;
            return topicFactory.createTopicConnection();
        }
        Connection con = target.createConnection();
        if (!(con instanceof TopicConnection)) {
            throw new IllegalStateException("'targetConnectionFactory' is not a TopicConnectionFactory");
        }
        TopicConnection topicConnection = (TopicConnection)con;
        return topicConnection;
    }

    @Override
    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        ConnectionFactory target = this.obtainTargetConnectionFactory();
        if (target instanceof TopicConnectionFactory) {
            TopicConnectionFactory topicFactory = (TopicConnectionFactory)target;
            return topicFactory.createTopicConnection(username, password);
        }
        Connection con = target.createConnection(username, password);
        if (!(con instanceof TopicConnection)) {
            throw new IllegalStateException("'targetConnectionFactory' is not a TopicConnectionFactory");
        }
        TopicConnection topicConnection = (TopicConnection)con;
        return topicConnection;
    }

    @Override
    public JMSContext createContext() {
        return this.obtainTargetConnectionFactory().createContext();
    }

    @Override
    public JMSContext createContext(String userName, String password) {
        return this.obtainTargetConnectionFactory().createContext(userName, password);
    }

    @Override
    public JMSContext createContext(String userName, String password, int sessionMode) {
        return this.obtainTargetConnectionFactory().createContext(userName, password, sessionMode);
    }

    @Override
    public JMSContext createContext(int sessionMode) {
        return this.obtainTargetConnectionFactory().createContext(sessionMode);
    }

    @Override
    public boolean shouldStop(Connection con) {
        return this.shouldStopConnections;
    }
}

