/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.amqp.AmqpHeader;
import org.apache.activemq.transport.amqp.AmqpProtocolConverter;
import org.apache.activemq.transport.amqp.AmqpTransport;
import org.apache.activemq.transport.amqp.protocol.AmqpConnection;

public class AmqpProtocolDiscriminator
implements AmqpProtocolConverter {
    public static final int DEFAULT_PREFETCH = 1000;
    private final AmqpTransport transport;
    private final BrokerService brokerService;
    private static final ArrayList<Discriminator> DISCRIMINATORS = new ArrayList();
    private final ArrayList<Command> pendingCommands = new ArrayList();

    public AmqpProtocolDiscriminator(AmqpTransport transport, BrokerService brokerService) {
        this.transport = transport;
        this.brokerService = brokerService;
    }

    @Override
    public void onAMQPData(Object command) throws Exception {
        AmqpProtocolConverter next;
        if (command.getClass() == AmqpHeader.class) {
            AmqpHeader header = (AmqpHeader)command;
            Discriminator match = null;
            for (Discriminator discriminator : DISCRIMINATORS) {
                if (!discriminator.matches(header)) continue;
                match = discriminator;
            }
            if (match == null) {
                match = DISCRIMINATORS.get(0);
            }
            next = match.create(this.transport, this.brokerService);
            this.transport.setProtocolConverter(next);
            for (Command send : this.pendingCommands) {
                next.onActiveMQCommand(send);
            }
        } else {
            throw new IllegalStateException();
        }
        this.pendingCommands.clear();
        next.onAMQPData(command);
    }

    @Override
    public void onAMQPException(IOException error) {
        this.transport.sendToActiveMQ(error);
    }

    @Override
    public void onActiveMQCommand(Command command) throws Exception {
        this.pendingCommands.add(command);
    }

    @Override
    public void updateTracer() {
    }

    @Override
    public long keepAlive() {
        return 0L;
    }

    static {
        DISCRIMINATORS.add(new Discriminator(){

            @Override
            public AmqpProtocolConverter create(AmqpTransport transport, BrokerService brokerService) {
                return new AmqpConnection(transport, brokerService);
            }

            @Override
            public boolean matches(AmqpHeader header) {
                switch (header.getProtocolId()) {
                    case 0: 
                    case 3: {
                        if (header.getMajor() != 1 || header.getMinor() != 0 || header.getRevision() != 0) break;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    static interface Discriminator {
        public boolean matches(AmqpHeader var1);

        public AmqpProtocolConverter create(AmqpTransport var1, BrokerService var2);
    }
}

