/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: ByteArrayAspect.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2004/06/21 10:23:31 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.representation;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;
import org.ten60.netkernel.layer1.meta.*;
import java.io.*;

/**
 * A byte array implementation of IAspectReadableBinaryStream
 * optimised to work with either ByteArrayOutputStream or a raw
 * array of bytes.
 * @author  tab
 */
public class ByteArrayAspect implements IAspectReadableBinaryStream
{
	private ByteArrayOutputStream mBAOS;
	private byte[] mBytes;
	private String mEncoding;
	
	/** Construct a new ByteArrayAspect from a ByteArrayOutputStream
	 */
	public ByteArrayAspect(ByteArrayOutputStream aBAOS)
	{	this(aBAOS, "UTF-8");
	}
	/** Construct a new ByteArrayAspect from a byte[]
	 */
	public ByteArrayAspect(byte[] aBytes)
	{	this(aBytes, "UTF-8");
	}
	/** Construct a new ByteArrayAspect from a ByteArrayOutputStream with encoding
	 */
	public ByteArrayAspect(ByteArrayOutputStream aBAOS, String aEncoding)
	{	mBAOS=aBAOS;
		mEncoding=aEncoding;
	}
	/** Construct a new ByteArrayAspect from a byte[] with encoding
	 */
	public ByteArrayAspect(byte[] aBytes, String aEncoding)
	{	mBytes=aBytes;
		mEncoding=aEncoding;
	}
	
	/** returns the number of available bytes to read
	 */
	public int getContentLength()
	{	int result;
		if (mBAOS!=null)
		{	result = mBAOS.size();
		}
		else
		{	result = mBytes.length;
		}
		return result;
	}
	
	/** return and input stream over the bytes
	 */
	public InputStream getInputStream() throws IOException
	{	if (mBytes==null)
		{	mBytes = mBAOS.toByteArray();
			mBAOS=null;
		}
		return new ByteArrayInputStream(mBytes);
	}
	
	/** writes the bytes to the given output stream
	 */
	public void write(OutputStream aStream) throws IOException
	{	if (mBAOS!=null)
		{	mBAOS.writeTo(aStream);
		}
		else
		{	aStream.write(mBytes);
		}
		aStream.flush();
	}
	
	/** Creates an IURRepresentation from a ByteArrayOutputStream
	 * @deprecated
	 */
	public static IURRepresentation create(IURMeta aMeta, ByteArrayOutputStream aBAOS)
	{	return new MonoRepresentationImpl(aMeta, new ByteArrayAspect(aBAOS));
	}
	/** Creates an IURRepresentation from a byte[]
	 * @deprecated
	 */
	public static IURRepresentation create(IURMeta aMeta, byte[] aByteArray)
	{	return new MonoRepresentationImpl(aMeta, new ByteArrayAspect(aByteArray));
	}
	/** Creates an IURRepresentation from a ByteArrayOutputStream
	 * @deprecated
	 */
	public static IURRepresentation create(IURMeta aMeta, ByteArrayOutputStream aBAOS, String aEncoding)
	{	return new MonoRepresentationImpl(aMeta, new ByteArrayAspect(aBAOS, aEncoding));
	}
	/** Creates an IURRepresentation from a byte[]
	 * @deprecated
	 */
	public static IURRepresentation create(IURMeta aMeta, byte[] aByteArray, String aEncoding)
	{	return new MonoRepresentationImpl(aMeta, new ByteArrayAspect(aByteArray, aEncoding));
	}
	
	/* Get encoding */
	public String getEncoding()
	{	return mEncoding;
	}
	
}