/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: NKFTransportHelperImpl.java,v $
 * Version:       $Name:  $ $Revision: 1.2 $
 * Last Modified: $Date: 2004/08/19 15:46:17 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.nkf.impl;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.scheduler.Scheduler;
import com.ten60.netkernel.util.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.transport.*;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.representation.SimpleRepresentationImpl;
import org.ten60.netkernel.layer1.meta.AccessorMeta;
import com.ten60.netkernel.urrequest.URRequest;
/**
 * Transport specific helper which communicates via Transport Manager
 * @author  tab
 */
public class NKFTransportHelperImpl extends NKFHelperImpl
{
	TransportManager mManager;
	ITransport mTransport;
	
	/** Creates a new instance of NKFTransportHelperImpl */
	public NKFTransportHelperImpl(Container aContainer, IRequestorContext aContext, ITransport aTransport)
	{	super(aContainer, aContext, null);
		mTransport = aTransport;
		mManager = (TransportManager)aContainer.getComponent(TransportManager.URI);
	}
	
	protected void innerIssueAsyncRequest(URRequest aRequest)
	{	NetKernelException ex=mManager.handleAsyncRequest(aRequest,mTransport);
		if (ex!=null)
		{	// problem occured- need to tell requestor
			IURRequestor requestor = aRequest.getRequestor();
			URResult result = new URResult(aRequest,NetKernelExceptionAspect.create(ex));
			requestor.receiveAsyncException(result);
		}
	}
	
	protected IURRepresentation innerIssueSyncRequest(URRequest aRequest) throws NetKernelException
	{	IURRepresentation result = mManager.handleRequest(aRequest, mTransport);
		if (result.hasAspect(IAspectNetKernelException.class))
		{	IAspectNetKernelException ex= (IAspectNetKernelException)result.getAspect(IAspectNetKernelException.class);
			throw ex.getException();
		}
		return result;
	}	
}