/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: AbstractSchemeAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.3 $
 * Last Modified: $Date: 2004/06/21 10:23:31 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.accessor;

import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.urii.aspect.NetKernelExceptionAspect;

import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.representation.MonoRepresentationImpl;
/**
 * Implementor of abstract: scheme, things that don't exist, all you can do is confirm their
 * non-existence.
 * @author  tab
 */
public class AbstractSchemeAccessor extends AccessorImpl
{
	public static final URIdentifier NULL_URIDENTIFIER=new URIdentifier("abstract:null");
	private static final int VALID_TYPES=URRequest.RQT_EXISTS|URRequest.RQT_SOURCE;
	
	/** Creates a new instance of AbstractSchemeAccessor */
	public AbstractSchemeAccessor()
	{	super(new ActiveAccessorMeta(2, true)
		{		public boolean supportsRequestType(int aRequestType)
				{	return (aRequestType|VALID_TYPES)==VALID_TYPES;
				}
		});
	}
	
	public void requestAsync(URRequest aRequest)
	{	switch(aRequest.getType())
		{	case URRequest.RQT_EXISTS:
			{	IURMeta meta = new TimedExpiryMeta("application/boolean", TimedExpiryMeta.ONE_YEAR, 1);
				IURAspect aspect = new BooleanAspect(false);
				IURRepresentation resource =  new MonoRepresentationImpl(meta,aspect);
				URResult result = new URResult(aRequest, resource);
				getScheduler().receiveAsyncResult(result);
			}
			break;
			case URRequest.RQT_SOURCE:
			{	NetKernelException ex=new NetKernelException("Cannot SOURCE "+aRequest.getURI().toString());
				IURRepresentation resource = NetKernelExceptionAspect.create(ex);
				URResult result = new URResult(aRequest, resource);
				getScheduler().receiveAsyncException(result);
			}
			break;
		}
	}
}