<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : form_sysadmin_newuser.xsl
    Created on : 24 October 2003, 15:50
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

	<xsl:param name="param"/>
	
<xsl:template match="/">

<div>
<xsl:apply-templates select="descendant::error"/>

<form action="xrl:sysadmin_process_newuser" xrl:resolve="action" method="POST" xmlns:xrl="http://1060.org/xrl">
<table>
<tr>
<td>Userid</td><td>
	<input name="userid">
		<xsl:attribute name="value"><xsl:value-of select="$param/nvp/userid"/></xsl:attribute>
	</input>
</td>
</tr>
<tr>
<td>First Name</td><td>
	<input name="firstname" >
		<xsl:attribute name="value"><xsl:value-of select="$param/nvp/firstname"/></xsl:attribute>
	</input>
</td>
</tr>
<tr>
<td>Last Name</td><td>
	<input name="lastname">
		<xsl:attribute name="value"><xsl:value-of select="$param/nvp/lastname"/></xsl:attribute>
	</input>
</td>
</tr>
<tr>
<td>Email</td><td>
	<input name="email" style="width: 200px;">
	<xsl:attribute name="value"><xsl:value-of select="$param/nvp/email"/></xsl:attribute>
	</input>
</td>
</tr>
<tr>
<td>Web</td><td>
	<input name="web" style="width: 200px;">
		<xsl:attribute name="value"><xsl:value-of select="$param/nvp/web"/></xsl:attribute>
	</input>
</td>
</tr>
<tr>
<td>Password</td><td><input name="password" type="password"/></td>
</tr>
<tr>
<td>Password Confirm</td><td><input name="password2" type="password"/></td>
</tr>
<tr>
<td>Password reminder question</td><td>
	<input name="reminder" style="width: 300px;">
		<xsl:attribute name="value">
		<xsl:choose>
			<xsl:when test="$param/nvp/reminder">
				<xsl:value-of select="$param/nvp/reminder"/>
			</xsl:when>
			<xsl:otherwise>What is your favourite colour?</xsl:otherwise>
		</xsl:choose>
		</xsl:attribute>
	</input>
	</td>
</tr>
<tr>
<td>Password reminder answer</td><td>
<input name="answer">
		<xsl:attribute name="value">
		<xsl:choose>
			<xsl:when test="$param/nvp/answer">
				<xsl:value-of select="$param/nvp/answer"/>
			</xsl:when>
			<xsl:otherwise>purple</xsl:otherwise>
		</xsl:choose>
		</xsl:attribute>
	</input>
</td>
</tr>
<tr>
<td colspan="2"><input type="submit"/></td>
</tr>
</table>
</form>
</div>

</xsl:template>

<xsl:template match="error">
	<div style="background-color:#ff5555;">
	<xsl:copy-of select="*"/>
	</div>
</xsl:template>

</xsl:stylesheet> 
